/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.FontConfiguration;
import sun.awt.SunToolkit;
import sun.awt.X11GraphicsDevice;
import sun.awt.motif.MFontConfiguration;
import sun.font.FontManager;
import sun.font.NativeFont;
import sun.java2d.SunGraphicsEnvironment;
import sun.java2d.xr.XRSurfaceData;
import sun.security.action.GetPropertyAction;

public class X11GraphicsEnvironment
extends SunGraphicsEnvironment {
    private static final Logger log = Logger.getLogger("sun.awt.X11GraphicsEnvironment");
    private static final Logger screenLog = Logger.getLogger("sun.awt.screen.X11GraphicsEnvironment");
    private static Boolean xinerState;
    private static HashSet<String> fontConfigDirs;
    private static Map fontNameMap;
    private static Map xFontDirsMap;
    private static Map xlfdMap;
    private static HashMap registeredDirs;
    private static String[] fontdirs;
    private static boolean glxAvailable;
    private static boolean glxVerbose;
    private static boolean xRenderVerbose;
    private static boolean xRenderAvailable;
    private Boolean isDisplayLocal;
    HashMap<String, String> oblmap = null;
    private static final int FOUNDRY_FIELD = 1;
    private static final int FAMILY_NAME_FIELD = 2;
    private static final int WEIGHT_NAME_FIELD = 3;
    private static final int SLANT_FIELD = 4;
    private static final int SETWIDTH_NAME_FIELD = 5;
    private static final int ADD_STYLE_NAME_FIELD = 6;
    private static final int PIXEL_SIZE_FIELD = 7;
    private static final int POINT_SIZE_FIELD = 8;
    private static final int RESOLUTION_X_FIELD = 9;
    private static final int RESOLUTION_Y_FIELD = 10;
    private static final int SPACING_FIELD = 11;
    private static final int AVERAGE_WIDTH_FIELD = 12;
    private static final int CHARSET_REGISTRY_FIELD = 13;
    private static final int CHARSET_ENCODING_FIELD = 14;

    private static native boolean initGLX();

    public static boolean isGLXAvailable() {
        return glxAvailable;
    }

    public static boolean isGLXVerbose() {
        return glxVerbose;
    }

    private static native boolean initXRender();

    public static boolean isXRenderAvailable() {
        return xRenderAvailable;
    }

    public static boolean isXRenderVerbose() {
        return xRenderVerbose;
    }

    private static native int checkShmExt();

    private static native String getDisplayString();

    private static native void initDisplay(boolean var0);

    protected native int getNumScreens();

    protected GraphicsDevice makeScreenDevice(int screennum) {
        return new X11GraphicsDevice(screennum);
    }

    protected native int getDefaultScreenNum();

    public GraphicsDevice getDefaultScreenDevice() {
        return this.getScreenDevices()[this.getDefaultScreenNum()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisplayLocal() {
        if (this.isDisplayLocal == null) {
            SunToolkit.awtLock();
            try {
                if (this.isDisplayLocal == null) {
                    this.isDisplayLocal = X11GraphicsEnvironment._isDisplayLocal();
                }
            }
            finally {
                SunToolkit.awtUnlock();
            }
        }
        return this.isDisplayLocal;
    }

    private static boolean _isDisplayLocal() {
        if (X11GraphicsEnvironment.isHeadless()) {
            return true;
        }
        String isRemote = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.remote"));
        if (isRemote != null) {
            return isRemote.equals("false");
        }
        int shm = X11GraphicsEnvironment.checkShmExt();
        if (shm != -1) {
            return shm == 1;
        }
        String display = X11GraphicsEnvironment.getDisplayString();
        int ind = display.indexOf(58);
        final String hostName = display.substring(0, ind);
        if (ind <= 0) {
            return true;
        }
        Boolean result = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                InetAddress[] remAddr = null;
                Enumeration<InetAddress> locals = null;
                Enumeration<NetworkInterface> interfaces = null;
                try {
                    interfaces = NetworkInterface.getNetworkInterfaces();
                    remAddr = InetAddress.getAllByName(hostName);
                    if (remAddr == null) {
                        return Boolean.FALSE;
                    }
                }
                catch (UnknownHostException e) {
                    System.err.println("Unknown host: " + hostName);
                    return Boolean.FALSE;
                }
                catch (SocketException e1) {
                    System.err.println(e1.getMessage());
                    return Boolean.FALSE;
                }
                while (interfaces.hasMoreElements()) {
                    locals = interfaces.nextElement().getInetAddresses();
                    while (locals.hasMoreElements()) {
                        for (int i = 0; i < remAddr.length; ++i) {
                            if (!((Object)locals.nextElement()).equals(remAddr[i])) continue;
                            return Boolean.TRUE;
                        }
                    }
                }
                return Boolean.FALSE;
            }
        });
        return result;
    }

    private String getObliqueLucidaFontID(String fontID) {
        if (fontID.startsWith("-lucidasans-medium-i-normal") || fontID.startsWith("-lucidasans-bold-i-normal") || fontID.startsWith("-lucidatypewriter-medium-i-normal") || fontID.startsWith("-lucidatypewriter-bold-i-normal")) {
            return fontID.substring(0, fontID.indexOf("-i-"));
        }
        return null;
    }

    private void initObliqueLucidaFontMap() {
        this.oblmap = new HashMap();
        this.oblmap.put("-lucidasans-medium", jreLibDirName + "/fonts/LucidaSansRegular.ttf");
        this.oblmap.put("-lucidasans-bold", jreLibDirName + "/fonts/LucidaSansDemiBold.ttf");
        this.oblmap.put("-lucidatypewriter-medium", jreLibDirName + "/fonts/LucidaTypewriterRegular.ttf");
        this.oblmap.put("-lucidatypewriter-bold", jreLibDirName + "/fonts/LucidaTypewriterBold.ttf");
    }

    public String getFileNameFromPlatformName(String platName) {
        String fileName = null;
        String fontID = this.specificFontIDForName(platName);
        fileName = super.getFileNameFromPlatformName(platName);
        if (fileName != null) {
            if (X11GraphicsEnvironment.isHeadless() && fileName.startsWith("-")) {
                return null;
            }
            if (fileName.startsWith("/")) {
                Vector<String> xVal = (Vector<String>)xlfdMap.get(fileName);
                if (xVal == null) {
                    if (this.getFontConfiguration().needToSearchForFile(fileName)) {
                        fileName = null;
                    }
                    if (fileName != null) {
                        xVal = new Vector<String>();
                        xVal.add(platName);
                        xlfdMap.put(fileName, xVal);
                    }
                } else if (!xVal.contains(platName)) {
                    xVal.add(platName);
                }
            }
            if (fileName != null) {
                fontNameMap.put(fontID, fileName);
                return fileName;
            }
        }
        if (fontID != null) {
            fileName = (String)fontNameMap.get(fontID);
            if (fileName == null && isLinux && !X11GraphicsEnvironment.isOpenJDK()) {
                String oblkey;
                if (this.oblmap == null) {
                    this.initObliqueLucidaFontMap();
                }
                if ((oblkey = this.getObliqueLucidaFontID(fontID)) != null) {
                    fileName = this.oblmap.get(oblkey);
                }
            }
            if (!(this.fontPath != null || fileName != null && fileName.startsWith("/"))) {
                if (debugFonts) {
                    logger.warning("** Registering all font paths because can't find file for " + platName);
                }
                this.fontPath = this.getPlatformFontPath(noType1Font);
                this.registerFontDirs(this.fontPath);
                if (debugFonts) {
                    logger.warning("** Finished registering all font paths");
                }
                fileName = (String)fontNameMap.get(fontID);
            }
            if (fileName == null && !X11GraphicsEnvironment.isHeadless()) {
                fileName = X11GraphicsEnvironment.getX11FontName(platName);
            }
            if (fileName == null) {
                fontID = this.switchFontIDForName(platName);
                fileName = (String)fontNameMap.get(fontID);
            }
            if (fileName != null) {
                fontNameMap.put(fontID, fileName);
            }
        }
        return fileName;
    }

    private static String getX11FontName(String platName) {
        String xlfd = platName.replaceAll("%d", "*");
        if (NativeFont.fontExists(xlfd)) {
            return xlfd;
        }
        return null;
    }

    public String getFileNameFromXLFD(String name) {
        String fileName = null;
        String fontID = this.specificFontIDForName(name);
        if (fontID != null) {
            fileName = (String)fontNameMap.get(fontID);
            if (fileName == null) {
                fontID = this.switchFontIDForName(name);
                fileName = (String)fontNameMap.get(fontID);
            }
            if (fileName == null) {
                fileName = this.getDefaultFontFile();
            }
        }
        return fileName;
    }

    private String switchFontIDForName(String name) {
        int[] hPos = new int[14];
        int hyphenCnt = 1;
        int pos = 1;
        while (pos != -1 && hyphenCnt < 14) {
            if ((pos = name.indexOf(45, pos)) == -1) continue;
            hPos[hyphenCnt++] = pos++;
        }
        if (hyphenCnt != 14) {
            if (debugFonts) {
                logger.severe("Font Configuration Font ID is malformed:" + name);
            }
            return name;
        }
        String slant = name.substring(hPos[3] + 1, hPos[4]);
        String family = name.substring(hPos[1] + 1, hPos[2]);
        String registry = name.substring(hPos[12] + 1, hPos[13]);
        String encoding = name.substring(hPos[13] + 1);
        if (slant.equals("i")) {
            slant = "o";
        } else if (slant.equals("o")) {
            slant = "i";
        }
        if (family.equals("itc zapfdingbats") && registry.equals("sun") && encoding.equals("fontspecific")) {
            registry = "adobe";
        }
        StringBuffer sb = new StringBuffer(name.substring(hPos[1], hPos[3] + 1));
        sb.append(slant);
        sb.append(name.substring(hPos[4], hPos[5] + 1));
        sb.append(registry);
        sb.append(name.substring(hPos[13]));
        String retval = sb.toString().toLowerCase(Locale.ENGLISH);
        return retval;
    }

    private String specificFontIDForName(String name) {
        int[] hPos = new int[14];
        int hyphenCnt = 1;
        int pos = 1;
        while (pos != -1 && hyphenCnt < 14) {
            if ((pos = name.indexOf(45, pos)) == -1) continue;
            hPos[hyphenCnt++] = pos++;
        }
        if (hyphenCnt != 14) {
            if (debugFonts) {
                logger.severe("Font Configuration Font ID is malformed:" + name);
            }
            return name;
        }
        StringBuffer sb = new StringBuffer(name.substring(hPos[1], hPos[5]));
        sb.append(name.substring(hPos[12]));
        String retval = sb.toString().toLowerCase(Locale.ENGLISH);
        return retval;
    }

    protected String[] getNativeNames(String fontFileName, String platformName) {
        Vector nativeNames = (Vector)xlfdMap.get(fontFileName);
        if (nativeNames == null) {
            if (platformName == null) {
                return null;
            }
            String[] natNames = new String[]{platformName};
            return natNames;
        }
        int len = nativeNames.size();
        return nativeNames.toArray(new String[len]);
    }

    protected void addFontToPlatformFontPath(String platformName) {
        String fontID;
        String dirName;
        if (xFontDirsMap != null && (dirName = (String)xFontDirsMap.get(fontID = this.specificFontIDForName(platformName))) != null) {
            fontConfigDirs.add(dirName);
        }
    }

    protected void getPlatformFontPathFromFontConfig() {
        if (fontConfigDirs == null) {
            fontConfigDirs = this.getFontConfiguration().getAWTFontPathSet();
            if (debugFonts && fontConfigDirs != null) {
                String[] names = fontConfigDirs.toArray(new String[0]);
                for (int i = 0; i < names.length; ++i) {
                    logger.info("awtfontpath : " + names[i]);
                }
            }
        }
    }

    protected void registerPlatformFontsUsedByFontConfiguration() {
        if (fontConfigDirs == null) {
            return;
        }
        if (isLinux) {
            fontConfigDirs.add(jreLibDirName + File.separator + "oblique-fonts");
        }
        fontdirs = fontConfigDirs.toArray(new String[0]);
    }

    public static void setNativeFontPath() {
        if (fontdirs == null) {
            return;
        }
        for (int i = 0; i < fontdirs.length; ++i) {
            if (debugFonts) {
                logger.info("Add " + fontdirs[i] + " to X11 fontpath");
            }
            FontManager.setNativeFontPath(fontdirs[i]);
        }
    }

    protected void registerFontDirs(String pathName) {
        StringTokenizer parser = new StringTokenizer(pathName, File.pathSeparator);
        try {
            while (parser.hasMoreTokens()) {
                String dirPath = parser.nextToken();
                if (dirPath == null || registeredDirs.containsKey(dirPath)) continue;
                registeredDirs.put(dirPath, null);
                this.registerFontDir(dirPath);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerFontDir(String path) {
        block27: {
            if (debugFonts) {
                logger.info("ParseFontDir " + path);
            }
            File fontsDotDir = new File(path + File.separator + "fonts.dir");
            InputStreamReader fr = null;
            try {
                if (!fontsDotDir.canRead()) break block27;
                fr = new FileReader(fontsDotDir);
                BufferedReader br = new BufferedReader(fr, 8192);
                StreamTokenizer st = new StreamTokenizer(br);
                st.eolIsSignificant(true);
                int ttype = st.nextToken();
                if (ttype == -2) {
                    int numEntries = (int)st.nval;
                    ttype = st.nextToken();
                    if (ttype == 10) {
                        st.resetSyntax();
                        st.wordChars(32, 127);
                        st.wordChars(160, 255);
                        st.whitespaceChars(0, 31);
                        for (int i = 0; i < numEntries && (ttype = st.nextToken()) != -1 && ttype == -3; ++i) {
                            int breakPos = st.sval.indexOf(32);
                            if (breakPos <= 0) {
                                ++numEntries;
                                ttype = st.nextToken();
                                if (ttype == 10) continue;
                                break;
                            }
                            if (st.sval.charAt(0) == '!') {
                                ++numEntries;
                                ttype = st.nextToken();
                                if (ttype == 10) continue;
                                break;
                            }
                            String fileName = st.sval.substring(0, breakPos);
                            int lastColon = fileName.lastIndexOf(58);
                            if (lastColon > 0) {
                                if (lastColon + 1 >= fileName.length()) continue;
                                fileName = fileName.substring(lastColon + 1);
                            }
                            String fontPart = st.sval.substring(breakPos + 1);
                            String fontID = this.specificFontIDForName(fontPart);
                            String sVal = (String)fontNameMap.get(fontID);
                            if (debugFonts) {
                                logger.info("file=" + fileName + " xlfd=" + fontPart);
                                logger.info("fontID=" + fontID + " sVal=" + sVal);
                            }
                            String fullPath = null;
                            try {
                                File file = new File(path, fileName);
                                if (xFontDirsMap == null) {
                                    xFontDirsMap = new HashMap();
                                }
                                xFontDirsMap.put(fontID, path);
                                fullPath = file.getCanonicalPath();
                            }
                            catch (IOException e) {
                                fullPath = path + File.separator + fileName;
                            }
                            Vector<String> xVal = (Vector<String>)xlfdMap.get(fullPath);
                            if (debugFonts) {
                                logger.info("fullPath=" + fullPath + " xVal=" + xVal);
                            }
                            if ((xVal == null || !xVal.contains(fontPart)) && sVal == null || !sVal.startsWith("/")) {
                                if (debugFonts) {
                                    logger.info("Map fontID:" + fontID + "to file:" + fullPath);
                                }
                                fontNameMap.put(fontID, fullPath);
                                if (xVal == null) {
                                    xVal = new Vector<String>();
                                    xlfdMap.put(fullPath, xVal);
                                }
                                xVal.add(fontPart);
                            }
                            if ((ttype = st.nextToken()) != 10) break;
                        }
                    }
                }
                fr.close();
            }
            catch (IOException ioe1) {
            }
            finally {
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (IOException ioe2) {}
                }
            }
        }
    }

    public void loadFonts() {
        super.loadFonts();
        xFontDirsMap = null;
        xlfdMap = new HashMap(1);
        fontNameMap = new HashMap(1);
    }

    protected FontConfiguration createFontConfiguration() {
        return new MFontConfiguration(this);
    }

    public FontConfiguration createFontConfiguration(boolean preferLocaleFonts, boolean preferPropFonts) {
        return new MFontConfiguration(this, preferLocaleFonts, preferPropFonts);
    }

    public String getDefaultFontFaceName() {
        return null;
    }

    private static native boolean pRunningXinerama();

    private static native Point getXineramaCenterPoint();

    public Point getCenterPoint() {
        Point p;
        if (this.runningXinerama() && (p = X11GraphicsEnvironment.getXineramaCenterPoint()) != null) {
            return p;
        }
        return super.getCenterPoint();
    }

    public Rectangle getMaximumWindowBounds() {
        if (this.runningXinerama()) {
            return this.getXineramaWindowBounds();
        }
        return super.getMaximumWindowBounds();
    }

    public boolean runningXinerama() {
        if (xinerState == null) {
            xinerState = X11GraphicsEnvironment.pRunningXinerama();
            if (screenLog.isLoggable(Level.FINER)) {
                screenLog.log(Level.FINER, "Running Xinerama: " + xinerState);
            }
        }
        return xinerState;
    }

    protected Rectangle getXineramaWindowBounds() {
        Point center = this.getCenterPoint();
        GraphicsDevice[] gds = this.getScreenDevices();
        Rectangle centerMonitorRect = null;
        Rectangle unionRect = X11GraphicsEnvironment.getUsableBounds(gds[0]);
        for (int i = 0; i < gds.length; ++i) {
            Rectangle tempRect = X11GraphicsEnvironment.getUsableBounds(gds[i]);
            if (centerMonitorRect == null && tempRect.width / 2 + tempRect.x > center.x - 1 && tempRect.height / 2 + tempRect.y > center.y - 1 && tempRect.width / 2 + tempRect.x < center.x + 1 && tempRect.height / 2 + tempRect.y < center.y + 1) {
                centerMonitorRect = tempRect;
            }
            unionRect = unionRect.union(tempRect);
        }
        if (unionRect.width / 2 + unionRect.x > center.x - 1 && unionRect.height / 2 + unionRect.y > center.y - 1 && unionRect.width / 2 + unionRect.x < center.x + 1 && unionRect.height / 2 + unionRect.y < center.y + 1) {
            if (screenLog.isLoggable(Level.FINER)) {
                screenLog.log(Level.FINER, "Video Wall: center point is at center of all displays.");
            }
            return unionRect;
        }
        if (centerMonitorRect != null) {
            if (screenLog.isLoggable(Level.FINER)) {
                screenLog.log(Level.FINER, "Center point at center of a particular monitor, but not of the entire virtual display.");
            }
            return centerMonitorRect;
        }
        if (screenLog.isLoggable(Level.FINER)) {
            screenLog.log(Level.FINER, "Center point is somewhere strange - return union of all bounds.");
        }
        return unionRect;
    }

    public void paletteChanged() {
    }

    static {
        fontConfigDirs = null;
        fontNameMap = new HashMap();
        xlfdMap = new HashMap();
        registeredDirs = new HashMap();
        fontdirs = null;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("awt");
                if (!GraphicsEnvironment.isHeadless()) {
                    boolean glxRequested = false;
                    String prop = System.getProperty("sun.java2d.opengl");
                    if (prop != null) {
                        if (prop.equals("true") || prop.equals("t")) {
                            glxRequested = true;
                        } else if (prop.equals("True") || prop.equals("T")) {
                            glxRequested = true;
                            glxVerbose = true;
                        }
                    }
                    boolean xRenderRequested = false;
                    String xProp = System.getProperty("sun.java2d.xrender");
                    if (xProp != null) {
                        if (xProp.equals("true") || xProp.equals("t")) {
                            xRenderRequested = true;
                        } else if (xProp.equals("True") || xProp.equals("T")) {
                            xRenderRequested = true;
                            xRenderVerbose = true;
                        }
                    }
                    X11GraphicsEnvironment.initDisplay(glxRequested);
                    if (glxRequested) {
                        glxAvailable = X11GraphicsEnvironment.initGLX();
                        if (glxVerbose && !glxAvailable) {
                            System.out.println("Could not enable OpenGL pipeline (GLX 1.3 not available)");
                        }
                    }
                    if (xRenderRequested) {
                        xRenderAvailable = X11GraphicsEnvironment.initXRender();
                        if (xRenderVerbose && !xRenderAvailable) {
                            System.out.println("Could not enable XRender pipeline");
                        }
                    }
                    if (xRenderAvailable) {
                        XRSurfaceData.initXRSurfaceData();
                    }
                }
                return null;
            }
        });
    }
}

