/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DropTargetContextPeer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.ToolkitThreadBlockedHandler;
import sun.awt.dnd.SunDropTargetEvent;

public abstract class SunDropTargetContextPeer
implements DropTargetContextPeer,
Transferable {
    public static final boolean DISPATCH_SYNC = true;
    private DropTarget currentDT;
    private DropTargetContext currentDTC;
    private long[] currentT;
    private int currentA;
    private int currentSA;
    private int currentDA;
    private int previousDA;
    private long nativeDragContext;
    private Transferable local;
    private boolean dragRejected = false;
    protected int dropStatus = 0;
    protected boolean dropComplete = false;
    protected static final Object _globalLock = new Object();
    private static final Logger dndLog = Logger.getLogger("sun.awt.dnd.SunDropTargetContextPeer");
    protected static Transferable currentJVMLocalSourceTransferable = null;
    protected static final int STATUS_NONE = 0;
    protected static final int STATUS_WAIT = 1;
    protected static final int STATUS_ACCEPT = 2;
    protected static final int STATUS_REJECT = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentJVMLocalSourceTransferable(Transferable t) throws InvalidDnDOperationException {
        Object object = _globalLock;
        synchronized (object) {
            if (t != null && currentJVMLocalSourceTransferable != null) {
                throw new InvalidDnDOperationException();
            }
            currentJVMLocalSourceTransferable = t;
        }
    }

    private static Transferable getJVMLocalSourceTransferable() {
        return currentJVMLocalSourceTransferable;
    }

    public DropTarget getDropTarget() {
        return this.currentDT;
    }

    public synchronized void setTargetActions(int actions2) {
        this.currentA = actions2 & 0x40000003;
    }

    public int getTargetActions() {
        return this.currentA;
    }

    public Transferable getTransferable() {
        return this;
    }

    public DataFlavor[] getTransferDataFlavors() {
        Transferable localTransferable = this.local;
        if (localTransferable != null) {
            return localTransferable.getTransferDataFlavors();
        }
        return DataTransferer.getInstance().getFlavorsForFormatsAsArray(this.currentT, DataTransferer.adaptFlavorMap(this.currentDT.getFlavorMap()));
    }

    public boolean isDataFlavorSupported(DataFlavor df) {
        Transferable localTransferable = this.local;
        if (localTransferable != null) {
            return localTransferable.isDataFlavorSupported(df);
        }
        return DataTransferer.getInstance().getFlavorsForFormats(this.currentT, DataTransferer.adaptFlavorMap(this.currentDT.getFlavorMap())).containsKey(df);
    }

    public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException, InvalidDnDOperationException {
        SecurityManager sm = System.getSecurityManager();
        try {
            if (!this.dropComplete && sm != null) {
                sm.checkSystemClipboardAccess();
            }
        }
        catch (Exception e) {
            Thread currentThread = Thread.currentThread();
            currentThread.getUncaughtExceptionHandler().uncaughtException(currentThread, e);
            return null;
        }
        Long lFormat = null;
        Transferable localTransferable = this.local;
        if (localTransferable != null) {
            return localTransferable.getTransferData(df);
        }
        if (this.dropStatus != 2 || this.dropComplete) {
            throw new InvalidDnDOperationException("No drop current");
        }
        Map flavorMap = DataTransferer.getInstance().getFlavorsForFormats(this.currentT, DataTransferer.adaptFlavorMap(this.currentDT.getFlavorMap()));
        lFormat = (Long)flavorMap.get(df);
        if (lFormat == null) {
            throw new UnsupportedFlavorException(df);
        }
        if (df.isRepresentationClassRemote() && this.currentDA != 0x40000000) {
            throw new InvalidDnDOperationException("only ACTION_LINK is permissable for transfer of java.rmi.Remote objects");
        }
        long format = lFormat;
        Object ret = this.getNativeData(format);
        if (ret instanceof byte[]) {
            try {
                return DataTransferer.getInstance().translateBytes((byte[])ret, df, format, this);
            }
            catch (IOException e) {
                throw new InvalidDnDOperationException(e.getMessage());
            }
        }
        if (ret instanceof InputStream) {
            try {
                return DataTransferer.getInstance().translateStream((InputStream)ret, df, format, this);
            }
            catch (IOException e) {
                throw new InvalidDnDOperationException(e.getMessage());
            }
        }
        throw new IOException("no native data was transfered");
    }

    protected abstract Object getNativeData(long var1) throws IOException;

    public boolean isTransferableJVMLocal() {
        return this.local != null || SunDropTargetContextPeer.getJVMLocalSourceTransferable() != null;
    }

    private int handleEnterMessage(Component component, int x, int y, int dropAction, int actions2, long[] formats, long nativeCtxt) {
        return this.postDropTargetEvent(component, x, y, dropAction, actions2, formats, nativeCtxt, 504, true);
    }

    protected void processEnterMessage(SunDropTargetEvent event) {
        Component c = (Component)event.getSource();
        DropTarget dt = c.getDropTarget();
        Point hots = event.getPoint();
        this.local = SunDropTargetContextPeer.getJVMLocalSourceTransferable();
        if (this.currentDTC != null) {
            this.currentDTC.removeNotify();
            this.currentDTC = null;
        }
        if (c.isShowing() && dt != null && dt.isActive()) {
            this.currentDT = dt;
            this.currentDTC = this.currentDT.getDropTargetContext();
            this.currentDTC.addNotify(this);
            this.currentA = dt.getDefaultActions();
            try {
                dt.dragEnter(new DropTargetDragEvent(this.currentDTC, hots, this.currentDA, this.currentSA));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.currentDA = 0;
            }
        } else {
            this.currentDT = null;
            this.currentDTC = null;
            this.currentDA = 0;
            this.currentSA = 0;
            this.currentA = 0;
        }
    }

    private void handleExitMessage(Component component, long nativeCtxt) {
        this.postDropTargetEvent(component, 0, 0, 0, 0, null, nativeCtxt, 505, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processExitMessage(SunDropTargetEvent event) {
        Component c = (Component)event.getSource();
        DropTarget dt = c.getDropTarget();
        DropTargetContext dtc = null;
        if (dt == null) {
            this.currentDT = null;
            this.currentT = null;
            if (this.currentDTC != null) {
                this.currentDTC.removeNotify();
            }
            this.currentDTC = null;
            return;
        }
        if (dt != this.currentDT) {
            if (this.currentDTC != null) {
                this.currentDTC.removeNotify();
            }
            this.currentDT = dt;
            this.currentDTC = dt.getDropTargetContext();
            this.currentDTC.addNotify(this);
        }
        dtc = this.currentDTC;
        if (dt.isActive()) {
            try {
                dt.dragExit(new DropTargetEvent(dtc));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.currentA = 0;
                this.currentSA = 0;
                this.currentDA = 0;
                this.currentDT = null;
                this.currentT = null;
                this.currentDTC.removeNotify();
                this.currentDTC = null;
                this.local = null;
                this.dragRejected = false;
            }
        }
    }

    private int handleMotionMessage(Component component, int x, int y, int dropAction, int actions2, long[] formats, long nativeCtxt) {
        return this.postDropTargetEvent(component, x, y, dropAction, actions2, formats, nativeCtxt, 506, true);
    }

    protected void processMotionMessage(SunDropTargetEvent event, boolean operationChanged) {
        Component c = (Component)event.getSource();
        Point hots = event.getPoint();
        int id = event.getID();
        DropTarget dt = c.getDropTarget();
        DropTargetContext dtc = null;
        if (c.isShowing() && dt != null && dt.isActive()) {
            if (this.currentDT != dt) {
                if (this.currentDTC != null) {
                    this.currentDTC.removeNotify();
                }
                this.currentDT = dt;
                this.currentDTC = null;
            }
            if ((dtc = this.currentDT.getDropTargetContext()) != this.currentDTC) {
                if (this.currentDTC != null) {
                    this.currentDTC.removeNotify();
                }
                this.currentDTC = dtc;
                this.currentDTC.addNotify(this);
            }
            this.currentA = this.currentDT.getDefaultActions();
            try {
                DropTargetDragEvent dtde = new DropTargetDragEvent(dtc, hots, this.currentDA, this.currentSA);
                DropTarget dtl = dt;
                if (operationChanged) {
                    dtl.dropActionChanged(dtde);
                } else {
                    dtl.dragOver(dtde);
                }
                if (this.dragRejected) {
                    this.currentDA = 0;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.currentDA = 0;
            }
        } else {
            this.currentDA = 0;
        }
    }

    private void handleDropMessage(Component component, int x, int y, int dropAction, int actions2, long[] formats, long nativeCtxt) {
        this.postDropTargetEvent(component, x, y, dropAction, actions2, formats, nativeCtxt, 502, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDropMessage(SunDropTargetEvent event) {
        Component c = (Component)event.getSource();
        Point hots = event.getPoint();
        DropTarget dt = c.getDropTarget();
        this.dropStatus = 1;
        this.dropComplete = false;
        if (c.isShowing() && dt != null && dt.isActive()) {
            DropTargetContext dtc = dt.getDropTargetContext();
            this.currentDT = dt;
            if (this.currentDTC != null) {
                this.currentDTC.removeNotify();
            }
            this.currentDTC = dtc;
            this.currentDTC.addNotify(this);
            this.currentA = dt.getDefaultActions();
            Object object = _globalLock;
            synchronized (object) {
                this.local = SunDropTargetContextPeer.getJVMLocalSourceTransferable();
                if (this.local != null) {
                    SunDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(null);
                }
            }
            try {
                dt.drop(new DropTargetDropEvent(dtc, hots, this.currentDA, this.currentSA, this.local != null));
            }
            finally {
                if (this.dropStatus == 1) {
                    this.rejectDrop();
                } else if (!this.dropComplete) {
                    this.dropComplete(false);
                }
            }
        }
        this.rejectDrop();
    }

    protected int postDropTargetEvent(Component component, int x, int y, int dropAction, int actions2, long[] formats, long nativeCtxt, int eventID, boolean dispatchType) {
        AppContext appContext = SunToolkit.targetToAppContext(component);
        EventDispatcher dispatcher = new EventDispatcher(this, dropAction, actions2, formats, nativeCtxt, dispatchType);
        SunDropTargetEvent event = new SunDropTargetEvent(component, eventID, x, y, dispatcher);
        if (dispatchType) {
            DataTransferer.getInstance().getToolkitThreadBlockedHandler().lock();
        }
        SunToolkit.postEvent(appContext, event);
        this.eventPosted(event);
        if (dispatchType) {
            while (!dispatcher.isDone()) {
                DataTransferer.getInstance().getToolkitThreadBlockedHandler().enter();
            }
            DataTransferer.getInstance().getToolkitThreadBlockedHandler().unlock();
            return dispatcher.getReturnValue();
        }
        return 0;
    }

    public synchronized void acceptDrag(int dragOperation) {
        if (this.currentDT == null) {
            throw new InvalidDnDOperationException("No Drag pending");
        }
        this.currentDA = this.mapOperation(dragOperation);
        if (this.currentDA != 0) {
            this.dragRejected = false;
        }
    }

    public synchronized void rejectDrag() {
        if (this.currentDT == null) {
            throw new InvalidDnDOperationException("No Drag pending");
        }
        this.currentDA = 0;
        this.dragRejected = true;
    }

    public synchronized void acceptDrop(int dropOperation) {
        if (dropOperation == 0) {
            throw new IllegalArgumentException("invalid acceptDrop() action");
        }
        if (this.dropStatus != 1) {
            throw new InvalidDnDOperationException("invalid acceptDrop()");
        }
        this.currentDA = this.currentA = this.mapOperation(dropOperation & this.currentSA);
        this.dropStatus = 2;
        this.dropComplete = false;
    }

    public synchronized void rejectDrop() {
        if (this.dropStatus != 1) {
            throw new InvalidDnDOperationException("invalid rejectDrop()");
        }
        this.dropStatus = -1;
        this.currentDA = 0;
        this.dropComplete(false);
    }

    private int mapOperation(int operation) {
        int[] operations = new int[]{2, 1, 0x40000000};
        int ret = 0;
        for (int i = 0; i < operations.length; ++i) {
            if ((operation & operations[i]) != operations[i]) continue;
            ret = operations[i];
            break;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dropComplete(boolean success) {
        if (this.dropStatus == 0) {
            throw new InvalidDnDOperationException("No Drop pending");
        }
        if (this.currentDTC != null) {
            this.currentDTC.removeNotify();
        }
        this.currentDT = null;
        this.currentDTC = null;
        this.currentT = null;
        this.currentA = 0;
        Object object = _globalLock;
        synchronized (object) {
            currentJVMLocalSourceTransferable = null;
        }
        this.dropStatus = 0;
        this.dropComplete = true;
        try {
            this.doDropDone(success, this.currentDA, this.local != null);
        }
        finally {
            this.currentDA = 0;
            this.nativeDragContext = 0L;
        }
    }

    protected abstract void doDropDone(boolean var1, int var2, boolean var3);

    protected synchronized long getNativeDragContext() {
        return this.nativeDragContext;
    }

    protected void eventPosted(SunDropTargetEvent e) {
    }

    protected void eventProcessed(SunDropTargetEvent e, int returnValue, boolean dispatcherDone) {
    }

    static /* synthetic */ long[] access$202(SunDropTargetContextPeer x0, long[] x1) {
        x0.currentT = x1;
        return x1;
    }

    protected static class EventDispatcher {
        private final SunDropTargetContextPeer peer;
        private final int dropAction;
        private final int actions;
        private final long[] formats;
        private long nativeCtxt;
        private final boolean dispatchType;
        private boolean dispatcherDone = false;
        private int returnValue = 0;
        private final HashSet eventSet = new HashSet(3);
        static final ToolkitThreadBlockedHandler handler = DataTransferer.getInstance().getToolkitThreadBlockedHandler();

        EventDispatcher(SunDropTargetContextPeer peer, int dropAction, int actions2, long[] formats, long nativeCtxt, boolean dispatchType) {
            this.peer = peer;
            this.nativeCtxt = nativeCtxt;
            this.dropAction = dropAction;
            this.actions = actions2;
            this.formats = null == formats ? null : Arrays.copyOf(formats, formats.length);
            this.dispatchType = dispatchType;
        }

        void dispatchEvent(SunDropTargetEvent e) {
            int id = e.getID();
            switch (id) {
                case 504: {
                    this.dispatchEnterEvent(e);
                    break;
                }
                case 506: {
                    this.dispatchMotionEvent(e);
                    break;
                }
                case 505: {
                    this.dispatchExitEvent(e);
                    break;
                }
                case 502: {
                    this.dispatchDropEvent(e);
                    break;
                }
                default: {
                    throw new InvalidDnDOperationException();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchEnterEvent(SunDropTargetEvent e) {
            SunDropTargetContextPeer sunDropTargetContextPeer = this.peer;
            synchronized (sunDropTargetContextPeer) {
                this.peer.previousDA = this.dropAction;
                this.peer.nativeDragContext = this.nativeCtxt;
                SunDropTargetContextPeer.access$202(this.peer, this.formats);
                this.peer.currentSA = this.actions;
                this.peer.currentDA = this.dropAction;
                this.peer.dropStatus = 2;
                this.peer.dropComplete = false;
                try {
                    this.peer.processEnterMessage(e);
                }
                finally {
                    this.peer.dropStatus = 0;
                }
                this.setReturnValue(this.peer.currentDA);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchMotionEvent(SunDropTargetEvent e) {
            SunDropTargetContextPeer sunDropTargetContextPeer = this.peer;
            synchronized (sunDropTargetContextPeer) {
                boolean operationChanged = this.peer.previousDA != this.dropAction;
                this.peer.previousDA = this.dropAction;
                this.peer.nativeDragContext = this.nativeCtxt;
                SunDropTargetContextPeer.access$202(this.peer, this.formats);
                this.peer.currentSA = this.actions;
                this.peer.currentDA = this.dropAction;
                this.peer.dropStatus = 2;
                this.peer.dropComplete = false;
                try {
                    this.peer.processMotionMessage(e, operationChanged);
                }
                finally {
                    this.peer.dropStatus = 0;
                }
                this.setReturnValue(this.peer.currentDA);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchExitEvent(SunDropTargetEvent e) {
            SunDropTargetContextPeer sunDropTargetContextPeer = this.peer;
            synchronized (sunDropTargetContextPeer) {
                this.peer.nativeDragContext = this.nativeCtxt;
                this.peer.processExitMessage(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchDropEvent(SunDropTargetEvent e) {
            SunDropTargetContextPeer sunDropTargetContextPeer = this.peer;
            synchronized (sunDropTargetContextPeer) {
                this.peer.nativeDragContext = this.nativeCtxt;
                SunDropTargetContextPeer.access$202(this.peer, this.formats);
                this.peer.currentSA = this.actions;
                this.peer.currentDA = this.dropAction;
                this.peer.processDropMessage(e);
            }
        }

        void setReturnValue(int ret) {
            this.returnValue = ret;
        }

        int getReturnValue() {
            return this.returnValue;
        }

        boolean isDone() {
            return this.eventSet.isEmpty();
        }

        void registerEvent(SunDropTargetEvent e) {
            handler.lock();
            if (!this.eventSet.add(e) && dndLog.isLoggable(Level.FINE)) {
                dndLog.log(Level.FINE, "Event is already registered: " + e);
            }
            handler.unlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unregisterEvent(SunDropTargetEvent e) {
            handler.lock();
            try {
                if (!this.eventSet.remove(e)) {
                    return;
                }
                if (this.eventSet.isEmpty()) {
                    if (!this.dispatcherDone && this.dispatchType) {
                        handler.exit();
                    }
                    this.dispatcherDone = true;
                }
            }
            finally {
                handler.unlock();
            }
            try {
                this.peer.eventProcessed(e, this.returnValue, this.dispatcherDone);
            }
            finally {
                if (this.dispatcherDone) {
                    this.nativeCtxt = 0L;
                    this.peer.nativeDragContext = 0L;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterAllEvents() {
            Object[] events = null;
            handler.lock();
            try {
                events = this.eventSet.toArray();
            }
            finally {
                handler.unlock();
            }
            if (events != null) {
                for (int i = 0; i < events.length; ++i) {
                    this.unregisterEvent((SunDropTargetEvent)events[i]);
                }
            }
        }
    }
}

