/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import sun.font.AttributeValues;
import sun.font.CoreMetrics;
import sun.font.EAttribute;
import sun.font.Underline;

public class Decoration {
    private static final int VALUES_MASK = AttributeValues.getMask(EAttribute.EFOREGROUND, EAttribute.EBACKGROUND, EAttribute.ESWAP_COLORS, EAttribute.ESTRIKETHROUGH, EAttribute.EUNDERLINE, EAttribute.EINPUT_METHOD_HIGHLIGHT, EAttribute.EINPUT_METHOD_UNDERLINE);
    private static final Decoration PLAIN = new Decoration();

    private Decoration() {
    }

    public static Decoration getPlainDecoration() {
        return PLAIN;
    }

    public static Decoration getDecoration(AttributeValues values) {
        if (values == null || !values.anyDefined(VALUES_MASK)) {
            return PLAIN;
        }
        values = values.applyIMHighlight();
        return new DecorationImpl(values.getForeground(), values.getBackground(), values.getSwapColors(), values.getStrikethrough(), Underline.getUnderline(values.getUnderline()), Underline.getUnderline(values.getInputMethodUnderline()));
    }

    public static Decoration getDecoration(Map attributes) {
        if (attributes == null) {
            return PLAIN;
        }
        return Decoration.getDecoration(AttributeValues.fromMap(attributes));
    }

    public void drawTextAndDecorations(Label label, Graphics2D g2d, float x, float y) {
        label.handleDraw(g2d, x, y);
    }

    public Rectangle2D getVisualBounds(Label label) {
        return label.handleGetVisualBounds();
    }

    public Rectangle2D getCharVisualBounds(Label label, int index) {
        return label.handleGetCharVisualBounds(index);
    }

    Shape getOutline(Label label, float x, float y) {
        return label.handleGetOutline(x, y);
    }

    private static final class DecorationImpl
    extends Decoration {
        private Paint fgPaint = null;
        private Paint bgPaint = null;
        private boolean swapColors = false;
        private boolean strikethrough = false;
        private Underline stdUnderline = null;
        private Underline imUnderline = null;

        DecorationImpl(Paint foreground, Paint background, boolean swapColors, boolean strikethrough, Underline stdUnderline, Underline imUnderline) {
            this.fgPaint = foreground;
            this.bgPaint = background;
            this.swapColors = swapColors;
            this.strikethrough = strikethrough;
            this.stdUnderline = stdUnderline;
            this.imUnderline = imUnderline;
        }

        private static boolean areEqual(Object lhs, Object rhs) {
            if (lhs == null) {
                return rhs == null;
            }
            return lhs.equals(rhs);
        }

        public boolean equals(Object rhs) {
            if (rhs == this) {
                return true;
            }
            if (rhs == null) {
                return false;
            }
            DecorationImpl other = null;
            try {
                other = (DecorationImpl)rhs;
            }
            catch (ClassCastException e) {
                return false;
            }
            if (this.swapColors != other.swapColors || this.strikethrough != other.strikethrough) {
                return false;
            }
            if (!DecorationImpl.areEqual(this.stdUnderline, other.stdUnderline)) {
                return false;
            }
            if (!DecorationImpl.areEqual(this.fgPaint, other.fgPaint)) {
                return false;
            }
            if (!DecorationImpl.areEqual(this.bgPaint, other.bgPaint)) {
                return false;
            }
            return DecorationImpl.areEqual(this.imUnderline, other.imUnderline);
        }

        public int hashCode() {
            int hc = 1;
            if (this.strikethrough) {
                hc |= 2;
            }
            if (this.swapColors) {
                hc |= 4;
            }
            if (this.stdUnderline != null) {
                hc += this.stdUnderline.hashCode();
            }
            return hc;
        }

        private float getUnderlineMaxY(CoreMetrics cm) {
            float ulBottom;
            float maxY = 0.0f;
            if (this.stdUnderline != null) {
                ulBottom = cm.underlineOffset;
                maxY = Math.max(maxY, ulBottom += this.stdUnderline.getLowerDrawLimit(cm.underlineThickness));
            }
            if (this.imUnderline != null) {
                ulBottom = cm.underlineOffset;
                maxY = Math.max(maxY, ulBottom += this.imUnderline.getLowerDrawLimit(cm.underlineThickness));
            }
            return maxY;
        }

        private void drawTextAndEmbellishments(Label label, Graphics2D g2d, float x, float y) {
            label.handleDraw(g2d, x, y);
            if (!this.strikethrough && this.stdUnderline == null && this.imUnderline == null) {
                return;
            }
            float x1 = x;
            float x2 = x1 + (float)label.getLogicalBounds().getWidth();
            CoreMetrics cm = label.getCoreMetrics();
            if (this.strikethrough) {
                Stroke savedStroke = g2d.getStroke();
                g2d.setStroke(new BasicStroke(cm.strikethroughThickness));
                float strikeY = y + cm.strikethroughOffset;
                g2d.draw(new Line2D.Float(x1, strikeY, x2, strikeY));
                g2d.setStroke(savedStroke);
            }
            float ulOffset = cm.underlineOffset;
            float ulThickness = cm.underlineThickness;
            if (this.stdUnderline != null) {
                this.stdUnderline.drawUnderline(g2d, ulThickness, x1, x2, y + ulOffset);
            }
            if (this.imUnderline != null) {
                this.imUnderline.drawUnderline(g2d, ulThickness, x1, x2, y + ulOffset);
            }
        }

        public void drawTextAndDecorations(Label label, Graphics2D g2d, float x, float y) {
            if (this.fgPaint == null && this.bgPaint == null && !this.swapColors) {
                this.drawTextAndEmbellishments(label, g2d, x, y);
            } else {
                Paint foreground;
                Paint background;
                Paint savedPaint = g2d.getPaint();
                if (this.swapColors) {
                    Color bg;
                    int brightness;
                    Paint paint = background = this.fgPaint == null ? savedPaint : this.fgPaint;
                    foreground = this.bgPaint == null ? (background instanceof Color ? ((brightness = 33 * (bg = (Color)background).getRed() + 53 * bg.getGreen() + 14 * bg.getBlue()) > 18500 ? Color.BLACK : Color.WHITE) : Color.WHITE) : this.bgPaint;
                } else {
                    foreground = this.fgPaint == null ? savedPaint : this.fgPaint;
                    background = this.bgPaint;
                }
                if (background != null) {
                    Rectangle2D bgArea = label.getLogicalBounds();
                    bgArea = new Rectangle2D.Float(x + (float)bgArea.getX(), y + (float)bgArea.getY(), (float)bgArea.getWidth(), (float)bgArea.getHeight());
                    g2d.setPaint(background);
                    g2d.fill(bgArea);
                }
                g2d.setPaint(foreground);
                this.drawTextAndEmbellishments(label, g2d, x, y);
                g2d.setPaint(savedPaint);
            }
        }

        public Rectangle2D getVisualBounds(Label label) {
            Rectangle2D visBounds = label.handleGetVisualBounds();
            if (this.swapColors || this.bgPaint != null || this.stdUnderline != null || this.imUnderline != null) {
                float minX = 0.0f;
                Rectangle2D lb = label.getLogicalBounds();
                float minY = 0.0f;
                float maxY = 0.0f;
                if (this.swapColors || this.bgPaint != null) {
                    minY = (float)lb.getY();
                    maxY = minY + (float)lb.getHeight();
                }
                maxY = Math.max(maxY, this.getUnderlineMaxY(label.getCoreMetrics()));
                Rectangle2D.Float ab = new Rectangle2D.Float(minX, minY, (float)lb.getWidth(), maxY - minY);
                visBounds.add(ab);
            }
            return visBounds;
        }

        Shape getOutline(Label label, float x, float y) {
            Shape ul;
            if (!this.strikethrough && this.stdUnderline == null && this.imUnderline == null) {
                return label.handleGetOutline(x, y);
            }
            CoreMetrics cm = label.getCoreMetrics();
            float ulThickness = cm.underlineThickness;
            Rectangle2D lb = label.getLogicalBounds();
            float x1 = x;
            float x2 = x1 + (float)lb.getWidth();
            Area area = null;
            if (this.stdUnderline != null) {
                ul = this.stdUnderline.getUnderlineShape(ulThickness, x1, x2, y);
                area = new Area(ul);
            }
            if (this.strikethrough) {
                BasicStroke stStroke = new BasicStroke(cm.strikethroughThickness);
                float shiftY = y + cm.strikethroughOffset;
                Line2D.Float line = new Line2D.Float(x1, shiftY, x2, shiftY);
                Area slArea = new Area(stStroke.createStrokedShape(line));
                if (area == null) {
                    area = slArea;
                } else {
                    area.add(slArea);
                }
            }
            if (this.imUnderline != null) {
                ul = this.imUnderline.getUnderlineShape(ulThickness, x1, x2, y);
                Area ulArea = new Area(ul);
                if (area == null) {
                    area = ulArea;
                } else {
                    area.add(ulArea);
                }
            }
            area.add(new Area(label.handleGetOutline(x, y)));
            return new GeneralPath(area);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(super.toString());
            buf.append("[");
            if (this.fgPaint != null) {
                buf.append("fgPaint: " + this.fgPaint);
            }
            if (this.bgPaint != null) {
                buf.append(" bgPaint: " + this.bgPaint);
            }
            if (this.swapColors) {
                buf.append(" swapColors: true");
            }
            if (this.strikethrough) {
                buf.append(" strikethrough: true");
            }
            if (this.stdUnderline != null) {
                buf.append(" stdUnderline: " + this.stdUnderline);
            }
            if (this.imUnderline != null) {
                buf.append(" imUnderline: " + this.imUnderline);
            }
            buf.append("]");
            return buf.toString();
        }
    }

    public static interface Label {
        public CoreMetrics getCoreMetrics();

        public Rectangle2D getLogicalBounds();

        public void handleDraw(Graphics2D var1, float var2, float var3);

        public Rectangle2D handleGetCharVisualBounds(int var1);

        public Rectangle2D handleGetVisualBounds();

        public Shape handleGetOutline(float var1, float var2);
    }
}

