/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import sun.font.CharToGlyphMapper;
import sun.font.NativeFont;
import sun.font.XMap;

public class NativeGlyphMapper
extends CharToGlyphMapper {
    NativeFont font;
    XMap xmapper;
    int numGlyphs;

    NativeGlyphMapper(NativeFont f) {
        this.font = f;
        this.xmapper = XMap.getXMapper(this.font.encoding);
        this.numGlyphs = f.getNumGlyphs();
        this.missingGlyph = 0;
    }

    public int getNumGlyphs() {
        return this.numGlyphs;
    }

    public int charToGlyph(char unicode) {
        if (unicode >= this.xmapper.convertedGlyphs.length) {
            return 0;
        }
        return this.xmapper.convertedGlyphs[unicode];
    }

    public int charToGlyph(int unicode) {
        if (unicode >= this.xmapper.convertedGlyphs.length) {
            return 0;
        }
        return this.xmapper.convertedGlyphs[unicode];
    }

    public void charsToGlyphs(int count, char[] unicodes, int[] glyphs) {
        for (int i = 0; i < count; ++i) {
            char code = unicodes[i];
            glyphs[i] = code >= this.xmapper.convertedGlyphs.length ? 0 : this.xmapper.convertedGlyphs[code];
        }
    }

    public boolean charsToGlyphsNS(int count, char[] unicodes, int[] glyphs) {
        this.charsToGlyphs(count, unicodes, glyphs);
        return false;
    }

    public void charsToGlyphs(int count, int[] unicodes, int[] glyphs) {
        for (int i = 0; i < count; ++i) {
            char code = (char)unicodes[i];
            glyphs[i] = code >= this.xmapper.convertedGlyphs.length ? 0 : this.xmapper.convertedGlyphs[code];
        }
    }
}

