/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import sun.font.AttributeValues;
import sun.font.GlyphLayout;
import sun.font.StandardGlyphVector;
import sun.font.TextLabel;
import sun.font.TextSource;

public class TextSourceLabel
extends TextLabel {
    TextSource source;
    Rectangle2D lb;
    Rectangle2D ab;
    Rectangle2D vb;
    Rectangle2D ib;
    GlyphVector gv;

    public TextSourceLabel(TextSource source) {
        this(source, null, null, null);
    }

    public TextSourceLabel(TextSource source, Rectangle2D lb, Rectangle2D ab, GlyphVector gv) {
        this.source = source;
        this.lb = lb;
        this.ab = ab;
        this.gv = gv;
    }

    public TextSource getSource() {
        return this.source;
    }

    public final Rectangle2D getLogicalBounds(float x, float y) {
        if (this.lb == null) {
            this.lb = this.createLogicalBounds();
        }
        return new Rectangle2D.Float((float)(this.lb.getX() + (double)x), (float)(this.lb.getY() + (double)y), (float)this.lb.getWidth(), (float)this.lb.getHeight());
    }

    public final Rectangle2D getVisualBounds(float x, float y) {
        if (this.vb == null) {
            this.vb = this.createVisualBounds();
        }
        return new Rectangle2D.Float((float)(this.vb.getX() + (double)x), (float)(this.vb.getY() + (double)y), (float)this.vb.getWidth(), (float)this.vb.getHeight());
    }

    public final Rectangle2D getAlignBounds(float x, float y) {
        if (this.ab == null) {
            this.ab = this.createAlignBounds();
        }
        return new Rectangle2D.Float((float)(this.ab.getX() + (double)x), (float)(this.ab.getY() + (double)y), (float)this.ab.getWidth(), (float)this.ab.getHeight());
    }

    public Rectangle2D getItalicBounds(float x, float y) {
        if (this.ib == null) {
            this.ib = this.createItalicBounds();
        }
        return new Rectangle2D.Float((float)(this.ib.getX() + (double)x), (float)(this.ib.getY() + (double)y), (float)this.ib.getWidth(), (float)this.ib.getHeight());
    }

    public Rectangle getPixelBounds(FontRenderContext frc, float x, float y) {
        return this.getGV().getPixelBounds(frc, x, y);
    }

    public AffineTransform getBaselineTransform() {
        Font font = this.source.getFont();
        if (font.hasLayoutAttributes()) {
            return AttributeValues.getBaselineTransform(font.getAttributes());
        }
        return null;
    }

    public Shape getOutline(float x, float y) {
        return this.getGV().getOutline(x, y);
    }

    public void draw(Graphics2D g, float x, float y) {
        g.drawGlyphVector(this.getGV(), x, y);
    }

    protected Rectangle2D createLogicalBounds() {
        return this.getGV().getLogicalBounds();
    }

    protected Rectangle2D createVisualBounds() {
        return this.getGV().getVisualBounds();
    }

    protected Rectangle2D createItalicBounds() {
        return this.getGV().getLogicalBounds();
    }

    protected Rectangle2D createAlignBounds() {
        return this.createLogicalBounds();
    }

    private final GlyphVector getGV() {
        if (this.gv == null) {
            this.gv = this.createGV();
        }
        return this.gv;
    }

    protected GlyphVector createGV() {
        Font font = this.source.getFont();
        FontRenderContext frc = this.source.getFRC();
        int flags = this.source.getLayoutFlags();
        char[] context = this.source.getChars();
        int start = this.source.getStart();
        int length = this.source.getLength();
        GlyphLayout gl = GlyphLayout.get(null);
        StandardGlyphVector gv = gl.layout(font, frc, context, start, length, flags, null);
        GlyphLayout.done(gl);
        return gv;
    }
}

