/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public abstract class ByteToCharSingleByte
extends ByteToCharConverter {
    protected String byteToCharTable;

    public String getByteToCharTable() {
        return this.byteToCharTable;
    }

    public int flush(char[] output, int outStart, int outEnd) {
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    public int convert(byte[] input, int inOff, int inEnd, char[] output, int outOff, int outEnd) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        this.charOff = outOff;
        this.byteOff = inOff;
        while (this.byteOff < inEnd) {
            byte byteIndex = input[this.byteOff];
            char outputChar = this.getUnicode(byteIndex);
            if (outputChar == '\ufffd') {
                if (this.subMode) {
                    outputChar = this.subChars[0];
                } else {
                    this.badInputLength = 1;
                    throw new UnknownCharacterException();
                }
            }
            if (this.charOff >= outEnd) {
                throw new ConversionBufferFullException();
            }
            output[this.charOff] = outputChar;
            ++this.charOff;
            ++this.byteOff;
        }
        return this.charOff - outOff;
    }

    protected char getUnicode(int byteIndex) {
        int n = byteIndex + 128;
        if (n >= this.byteToCharTable.length() || n < 0) {
            return '\ufffd';
        }
        return this.byteToCharTable.charAt(n);
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
    }
}

