/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.peer.ComponentPeer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.DisplayChangedListener;
import sun.awt.FontConfiguration;
import sun.awt.SunDisplayChanger;
import sun.font.CompositeFontDescriptor;
import sun.font.Font2D;
import sun.font.FontManager;
import sun.font.NativeFont;
import sun.font.PhysicalFont;
import sun.java2d.FontSupport;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SunGraphicsEnvironment
extends GraphicsEnvironment
implements FontSupport,
DisplayChangedListener {
    public static boolean isLinux;
    public static boolean isSolaris;
    public static boolean isWindows;
    public static boolean noType1Font;
    private static Font defaultFont;
    private static String defaultFontFileName;
    private static String defaultFontName;
    public static final String lucidaFontName = "Lucida Sans Regular";
    public static final String lucidaFileName = "LucidaSansRegular.ttf";
    public static boolean debugFonts;
    protected static Logger logger;
    private static ArrayList badFonts;
    public static String jreLibDirName;
    public static String jreFontDirName;
    private static HashSet<String> missingFontFiles;
    private FontConfiguration fontConfig;
    protected String fontPath;
    private boolean discoveredAllFonts = false;
    private boolean loadedAllFontFiles = false;
    protected HashSet registeredFontFiles = new HashSet();
    public static String eudcFontFileName;
    private static boolean isOpenJDK;
    protected GraphicsDevice[] screens;
    private String[] platformFontDirs;
    private Font[] allFonts;
    private static Locale systemLocale;
    private String[] allFamilies;
    private Locale lastDefaultLocale;
    public static final TTFilter ttFilter;
    public static final T1Filter t1Filter;
    protected SunDisplayChanger displayChanger = new SunDisplayChanger();

    public static boolean isOpenJDK() {
        return isOpenJDK;
    }

    public SunGraphicsEnvironment() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String osName = System.getProperty("os.name");
                if ("Linux".equals(osName)) {
                    isLinux = true;
                } else if ("SunOS".equals(osName)) {
                    isSolaris = true;
                } else if ("Windows".equals(osName)) {
                    isWindows = true;
                }
                noType1Font = "true".equals(System.getProperty("sun.java2d.noType1Font"));
                if (SunGraphicsEnvironment.isOpenJDK()) {
                    String[] fontInfo = FontManager.getDefaultPlatformFont();
                    defaultFontName = fontInfo[0];
                    defaultFontFileName = fontInfo[1];
                } else {
                    defaultFontName = SunGraphicsEnvironment.lucidaFontName;
                    if (SunGraphicsEnvironment.this.useAbsoluteFontFileNames()) {
                        defaultFontFileName = jreFontDirName + File.separator + SunGraphicsEnvironment.lucidaFileName;
                    } else {
                        defaultFontFileName = SunGraphicsEnvironment.lucidaFileName;
                    }
                }
                File badFontFile = new File(jreFontDirName + File.separator + "badfonts.txt");
                if (badFontFile.exists()) {
                    FileInputStream fis = null;
                    try {
                        String name;
                        badFonts = new ArrayList();
                        fis = new FileInputStream(badFontFile);
                        InputStreamReader isr = new InputStreamReader(fis);
                        BufferedReader br = new BufferedReader(isr);
                        while ((name = br.readLine()) != null) {
                            if (debugFonts) {
                                logger.warning("read bad font: " + name);
                            }
                            badFonts.add(name);
                        }
                    }
                    catch (IOException e) {
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                }
                if (isLinux) {
                    SunGraphicsEnvironment.this.registerFontDir(jreFontDirName);
                }
                SunGraphicsEnvironment.this.registerFontsInDir(jreFontDirName, true, 2, true, false);
                SunGraphicsEnvironment.this.registerJREFontsWithPlatform(jreFontDirName);
                SunGraphicsEnvironment.this.fontConfig = SunGraphicsEnvironment.this.createFontConfiguration();
                SunGraphicsEnvironment.this.getPlatformFontPathFromFontConfig();
                String extraFontPath = SunGraphicsEnvironment.this.fontConfig.getExtraFontPath();
                boolean prependToPath = false;
                boolean appendToPath = false;
                String dbgFontPath = System.getProperty("sun.java2d.fontpath");
                if (dbgFontPath != null) {
                    if (dbgFontPath.startsWith("prepend:")) {
                        prependToPath = true;
                        dbgFontPath = dbgFontPath.substring("prepend:".length());
                    } else if (dbgFontPath.startsWith("append:")) {
                        appendToPath = true;
                        dbgFontPath = dbgFontPath.substring("append:".length());
                    }
                }
                if (debugFonts) {
                    logger.info("JRE font directory: " + jreFontDirName);
                    logger.info("Extra font path: " + extraFontPath);
                    logger.info("Debug font path: " + dbgFontPath);
                }
                if (dbgFontPath != null) {
                    SunGraphicsEnvironment.this.fontPath = SunGraphicsEnvironment.this.getPlatformFontPath(noType1Font);
                    if (extraFontPath != null) {
                        SunGraphicsEnvironment.this.fontPath = extraFontPath + File.pathSeparator + SunGraphicsEnvironment.this.fontPath;
                    }
                    SunGraphicsEnvironment.this.fontPath = appendToPath ? SunGraphicsEnvironment.this.fontPath + File.pathSeparator + dbgFontPath : (prependToPath ? dbgFontPath + File.pathSeparator + SunGraphicsEnvironment.this.fontPath : dbgFontPath);
                    SunGraphicsEnvironment.this.registerFontDirs(SunGraphicsEnvironment.this.fontPath);
                } else if (extraFontPath != null) {
                    SunGraphicsEnvironment.this.registerFontDirs(extraFontPath);
                }
                if (isSolaris && Locale.JAPAN.equals(Locale.getDefault())) {
                    SunGraphicsEnvironment.this.registerFontDir("/usr/openwin/lib/locale/ja/X11/fonts/TT");
                }
                SunGraphicsEnvironment.this.initCompositeFonts(SunGraphicsEnvironment.this.fontConfig, null);
                defaultFont = new Font("Dialog", 0, 12);
                return null;
            }
        });
    }

    @Override
    public synchronized GraphicsDevice[] getScreenDevices() {
        GraphicsDevice[] ret = this.screens;
        if (ret == null) {
            int num = this.getNumScreens();
            ret = new GraphicsDevice[num];
            for (int i = 0; i < num; ++i) {
                ret[i] = this.makeScreenDevice(i);
            }
            this.screens = ret;
        }
        return ret;
    }

    protected abstract int getNumScreens();

    protected abstract GraphicsDevice makeScreenDevice(int var1);

    @Override
    public GraphicsDevice getDefaultScreenDevice() {
        return this.getScreenDevices()[0];
    }

    @Override
    public Graphics2D createGraphics(BufferedImage img) {
        if (img == null) {
            throw new NullPointerException("BufferedImage cannot be null");
        }
        SurfaceData sd = SurfaceData.getPrimarySurfaceData(img);
        return new SunGraphics2D(sd, Color.white, Color.black, defaultFont);
    }

    protected String getPlatformFontPath(boolean noType1Font) {
        if (this.fontPath == null) {
            this.fontPath = FontManager.getFontPath(noType1Font);
        }
        return this.fontPath;
    }

    public String[] getPlatformFontDirs() {
        if (this.platformFontDirs == null) {
            String path = this.getPlatformFontPath(noType1Font);
            StringTokenizer parser = new StringTokenizer(path, File.pathSeparator);
            ArrayList<String> pathList = new ArrayList<String>();
            try {
                while (parser.hasMoreTokens()) {
                    pathList.add(parser.nextToken());
                }
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            this.platformFontDirs = pathList.toArray(new String[0]);
        }
        return this.platformFontDirs;
    }

    protected boolean useAbsoluteFontFileNames() {
        return true;
    }

    public String getDefaultFontFile() {
        return defaultFontFileName;
    }

    public String getDefaultFontFaceName() {
        return defaultFontName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFonts() {
        if (this.discoveredAllFonts) {
            return;
        }
        Class<FontManager> clazz = FontManager.class;
        synchronized (FontManager.class) {
            if (debugFonts) {
                Thread.dumpStack();
                logger.info("SunGraphicsEnvironment.loadFonts() called");
            }
            FontManager.initialiseDeferredFonts();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (SunGraphicsEnvironment.this.fontPath == null) {
                        SunGraphicsEnvironment.this.fontPath = SunGraphicsEnvironment.this.getPlatformFontPath(noType1Font);
                        SunGraphicsEnvironment.this.registerFontDirs(SunGraphicsEnvironment.this.fontPath);
                    }
                    if (SunGraphicsEnvironment.this.fontPath != null && !FontManager.gotFontsFromPlatform()) {
                        SunGraphicsEnvironment.this.registerFontsOnPath(SunGraphicsEnvironment.this.fontPath, false, 6, false, true);
                        SunGraphicsEnvironment.this.loadedAllFontFiles = true;
                    }
                    FontManager.registerOtherFontFiles(SunGraphicsEnvironment.this.registeredFontFiles);
                    SunGraphicsEnvironment.this.discoveredAllFonts = true;
                    return null;
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFontFiles() {
        this.loadFonts();
        if (this.loadedAllFontFiles) {
            return;
        }
        Class<FontManager> clazz = FontManager.class;
        synchronized (FontManager.class) {
            if (debugFonts) {
                Thread.dumpStack();
                logger.info("loadAllFontFiles() called");
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (SunGraphicsEnvironment.this.fontPath == null) {
                        SunGraphicsEnvironment.this.fontPath = SunGraphicsEnvironment.this.getPlatformFontPath(noType1Font);
                    }
                    if (SunGraphicsEnvironment.this.fontPath != null) {
                        SunGraphicsEnvironment.this.registerFontsOnPath(SunGraphicsEnvironment.this.fontPath, false, 6, false, true);
                    }
                    SunGraphicsEnvironment.this.loadedAllFontFiles = true;
                    return null;
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private boolean isNameForRegisteredFile(String fontName) {
        String fileName = FontManager.getFileNameForFontName(fontName);
        if (fileName == null) {
            return false;
        }
        return this.registeredFontFiles.contains(fileName);
    }

    public Font[] getAllInstalledFonts() {
        if (this.allFonts == null) {
            int i;
            this.loadFonts();
            TreeMap<String, Font2D> fontMapNames = new TreeMap<String, Font2D>();
            Font2D[] allfonts = FontManager.getRegisteredFonts();
            for (int i2 = 0; i2 < allfonts.length; ++i2) {
                if (allfonts[i2] instanceof NativeFont) continue;
                fontMapNames.put(allfonts[i2].getFontName(null), allfonts[i2]);
            }
            String[] platformNames = FontManager.getFontNamesFromPlatform();
            if (platformNames != null) {
                for (int i3 = 0; i3 < platformNames.length; ++i3) {
                    if (this.isNameForRegisteredFile(platformNames[i3])) continue;
                    fontMapNames.put(platformNames[i3], null);
                }
            }
            String[] fontNames = null;
            if (fontMapNames.size() > 0) {
                fontNames = new String[fontMapNames.size()];
                Object[] keyNames = fontMapNames.keySet().toArray();
                for (i = 0; i < keyNames.length; ++i) {
                    fontNames[i] = (String)keyNames[i];
                }
            }
            Font[] fonts = new Font[fontNames.length];
            for (i = 0; i < fontNames.length; ++i) {
                fonts[i] = new Font(fontNames[i], 0, 1);
                Font2D f2d = (Font2D)fontMapNames.get(fontNames[i]);
                if (f2d == null) continue;
                FontManager.setFont2D(fonts[i], f2d.handle);
            }
            this.allFonts = fonts;
        }
        Font[] copyFonts = new Font[this.allFonts.length];
        System.arraycopy(this.allFonts, 0, copyFonts, 0, this.allFonts.length);
        return copyFonts;
    }

    @Override
    public Font[] getAllFonts() {
        Font[] installedFonts = this.getAllInstalledFonts();
        Font[] created = FontManager.getCreatedFonts();
        if (created == null || created.length == 0) {
            return installedFonts;
        }
        int newlen = installedFonts.length + created.length;
        Font[] fonts = Arrays.copyOf(installedFonts, newlen);
        System.arraycopy(created, 0, fonts, installedFonts.length, created.length);
        return fonts;
    }

    public static Locale getSystemStartupLocale() {
        if (systemLocale == null) {
            systemLocale = (Locale)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String fileEncoding = System.getProperty("file.encoding", "");
                    String sysEncoding = System.getProperty("sun.jnu.encoding");
                    if (sysEncoding != null && !sysEncoding.equals(fileEncoding)) {
                        return Locale.ROOT;
                    }
                    String language = System.getProperty("user.language", "en");
                    String country = System.getProperty("user.country", "");
                    String variant = System.getProperty("user.variant", "");
                    return new Locale(language, country, variant);
                }
            });
        }
        return systemLocale;
    }

    protected void getJREFontFamilyNames(TreeMap<String, String> familyNames, Locale requestedLocale) {
        FontManager.registerDeferredJREFonts(jreFontDirName);
        PhysicalFont[] physicalfonts = FontManager.getPhysicalFonts();
        for (int i = 0; i < physicalfonts.length; ++i) {
            if (physicalfonts[i] instanceof NativeFont) continue;
            String name = physicalfonts[i].getFamilyName(requestedLocale);
            familyNames.put(name.toLowerCase(requestedLocale), name);
        }
    }

    public String[] getInstalledFontFamilyNames(Locale requestedLocale) {
        if (requestedLocale == null) {
            requestedLocale = Locale.getDefault();
        }
        if (this.allFamilies != null && this.lastDefaultLocale != null && requestedLocale.equals(this.lastDefaultLocale)) {
            String[] copyFamilies = new String[this.allFamilies.length];
            System.arraycopy(this.allFamilies, 0, copyFamilies, 0, this.allFamilies.length);
            return copyFamilies;
        }
        TreeMap<String, String> familyNames = new TreeMap<String, String>();
        String str = "Serif";
        familyNames.put(str.toLowerCase(), str);
        str = "SansSerif";
        familyNames.put(str.toLowerCase(), str);
        str = "Monospaced";
        familyNames.put(str.toLowerCase(), str);
        str = "Dialog";
        familyNames.put(str.toLowerCase(), str);
        str = "DialogInput";
        familyNames.put(str.toLowerCase(), str);
        if (requestedLocale.equals(SunGraphicsEnvironment.getSystemStartupLocale()) && FontManager.getFamilyNamesFromPlatform(familyNames, requestedLocale)) {
            this.getJREFontFamilyNames(familyNames, requestedLocale);
        } else {
            this.loadFontFiles();
            PhysicalFont[] physicalfonts = FontManager.getPhysicalFonts();
            for (int i = 0; i < physicalfonts.length; ++i) {
                if (physicalfonts[i] instanceof NativeFont) continue;
                String name = physicalfonts[i].getFamilyName(requestedLocale);
                familyNames.put(name.toLowerCase(requestedLocale), name);
            }
        }
        String[] retval = new String[familyNames.size()];
        Object[] keyNames = familyNames.keySet().toArray();
        for (int i = 0; i < keyNames.length; ++i) {
            retval[i] = familyNames.get(keyNames[i]);
        }
        if (requestedLocale.equals(Locale.getDefault())) {
            this.lastDefaultLocale = requestedLocale;
            this.allFamilies = new String[retval.length];
            System.arraycopy(retval, 0, this.allFamilies, 0, this.allFamilies.length);
        }
        return retval;
    }

    @Override
    public String[] getAvailableFontFamilyNames(Locale requestedLocale) {
        String[] installed = this.getInstalledFontFamilyNames(requestedLocale);
        TreeMap<String, String> map = FontManager.getCreatedFontFamilyNames();
        if (map == null || map.size() == 0) {
            return installed;
        }
        for (int i = 0; i < installed.length; ++i) {
            map.put(installed[i].toLowerCase(requestedLocale), installed[i]);
        }
        String[] retval = new String[map.size()];
        Object[] keyNames = map.keySet().toArray();
        for (int i = 0; i < keyNames.length; ++i) {
            retval[i] = map.get(keyNames[i]);
        }
        return retval;
    }

    @Override
    public String[] getAvailableFontFamilyNames() {
        return this.getAvailableFontFamilyNames(Locale.getDefault());
    }

    protected String getFileNameFromPlatformName(String platformFontName) {
        return this.fontConfig.getFileNameFromPlatformName(platformFontName);
    }

    protected void registerJREFontsWithPlatform(String pathName) {
    }

    public void register1dot0Fonts() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String type1Dir = "/usr/openwin/lib/X11/fonts/Type1";
                SunGraphicsEnvironment.this.registerFontsInDir(type1Dir, true, 4, false, false);
                return null;
            }
        });
    }

    protected void registerFontDirs(String pathName) {
    }

    public void registerFontsInDir(String dirName) {
        this.registerFontsInDir(dirName, true, 2, true, false);
    }

    private void registerFontsInDir(String dirName, boolean useJavaRasterizer, int fontRank, boolean defer, boolean resolveSymLinks) {
        File pathFile = new File(dirName);
        this.addDirFonts(dirName, pathFile, ttFilter, 0, useJavaRasterizer, fontRank == 6 ? 3 : fontRank, defer, resolveSymLinks);
        this.addDirFonts(dirName, pathFile, t1Filter, 1, useJavaRasterizer, fontRank == 6 ? 4 : fontRank, defer, resolveSymLinks);
    }

    private void registerFontsOnPath(String pathName, boolean useJavaRasterizer, int fontRank, boolean defer, boolean resolveSymLinks) {
        StringTokenizer parser = new StringTokenizer(pathName, File.pathSeparator);
        try {
            while (parser.hasMoreTokens()) {
                this.registerFontsInDir(parser.nextToken(), useJavaRasterizer, fontRank, defer, resolveSymLinks);
            }
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
    }

    protected void registerFontFile(String fontFileName, String[] nativeNames, int fontRank, boolean defer) {
        if (this.registeredFontFiles.contains(fontFileName)) {
            return;
        }
        int fontFormat = ttFilter.accept(null, fontFileName) ? 0 : (t1Filter.accept(null, fontFileName) ? 1 : 5);
        this.registeredFontFiles.add(fontFileName);
        if (defer) {
            FontManager.registerDeferredFont(fontFileName, fontFileName, nativeNames, fontFormat, false, fontRank);
        } else {
            FontManager.registerFontFile(fontFileName, nativeNames, fontFormat, false, fontRank);
        }
    }

    protected void registerFontDir(String path) {
    }

    protected String[] getNativeNames(String fontFileName, String platformName) {
        return null;
    }

    private void addDirFonts(String dirName, File dirFile, FilenameFilter filter, int fontFormat, boolean useJavaRasterizer, int fontRank, boolean defer, boolean resolveSymLinks) {
        String[] ls = dirFile.list(filter);
        if (ls == null || ls.length == 0) {
            return;
        }
        String[] fontNames = new String[ls.length];
        String[][] nativeNames = new String[ls.length][];
        int fontCount = 0;
        for (int i = 0; i < ls.length; ++i) {
            File theFile = new File(dirFile, ls[i]);
            String fullName = null;
            if (resolveSymLinks) {
                try {
                    fullName = theFile.getCanonicalPath();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (fullName == null) {
                fullName = dirName + File.separator + ls[i];
            }
            if (this.registeredFontFiles.contains(fullName)) continue;
            if (badFonts != null && badFonts.contains(fullName)) {
                if (!debugFonts) continue;
                logger.warning("skip bad font " + fullName);
                continue;
            }
            this.registeredFontFiles.add(fullName);
            if (debugFonts && logger.isLoggable(Level.INFO)) {
                String message = "Registering font " + fullName;
                String[] natNames = this.getNativeNames(fullName, null);
                if (natNames == null) {
                    message = message + " with no native name";
                } else {
                    message = message + " with native name(s) " + natNames[0];
                    for (int nn = 1; nn < natNames.length; ++nn) {
                        message = message + ", " + natNames[nn];
                    }
                }
                logger.info(message);
            }
            fontNames[fontCount] = fullName;
            nativeNames[fontCount++] = this.getNativeNames(fullName, null);
        }
        FontManager.registerFonts(fontNames, nativeNames, fontCount, fontFormat, useJavaRasterizer, fontRank, defer);
    }

    protected void addToMissingFontFileList(String fileName) {
        if (missingFontFiles == null) {
            missingFontFiles = new HashSet();
        }
        missingFontFiles.add(fileName);
    }

    protected abstract FontConfiguration createFontConfiguration();

    public abstract FontConfiguration createFontConfiguration(boolean var1, boolean var2);

    private void initCompositeFonts(FontConfiguration fontConfig, ConcurrentHashMap<String, Font2D> altNameCache) {
        int numCoreFonts = fontConfig.getNumberCoreFonts();
        String[] fcFonts = fontConfig.getPlatformFontNames();
        for (int f = 0; f < fcFonts.length; ++f) {
            String platformFontName = fcFonts[f];
            String fontFileName = this.getFileNameFromPlatformName(platformFontName);
            String[] nativeNames = null;
            if (fontFileName == null) {
                fontFileName = platformFontName;
            } else {
                if (f < numCoreFonts) {
                    this.addFontToPlatformFontPath(platformFontName);
                }
                nativeNames = this.getNativeNames(fontFileName, platformFontName);
            }
            this.registerFontFile(fontFileName, nativeNames, 2, true);
        }
        this.registerPlatformFontsUsedByFontConfiguration();
        CompositeFontDescriptor[] compositeFontInfo = fontConfig.get2DCompositeFontInfo();
        for (int i = 0; i < compositeFontInfo.length; ++i) {
            CompositeFontDescriptor descriptor = compositeFontInfo[i];
            String[] componentFileNames = descriptor.getComponentFileNames();
            String[] componentFaceNames = descriptor.getComponentFaceNames();
            if (missingFontFiles != null) {
                for (int ii = 0; ii < componentFileNames.length; ++ii) {
                    if (!missingFontFiles.contains(componentFileNames[ii])) continue;
                    componentFileNames[ii] = this.getDefaultFontFile();
                    componentFaceNames[ii] = this.getDefaultFontFaceName();
                }
            }
            if (altNameCache != null) {
                FontManager.registerCompositeFont(descriptor.getFaceName(), componentFileNames, componentFaceNames, descriptor.getCoreComponentCount(), descriptor.getExclusionRanges(), descriptor.getExclusionRangeLimits(), true, altNameCache);
            } else {
                FontManager.registerCompositeFont(descriptor.getFaceName(), componentFileNames, componentFaceNames, descriptor.getCoreComponentCount(), descriptor.getExclusionRanges(), descriptor.getExclusionRangeLimits(), true);
            }
            if (!debugFonts) continue;
            logger.info("registered " + descriptor.getFaceName());
        }
    }

    protected void addFontToPlatformFontPath(String platformFontName) {
    }

    protected void registerPlatformFontsUsedByFontConfiguration() {
    }

    public static boolean isLogicalFont(Font f) {
        return FontConfiguration.isLogicalFontFamilyName(f.getFamily());
    }

    @Override
    public FontConfiguration getFontConfiguration() {
        return this.fontConfig;
    }

    public static Rectangle getUsableBounds(GraphicsDevice gd) {
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        Rectangle usableBounds = gc.getBounds();
        usableBounds.x += insets.left;
        usableBounds.y += insets.top;
        usableBounds.width -= insets.left + insets.right;
        usableBounds.height -= insets.top + insets.bottom;
        return usableBounds;
    }

    public static boolean fontSupportsDefaultEncoding(Font font) {
        return FontManager.fontSupportsDefaultEncoding(font);
    }

    public static void useAlternateFontforJALocales() {
        FontManager.useAlternateFontforJALocales();
    }

    public void createCompositeFonts(ConcurrentHashMap<String, Font2D> altNameCache, boolean preferLocale, boolean preferProportional) {
        FontConfiguration fontConfig = this.createFontConfiguration(preferLocale, preferProportional);
        this.initCompositeFonts(fontConfig, altNameCache);
    }

    protected void getPlatformFontPathFromFontConfig() {
    }

    @Override
    public void displayChanged() {
        for (GraphicsDevice gd : this.getScreenDevices()) {
            if (!(gd instanceof DisplayChangedListener)) continue;
            ((DisplayChangedListener)((Object)gd)).displayChanged();
        }
        this.displayChanger.notifyListeners();
    }

    @Override
    public void paletteChanged() {
        this.displayChanger.notifyPaletteChanged();
    }

    public abstract boolean isDisplayLocal();

    public void addDisplayChangedListener(DisplayChangedListener client) {
        this.displayChanger.add(client);
    }

    public void removeDisplayChangedListener(DisplayChangedListener client) {
        this.displayChanger.remove(client);
    }

    public boolean isFlipStrategyPreferred(ComponentPeer peer) {
        return false;
    }

    static {
        debugFonts = false;
        logger = null;
        missingFontFiles = null;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                jreLibDirName = System.getProperty("java.home", "") + File.separator + "lib";
                jreFontDirName = jreLibDirName + File.separator + "fonts";
                File lucidaFile = new File(jreFontDirName + File.separator + SunGraphicsEnvironment.lucidaFileName);
                isOpenJDK = !lucidaFile.exists();
                String debugLevel = System.getProperty("sun.java2d.debugfonts");
                if (debugLevel != null && !debugLevel.equals("false")) {
                    debugFonts = true;
                    logger = Logger.getLogger("sun.java2d");
                    if (debugLevel.equals("warning")) {
                        logger.setLevel(Level.WARNING);
                    } else if (debugLevel.equals("severe")) {
                        logger.setLevel(Level.SEVERE);
                    }
                }
                return null;
            }
        });
        systemLocale = null;
        ttFilter = new TTFilter();
        t1Filter = new T1Filter();
    }

    public static class TTorT1Filter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return ttFilter.accept(dir, name) || t1Filter.accept(dir, name);
        }
    }

    public static class T1Filter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            if (noType1Font) {
                return false;
            }
            int offset = name.length() - 4;
            if (offset <= 0) {
                return false;
            }
            return name.startsWith(".pfa", offset) || name.startsWith(".pfb", offset) || name.startsWith(".PFA", offset) || name.startsWith(".PFB", offset);
        }
    }

    public static class TTFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            int offset = name.length() - 4;
            if (offset <= 0) {
                return false;
            }
            return name.startsWith(".ttf", offset) || name.startsWith(".TTF", offset) || name.startsWith(".ttc", offset) || name.startsWith(".TTC", offset) || name.startsWith(".otf", offset) || name.startsWith(".OTF", offset);
        }
    }
}

