/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.image.ColorModel;
import sun.awt.X11ComponentPeer;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.VolatileSurfaceManager;
import sun.java2d.BackBufferCapsProvider;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.GLXGraphicsConfig;
import sun.java2d.opengl.GLXSurfaceData;
import sun.java2d.pipe.hw.ExtendedBufferCapabilities;

public class GLXVolatileSurfaceManager
extends VolatileSurfaceManager {
    private boolean accelerationEnabled;

    public GLXVolatileSurfaceManager(SunVolatileImage vImg, Object context) {
        super(vImg, context);
        int transparency = vImg.getTransparency();
        GLXGraphicsConfig gc = (GLXGraphicsConfig)vImg.getGraphicsConfig();
        this.accelerationEnabled = transparency == 1 || transparency == 3 && (gc.isCapPresent(12) || gc.isCapPresent(2));
    }

    protected boolean isAccelerationEnabled() {
        return this.accelerationEnabled;
    }

    protected SurfaceData initAcceleratedSurface() {
        GLXSurfaceData.GLXOffScreenSurfaceData sData;
        Component comp = this.vImg.getComponent();
        X11ComponentPeer peer = comp != null ? (X11ComponentPeer)((Object)comp.getPeer()) : null;
        try {
            ExtendedBufferCapabilities ebc;
            BackBufferCapsProvider provider;
            BufferCapabilities caps;
            boolean createVSynced = false;
            boolean forceback = false;
            if (this.context instanceof Boolean && (forceback = ((Boolean)this.context).booleanValue()) && peer instanceof BackBufferCapsProvider && (caps = (provider = (BackBufferCapsProvider)((Object)peer)).getBackBufferCaps()) instanceof ExtendedBufferCapabilities && (ebc = (ExtendedBufferCapabilities)caps).getVSync() == ExtendedBufferCapabilities.VSyncType.VSYNC_ON && ebc.getFlipContents() == BufferCapabilities.FlipContents.COPIED) {
                createVSynced = true;
                forceback = false;
            }
            if (forceback) {
                sData = GLXSurfaceData.createData(peer, this.vImg, 4);
            } else {
                GLXGraphicsConfig gc = (GLXGraphicsConfig)this.vImg.getGraphicsConfig();
                ColorModel cm = gc.getColorModel(this.vImg.getTransparency());
                int type = this.vImg.getForcedAccelSurfaceType();
                if (type == 0) {
                    int n = type = gc.isCapPresent(12) ? 5 : 2;
                }
                sData = createVSynced ? GLXSurfaceData.createData(peer, this.vImg, type) : GLXSurfaceData.createData(gc, this.vImg.getWidth(), this.vImg.getHeight(), cm, this.vImg, type);
            }
        }
        catch (NullPointerException ex) {
            sData = null;
        }
        catch (OutOfMemoryError er) {
            sData = null;
        }
        return sData;
    }

    protected boolean isConfigValid(GraphicsConfiguration gc) {
        return gc == null || gc == this.vImg.getGraphicsConfig();
    }

    public void initContents() {
        if (this.vImg.getForcedAccelSurfaceType() != 3) {
            super.initContents();
        }
    }
}

