/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import sun.awt.SunToolkit;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.SurfaceType;
import sun.java2d.loops.TransformBlit;
import sun.java2d.pipe.Region;
import sun.java2d.xr.XRCompositeManager;
import sun.java2d.xr.XRMaskImage;
import sun.java2d.xr.XRSurfaceData;
import sun.java2d.xr.XRUtils;

class XRPMTransformedBlit
extends TransformBlit {
    public XRPMTransformedBlit(SurfaceType srcType, SurfaceType dstType) {
        super(srcType, CompositeType.AnyAlpha, dstType);
    }

    public Rectangle getCompositeBounds(AffineTransform tr, int dstx, int dsty, int width, int height) {
        double[] compBounds = new double[]{dstx, dsty, dstx + width, dsty, dstx + width, dsty + height, dstx, dsty + height};
        tr.transform(compBounds, 0, compBounds, 0, 4);
        double minX = Math.min(compBounds[0], Math.min(compBounds[2], Math.min(compBounds[4], compBounds[6])));
        double minY = Math.min(compBounds[1], Math.min(compBounds[3], Math.min(compBounds[5], compBounds[7])));
        double maxX = Math.max(compBounds[0], Math.max(compBounds[2], Math.max(compBounds[4], compBounds[6])));
        double maxY = Math.max(compBounds[1], Math.max(compBounds[3], Math.max(compBounds[5], compBounds[7])));
        minX = Math.floor(minX);
        minY = Math.floor(minY);
        maxX = Math.ceil(maxX);
        maxY = Math.ceil(maxY);
        return new Rectangle((int)minX, (int)minY, (int)(maxX - minX), (int)(maxY - minY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Transform(SurfaceData src, SurfaceData dst, Composite comp, Region clip, AffineTransform xform, int hint, int srcx, int srcy, int dstx, int dsty, int width, int height) {
        try {
            SunToolkit.awtLock();
            int filter = XRUtils.ATransOpToXRQuality(hint);
            XRSurfaceData x11sdDst = (XRSurfaceData)dst;
            x11sdDst.validateAsDestination(null, clip);
            XRSurfaceData x11sdSrc = (XRSurfaceData)src;
            x11sdDst.maskBuffer.validateCompositeState(comp, null, null, null);
            Rectangle bounds = this.getCompositeBounds(xform, dstx, dsty, width, height);
            AffineTransform trx = AffineTransform.getTranslateInstance(-bounds.x, -bounds.y);
            trx.concatenate(xform);
            AffineTransform maskTX = (AffineTransform)trx.clone();
            trx.translate(-srcx, -srcy);
            try {
                trx.invert();
            }
            catch (NoninvertibleTransformException ex) {
                trx.setToIdentity();
                System.err.println("Reseted to identity!");
            }
            boolean omitMask = XRPMTransformedBlit.isMaskOmittable(trx, comp, filter);
            if (!omitMask) {
                XRMaskImage mask = x11sdSrc.maskBuffer.getMaskImage();
                x11sdSrc.validateAsSource(trx, 2, filter);
                int maskPicture = mask.prepareBlitMask(x11sdDst, maskTX, width, height);
                x11sdDst.maskBuffer.con.renderComposite(XRCompositeManager.getInstance(x11sdSrc).getCompRule(), x11sdSrc.picture, maskPicture, x11sdDst.picture, 0, 0, 0, 0, bounds.x, bounds.y, bounds.width, bounds.height);
            } else {
                int repeat = filter == 0 ? 0 : 2;
                x11sdSrc.validateAsSource(trx, repeat, filter);
                x11sdDst.maskBuffer.compositeBlit(x11sdSrc, x11sdDst, 0, 0, bounds.x, bounds.y, bounds.width, bounds.height);
            }
            Object var23_24 = null;
        }
        catch (Throwable throwable) {
            Object var23_25 = null;
            SunToolkit.awtUnlock();
            throw throwable;
        }
        SunToolkit.awtUnlock();
    }

    protected static boolean isMaskOmittable(AffineTransform trx, Composite comp, int filter) {
        return (filter == 0 || trx.getTranslateX() == (double)((int)trx.getTranslateX()) && trx.getTranslateY() == (double)((int)trx.getTranslateY()) && (trx.getShearX() == 0.0 && trx.getShearY() == 0.0 || trx.getShearX() == -trx.getShearY())) && ((AlphaComposite)comp).getAlpha() == 1.0f;
    }
}

