/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.GcInfo;
import java.io.InvalidObjectException;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Method;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import sun.management.GcInfoBuilder;
import sun.management.LazyCompositeData;
import sun.management.MappedMXBeanType;
import sun.management.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GcInfoCompositeData
extends LazyCompositeData {
    private final GcInfo info;
    private final GcInfoBuilder builder;
    private final Object[] gcExtItemValues;
    private static final String ID = "id";
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    private static final String DURATION = "duration";
    private static final String MEMORY_USAGE_BEFORE_GC = "memoryUsageBeforeGc";
    private static final String MEMORY_USAGE_AFTER_GC = "memoryUsageAfterGc";
    private static final String[] baseGcInfoItemNames = new String[]{"id", "startTime", "endTime", "duration", "memoryUsageBeforeGc", "memoryUsageAfterGc"};
    private static MappedMXBeanType memoryUsageMapType;
    private static OpenType[] baseGcInfoItemTypes;
    private static CompositeType baseGcInfoCompositeType;

    public GcInfoCompositeData(GcInfo info, GcInfoBuilder builder, Object[] gcExtItemValues) {
        this.info = info;
        this.builder = builder;
        this.gcExtItemValues = gcExtItemValues;
    }

    public GcInfo getGcInfo() {
        return this.info;
    }

    @Override
    protected CompositeData getCompositeData() {
        Object[] baseGcInfoItemValues;
        try {
            baseGcInfoItemValues = new Object[]{new Long(this.info.getId()), new Long(this.info.getStartTime()), new Long(this.info.getEndTime()), new Long(this.info.getDuration()), memoryUsageMapType.toOpenTypeData(this.info.getMemoryUsageBeforeGc()), memoryUsageMapType.toOpenTypeData(this.info.getMemoryUsageAfterGc())};
        }
        catch (OpenDataException e) {
            throw Util.newAssertionError(e);
        }
        int gcExtItemCount = this.builder.getGcExtItemCount();
        if (gcExtItemCount == 0 && this.gcExtItemValues != null && this.gcExtItemValues.length != 0) {
            throw new InternalError("Unexpected Gc Extension Item Values");
        }
        if (gcExtItemCount > 0 && (this.gcExtItemValues == null || gcExtItemCount != this.gcExtItemValues.length)) {
            throw new InternalError("Unmatched Gc Extension Item Values");
        }
        Object[] values = new Object[baseGcInfoItemValues.length + gcExtItemCount];
        System.arraycopy(baseGcInfoItemValues, 0, values, 0, baseGcInfoItemValues.length);
        if (gcExtItemCount > 0) {
            System.arraycopy(this.gcExtItemValues, 0, values, baseGcInfoItemValues.length, gcExtItemCount);
        }
        try {
            return new CompositeDataSupport(this.builder.getGcInfoCompositeType(), this.builder.getItemNames(), values);
        }
        catch (OpenDataException e) {
            throw Util.newInternalError(e);
        }
    }

    static String[] getBaseGcInfoItemNames() {
        return baseGcInfoItemNames;
    }

    static synchronized OpenType[] getBaseGcInfoItemTypes() {
        if (baseGcInfoItemTypes == null) {
            OpenType memoryUsageOpenType = memoryUsageMapType.getOpenType();
            baseGcInfoItemTypes = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, memoryUsageOpenType, memoryUsageOpenType};
        }
        return baseGcInfoItemTypes;
    }

    public static long getId(CompositeData cd) {
        return GcInfoCompositeData.getLong(cd, ID);
    }

    public static long getStartTime(CompositeData cd) {
        return GcInfoCompositeData.getLong(cd, START_TIME);
    }

    public static long getEndTime(CompositeData cd) {
        return GcInfoCompositeData.getLong(cd, END_TIME);
    }

    public static Map<String, MemoryUsage> getMemoryUsageBeforeGc(CompositeData cd) {
        try {
            TabularData td = (TabularData)cd.get(MEMORY_USAGE_BEFORE_GC);
            return GcInfoCompositeData.cast(memoryUsageMapType.toJavaTypeData(td));
        }
        catch (InvalidObjectException e) {
            throw Util.newAssertionError(e);
        }
        catch (OpenDataException e) {
            throw Util.newAssertionError(e);
        }
    }

    public static Map<String, MemoryUsage> cast(Object x) {
        return (Map)x;
    }

    public static Map<String, MemoryUsage> getMemoryUsageAfterGc(CompositeData cd) {
        try {
            TabularData td = (TabularData)cd.get(MEMORY_USAGE_AFTER_GC);
            return GcInfoCompositeData.cast(memoryUsageMapType.toJavaTypeData(td));
        }
        catch (InvalidObjectException e) {
            throw Util.newAssertionError(e);
        }
        catch (OpenDataException e) {
            throw Util.newAssertionError(e);
        }
    }

    public static void validateCompositeData(CompositeData cd) {
        if (cd == null) {
            throw new NullPointerException("Null CompositeData");
        }
        if (!GcInfoCompositeData.isTypeMatched(GcInfoCompositeData.getBaseGcInfoCompositeType(), cd.getCompositeType())) {
            throw new IllegalArgumentException("Unexpected composite type for GcInfo");
        }
    }

    private static synchronized CompositeType getBaseGcInfoCompositeType() {
        if (baseGcInfoCompositeType == null) {
            try {
                baseGcInfoCompositeType = new CompositeType("sun.management.BaseGcInfoCompositeType", "CompositeType for Base GcInfo", GcInfoCompositeData.getBaseGcInfoItemNames(), GcInfoCompositeData.getBaseGcInfoItemNames(), GcInfoCompositeData.getBaseGcInfoItemTypes());
            }
            catch (OpenDataException e) {
                throw Util.newException(e);
            }
        }
        return baseGcInfoCompositeType;
    }

    static {
        try {
            Method m = GcInfo.class.getMethod("getMemoryUsageBeforeGc", new Class[0]);
            memoryUsageMapType = MappedMXBeanType.getMappedType(m.getGenericReturnType());
        }
        catch (NoSuchMethodException e) {
            throw Util.newAssertionError(e);
        }
        catch (OpenDataException e) {
            throw Util.newAssertionError(e);
        }
        baseGcInfoItemTypes = null;
        baseGcInfoCompositeType = null;
    }
}

