/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.management.HotspotThreadMBean;
import sun.management.VMManagement;
import sun.management.counter.Counter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HotspotThread
implements HotspotThreadMBean {
    private VMManagement jvm;
    private static final String JAVA_THREADS = "java.threads.";
    private static final String COM_SUN_THREADS = "com.sun.threads.";
    private static final String SUN_THREADS = "sun.threads.";
    private static final String THREADS_COUNTER_NAME_PATTERN = "java.threads.|com.sun.threads.|sun.threads.";

    HotspotThread(VMManagement vm) {
        this.jvm = vm;
    }

    @Override
    public native int getInternalThreadCount();

    @Override
    public Map<String, Long> getInternalThreadCpuTimes() {
        int count = this.getInternalThreadCount();
        if (count == 0) {
            return Collections.emptyMap();
        }
        String[] names = new String[count];
        long[] times = new long[count];
        int numThreads = this.getInternalThreadTimes0(names, times);
        HashMap<String, Long> result = new HashMap<String, Long>(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            result.put(names[i], new Long(times[i]));
        }
        return result;
    }

    public native int getInternalThreadTimes0(String[] var1, long[] var2);

    @Override
    public List<Counter> getInternalThreadingCounters() {
        return this.jvm.getInternalCounters(THREADS_COUNTER_NAME_PATTERN);
    }
}

