/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.IOException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.jar.JarFile;
import sun.misc.SharedSecrets;
import sun.misc.URLClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderUtil {
    public static void releaseLoader(URLClassLoader classLoader) {
        ClassLoaderUtil.releaseLoader(classLoader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IOException> releaseLoader(URLClassLoader classLoader, List<String> jarsClosed) {
        LinkedList<IOException> ioExceptions = new LinkedList<IOException>();
        try {
            if (jarsClosed != null) {
                jarsClosed.clear();
            }
            System.out.println("classLoader = " + classLoader);
            System.out.println("SharedSecrets.getJavaNetAccess()=" + SharedSecrets.getJavaNetAccess());
            URLClassPath ucp = SharedSecrets.getJavaNetAccess().getURLClassPath(classLoader);
            ArrayList loaders = ucp.loaders;
            Stack urls = ucp.urls;
            HashMap lmap = ucp.lmap;
            Object object = urls;
            synchronized (object) {
                urls.clear();
            }
            object = lmap;
            synchronized (object) {
                lmap.clear();
            }
            object = ucp;
            synchronized (object) {
                for (Object o : loaders) {
                    if (o == null || !(o instanceof URLClassPath.JarLoader)) continue;
                    URLClassPath.JarLoader jl = (URLClassPath.JarLoader)o;
                    JarFile jarFile = jl.getJarFile();
                    try {
                        if (jarFile == null) continue;
                        jarFile.close();
                        if (jarsClosed == null) continue;
                        jarsClosed.add(jarFile.getName());
                    }
                    catch (IOException ioe) {
                        String jarFileName = jarFile == null ? "filename not available" : jarFile.getName();
                        String msg = "Error closing JAR file: " + jarFileName;
                        IOException newIOE = new IOException(msg);
                        newIOE.initCause(ioe);
                        ioExceptions.add(newIOE);
                    }
                }
                loaders.clear();
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return ioExceptions;
    }
}

