/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.misc.MetaIndex;
import sun.misc.PathPermissions;
import sun.misc.URLClassPath;
import sun.net.www.ParseUtil;
import sun.security.action.GetPropertyAction;

public class Launcher {
    private static URLStreamHandlerFactory factory = new Factory();
    private static Launcher launcher = new Launcher();
    private ClassLoader loader;
    private static URLStreamHandler fileHandler;

    public static Launcher getLauncher() {
        return launcher;
    }

    public Launcher() {
        ExtClassLoader extcl;
        try {
            extcl = ExtClassLoader.getExtClassLoader();
        }
        catch (IOException e) {
            throw new InternalError("Could not create extension class loader");
        }
        try {
            this.loader = AppClassLoader.getAppClassLoader(extcl);
        }
        catch (IOException e) {
            throw new InternalError("Could not create application class loader");
        }
        Thread.currentThread().setContextClassLoader(this.loader);
        String s = System.getProperty("java.security.manager");
        if (s != null) {
            SecurityManager sm = null;
            if ("".equals(s) || "default".equals(s)) {
                sm = new SecurityManager();
            } else {
                try {
                    sm = (SecurityManager)this.loader.loadClass(s).newInstance();
                }
                catch (IllegalAccessException e) {
                }
                catch (InstantiationException e) {
                }
                catch (ClassNotFoundException e) {
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
            }
            if (sm != null) {
                System.setSecurityManager(sm);
            } else {
                throw new InternalError("Could not create SecurityManager: " + s);
            }
        }
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public static URLClassPath getBootstrapClassPath() {
        URL[] urls;
        String prop = AccessController.doPrivileged(new GetPropertyAction("sun.boot.class.path"));
        if (prop != null) {
            final String path = prop;
            urls = (URL[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    File[] classPath = Launcher.getClassPath(path);
                    int len = classPath.length;
                    HashSet<File> seenDirs = new HashSet<File>();
                    for (int i = 0; i < len; ++i) {
                        File curEntry = classPath[i];
                        if (!curEntry.isDirectory()) {
                            curEntry = curEntry.getParentFile();
                        }
                        if (curEntry == null || !seenDirs.add(curEntry)) continue;
                        MetaIndex.registerDirectory(curEntry);
                    }
                    return Launcher.pathToURLs(classPath);
                }
            });
        } else {
            urls = new URL[]{};
        }
        return new URLClassPath(urls, factory);
    }

    private static URL[] pathToURLs(File[] path) {
        URL[] urls = new URL[path.length];
        for (int i = 0; i < path.length; ++i) {
            urls[i] = Launcher.getFileURL(path[i]);
        }
        return urls;
    }

    private static File[] getClassPath(String cp) {
        File[] path;
        if (cp != null) {
            int count = 0;
            int maxCount = 1;
            int pos = 0;
            int lastPos = 0;
            while ((pos = cp.indexOf(File.pathSeparator, lastPos)) != -1) {
                ++maxCount;
                lastPos = pos + 1;
            }
            path = new File[maxCount];
            pos = 0;
            lastPos = 0;
            while ((pos = cp.indexOf(File.pathSeparator, lastPos)) != -1) {
                path[count++] = pos - lastPos > 0 ? new File(cp.substring(lastPos, pos)) : new File(".");
                lastPos = pos + 1;
            }
            path[count++] = lastPos < cp.length() ? new File(cp.substring(lastPos)) : new File(".");
            if (count != maxCount) {
                File[] tmp = new File[count];
                System.arraycopy(path, 0, tmp, 0, count);
                path = tmp;
            }
        } else {
            path = new File[]{};
        }
        return path;
    }

    static URL getFileURL(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            return ParseUtil.fileToEncodedURL(file);
        }
        catch (MalformedURLException e) {
            throw new InternalError();
        }
    }

    private static class Factory
    implements URLStreamHandlerFactory {
        private static String PREFIX = "sun.net.www.protocol";

        private Factory() {
        }

        public URLStreamHandler createURLStreamHandler(String protocol) {
            String name = PREFIX + "." + protocol + ".Handler";
            try {
                Class<?> c = Class.forName(name);
                return (URLStreamHandler)c.newInstance();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            throw new InternalError("could not load " + protocol + "system protocol handler");
        }
    }

    static class AppClassLoader
    extends URLClassLoader {
        public static ClassLoader getAppClassLoader(final ClassLoader extcl) throws IOException {
            final String s = System.getProperty("java.class.path");
            final File[] path = s == null ? new File[]{} : Launcher.getClassPath(s);
            return (AppClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    URL[] urls = s == null ? new URL[]{} : Launcher.pathToURLs(path);
                    return new AppClassLoader(urls, extcl);
                }
            });
        }

        AppClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent, factory);
        }

        public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            SecurityManager sm;
            int i = name.lastIndexOf(46);
            if (i != -1 && (sm = System.getSecurityManager()) != null) {
                sm.checkPackageAccess(name.substring(0, i));
            }
            return super.loadClass(name, resolve);
        }

        protected PermissionCollection getPermissions(CodeSource codesource) {
            PermissionCollection perms = super.getPermissions(codesource);
            perms.add(new RuntimePermission("exitVM"));
            return perms;
        }

        private void appendToClassPathForInstrumentation(String path) {
            assert (Thread.holdsLock(this));
            super.addURL(Launcher.getFileURL(new File(path)));
        }

        private static AccessControlContext getContext(File[] cp) throws MalformedURLException {
            PathPermissions perms = new PathPermissions(cp);
            ProtectionDomain domain = new ProtectionDomain(new CodeSource(perms.getCodeBase(), (Certificate[])null), perms);
            AccessControlContext acc = new AccessControlContext(new ProtectionDomain[]{domain});
            return acc;
        }
    }

    static class ExtClassLoader
    extends URLClassLoader {
        private File[] dirs;

        public static ExtClassLoader getExtClassLoader() throws IOException {
            final File[] dirs = ExtClassLoader.getExtDirs();
            try {
                return (ExtClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        int len = dirs.length;
                        for (int i = 0; i < len; ++i) {
                            MetaIndex.registerDirectory(dirs[i]);
                        }
                        return new ExtClassLoader(dirs);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getException();
            }
        }

        void addExtURL(URL url) {
            super.addURL(url);
        }

        public ExtClassLoader(File[] dirs) throws IOException {
            super(ExtClassLoader.getExtURLs(dirs), null, factory);
            this.dirs = dirs;
        }

        private static File[] getExtDirs() {
            File[] dirs;
            String s = System.getProperty("java.ext.dirs");
            if (s != null) {
                StringTokenizer st = new StringTokenizer(s, File.pathSeparator);
                int count = st.countTokens();
                dirs = new File[count];
                for (int i = 0; i < count; ++i) {
                    dirs[i] = new File(st.nextToken());
                }
            } else {
                dirs = new File[]{};
            }
            return dirs;
        }

        private static URL[] getExtURLs(File[] dirs) throws IOException {
            Vector<URL> urls = new Vector<URL>();
            for (int i = 0; i < dirs.length; ++i) {
                String[] files = dirs[i].list();
                if (files == null) continue;
                for (int j = 0; j < files.length; ++j) {
                    if (files[j].equals("meta-index")) continue;
                    File f = new File(dirs[i], files[j]);
                    urls.add(Launcher.getFileURL(f));
                }
            }
            Object[] ua = new URL[urls.size()];
            urls.copyInto(ua);
            return ua;
        }

        public String findLibrary(String name) {
            name = System.mapLibraryName(name);
            for (int i = 0; i < this.dirs.length; ++i) {
                File file;
                String arch = System.getProperty("os.arch");
                if (arch != null && (file = new File(new File(this.dirs[i], arch), name)).exists()) {
                    return file.getAbsolutePath();
                }
                file = new File(this.dirs[i], name);
                if (!file.exists()) continue;
                return file.getAbsolutePath();
            }
            return null;
        }

        private static AccessControlContext getContext(File[] dirs) throws IOException {
            PathPermissions perms = new PathPermissions(dirs);
            ProtectionDomain domain = new ProtectionDomain(new CodeSource(perms.getCodeBase(), (Certificate[])null), perms);
            AccessControlContext acc = new AccessControlContext(new ProtectionDomain[]{domain});
            return acc;
        }
    }
}

