/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.IOException;
import java.io.OutputStream;
import sun.misc.CRC16;
import sun.misc.CharacterEncoder;

public class UCEncoder
extends CharacterEncoder {
    private static final byte[] map_array = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 40, 41};
    private int sequence;
    private byte[] tmp = new byte[2];
    private CRC16 crc = new CRC16();

    protected int bytesPerAtom() {
        return 2;
    }

    protected int bytesPerLine() {
        return 48;
    }

    protected void encodeAtom(OutputStream outStream, byte[] data, int offset, int len) throws IOException {
        byte a = data[offset];
        byte b = len == 2 ? data[offset + 1] : (byte)0;
        this.crc.update(a);
        if (len == 2) {
            this.crc.update(b);
        }
        outStream.write(map_array[(a >>> 2 & 0x38) + (b >>> 5 & 7)]);
        int p1 = 0;
        int p2 = 0;
        for (int i = 1; i < 256; i *= 2) {
            if ((a & i) != 0) {
                ++p1;
            }
            if ((b & i) == 0) continue;
            ++p2;
        }
        p1 = (p1 & 1) * 32;
        p2 = (p2 & 1) * 32;
        outStream.write(map_array[(a & 0x1F) + p1]);
        outStream.write(map_array[(b & 0x1F) + p2]);
    }

    protected void encodeLinePrefix(OutputStream outStream, int length) throws IOException {
        outStream.write(42);
        this.crc.value = 0;
        this.tmp[0] = (byte)length;
        this.tmp[1] = (byte)this.sequence;
        this.sequence = this.sequence + 1 & 0xFF;
        this.encodeAtom(outStream, this.tmp, 0, 2);
    }

    protected void encodeLineSuffix(OutputStream outStream) throws IOException {
        this.tmp[0] = (byte)(this.crc.value >>> 8 & 0xFF);
        this.tmp[1] = (byte)(this.crc.value & 0xFF);
        this.encodeAtom(outStream, this.tmp, 0, 2);
        this.pStream.println();
    }

    protected void encodeBufferPrefix(OutputStream a) throws IOException {
        this.sequence = 0;
        super.encodeBufferPrefix(a);
    }
}

