/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.Util;

class IOVecWrapper {
    static int BASE_OFFSET = 0;
    static int LEN_OFFSET = addressSize = Util.unsafe().addressSize();
    static int SIZE_IOVEC = (short)(addressSize * 2);
    private AllocatedNativeObject vecArray;
    long address;
    static int addressSize;

    IOVecWrapper(int newSize) {
        newSize = (newSize + 1) * SIZE_IOVEC;
        this.vecArray = new AllocatedNativeObject(newSize, false);
        this.address = this.vecArray.address();
    }

    void putBase(int i, long base) {
        int offset = SIZE_IOVEC * i + BASE_OFFSET;
        if (addressSize == 4) {
            this.vecArray.putInt(offset, (int)base);
        } else {
            this.vecArray.putLong(offset, base);
        }
    }

    void putLen(int i, long len) {
        int offset = SIZE_IOVEC * i + LEN_OFFSET;
        if (addressSize == 4) {
            this.vecArray.putInt(offset, (int)len);
        } else {
            this.vecArray.putLong(offset, len);
        }
    }

    void free() {
        this.vecArray.free();
    }
}

