/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.nio.ch.ChannelInputStream;
import sun.nio.ch.Net;
import sun.nio.ch.OptionAdaptor;
import sun.nio.ch.SocketChannelImpl;
import sun.nio.ch.Util;

public class SocketAdaptor
extends Socket {
    private final SocketChannelImpl sc;
    private volatile OptionAdaptor opts = null;
    private volatile int timeout = 0;
    private volatile int trafficClass = 0;
    private InputStream socketInputStream = null;

    private SocketAdaptor(SocketChannelImpl sc) {
        this.sc = sc;
    }

    public static Socket create(SocketChannelImpl sc) {
        return new SocketAdaptor(sc);
    }

    public SocketChannel getChannel() {
        return this.sc;
    }

    public void connect(SocketAddress remote) throws IOException {
        this.connect(remote, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(SocketAddress remote, int timeout) throws IOException {
        if (remote == null) {
            throw new IllegalArgumentException("connect: The address can't be null");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        Object object = this.sc.blockingLock();
        synchronized (object) {
            if (!this.sc.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            try {
                if (timeout == 0) {
                    this.sc.connect(remote);
                    return;
                }
                SelectionKey sk = null;
                Selector sel = null;
                this.sc.configureBlocking(false);
                try {
                    block21: {
                        long st;
                        if (this.sc.connect(remote)) {
                            Object var13_7 = null;
                            if (sk != null) {
                                sk.cancel();
                            }
                            if (this.sc.isOpen()) {
                                this.sc.configureBlocking(true);
                            }
                            if (sel == null) return;
                            Util.releaseTemporarySelector(sel);
                            return;
                        }
                        sel = Util.getTemporarySelector(this.sc);
                        sk = this.sc.register(sel, 8);
                        long to = timeout;
                        do {
                            if (!this.sc.isOpen()) {
                                throw new ClosedChannelException();
                            }
                            st = System.currentTimeMillis();
                            int ns = sel.select(to);
                            if (ns > 0 && sk.isConnectable() && this.sc.finishConnect()) break block21;
                            sel.selectedKeys().remove(sk);
                        } while ((to -= System.currentTimeMillis() - st) > 0L);
                        try {
                            this.sc.close();
                            throw new SocketTimeoutException();
                        }
                        catch (IOException x) {
                            // empty catch block
                        }
                        throw new SocketTimeoutException();
                    }
                    Object var13_8 = null;
                    if (sk != null) {
                        sk.cancel();
                    }
                    if (this.sc.isOpen()) {
                        this.sc.configureBlocking(true);
                    }
                    if (sel == null) return;
                    Util.releaseTemporarySelector(sel);
                }
                catch (Throwable throwable) {
                    Object var13_9 = null;
                    if (sk != null) {
                        sk.cancel();
                    }
                    if (this.sc.isOpen()) {
                        this.sc.configureBlocking(true);
                    }
                    if (sel == null) throw throwable;
                    Util.releaseTemporarySelector(sel);
                    throw throwable;
                }
            }
            catch (Exception x) {
                Net.translateException(x, true);
            }
            return;
        }
    }

    public void bind(SocketAddress local) throws IOException {
        try {
            if (local == null) {
                local = new InetSocketAddress(0);
            }
            this.sc.bind(local);
        }
        catch (Exception x) {
            Net.translateException(x);
        }
    }

    public InetAddress getInetAddress() {
        if (!this.sc.isConnected()) {
            return null;
        }
        return Net.asInetSocketAddress(this.sc.remoteAddress()).getAddress();
    }

    public InetAddress getLocalAddress() {
        if (!this.sc.isBound()) {
            return new InetSocketAddress(0).getAddress();
        }
        return Net.asInetSocketAddress(this.sc.localAddress()).getAddress();
    }

    public int getPort() {
        if (!this.sc.isConnected()) {
            return 0;
        }
        return Net.asInetSocketAddress(this.sc.remoteAddress()).getPort();
    }

    public int getLocalPort() {
        if (!this.sc.isBound()) {
            return -1;
        }
        return Net.asInetSocketAddress(this.sc.localAddress()).getPort();
    }

    public InputStream getInputStream() throws IOException {
        if (!this.sc.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.sc.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (!this.sc.isInputOpen()) {
            throw new SocketException("Socket input is shutdown");
        }
        if (this.socketInputStream == null) {
            try {
                this.socketInputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new SocketInputStream();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getException();
            }
        }
        return this.socketInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.sc.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.sc.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (!this.sc.isOutputOpen()) {
            throw new SocketException("Socket output is shutdown");
        }
        OutputStream os = null;
        try {
            os = (OutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return Channels.newOutputStream(SocketAdaptor.this.sc);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        return os;
    }

    private OptionAdaptor opts() {
        if (this.opts == null) {
            this.opts = new OptionAdaptor(this.sc);
        }
        return this.opts;
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.opts().setTcpNoDelay(on);
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.opts().getTcpNoDelay();
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.opts().setSoLinger(on, linger);
    }

    public int getSoLinger() throws SocketException {
        return this.opts().getSoLinger();
    }

    public void sendUrgentData(int data) throws IOException {
        throw new SocketException("Urgent data not supported");
    }

    public void setOOBInline(boolean on) throws SocketException {
        this.opts().setOOBInline(on);
    }

    public boolean getOOBInline() throws SocketException {
        return this.opts().getOOBInline();
    }

    public void setSoTimeout(int timeout) throws SocketException {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        this.timeout = timeout;
    }

    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.opts().setSendBufferSize(size);
    }

    public int getSendBufferSize() throws SocketException {
        return this.opts().getSendBufferSize();
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.opts().setReceiveBufferSize(size);
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.opts().getReceiveBufferSize();
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.opts().setKeepAlive(on);
    }

    public boolean getKeepAlive() throws SocketException {
        return this.opts().getKeepAlive();
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.opts().setTrafficClass(tc);
        this.trafficClass = tc;
    }

    public int getTrafficClass() throws SocketException {
        int tc = this.opts().getTrafficClass();
        if (tc < 0) {
            tc = this.trafficClass;
        }
        return tc;
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.opts().setReuseAddress(on);
    }

    public boolean getReuseAddress() throws SocketException {
        return this.opts().getReuseAddress();
    }

    public void close() throws IOException {
        try {
            this.sc.close();
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
        }
    }

    public void shutdownInput() throws IOException {
        try {
            this.sc.shutdownInput();
        }
        catch (Exception x) {
            Net.translateException(x);
        }
    }

    public void shutdownOutput() throws IOException {
        try {
            this.sc.shutdownOutput();
        }
        catch (Exception x) {
            Net.translateException(x);
        }
    }

    public String toString() {
        if (this.sc.isConnected()) {
            return "Socket[addr=" + this.getInetAddress() + ",port=" + this.getPort() + ",localport=" + this.getLocalPort() + "]";
        }
        return "Socket[unconnected]";
    }

    public boolean isConnected() {
        return this.sc.isConnected();
    }

    public boolean isBound() {
        return this.sc.isBound();
    }

    public boolean isClosed() {
        return !this.sc.isOpen();
    }

    public boolean isInputShutdown() {
        return !this.sc.isInputOpen();
    }

    public boolean isOutputShutdown() {
        return !this.sc.isOutputOpen();
    }

    private class SocketInputStream
    extends ChannelInputStream {
        private SocketInputStream() {
            super(SocketAdaptor.this.sc);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected int read(ByteBuffer bb) throws IOException {
            Object object = SocketAdaptor.this.sc.blockingLock();
            synchronized (object) {
                if (!SocketAdaptor.this.sc.isBlocking()) {
                    throw new IllegalBlockingModeException();
                }
                if (SocketAdaptor.this.timeout == 0) {
                    return SocketAdaptor.this.sc.read(bb);
                }
                SelectionKey sk = null;
                Selector sel = null;
                SocketAdaptor.this.sc.configureBlocking(false);
                try {
                    long st;
                    int n = SocketAdaptor.this.sc.read(bb);
                    if (n != 0) {
                        int n2 = n;
                        Object var13_8 = null;
                        if (sk != null) {
                            sk.cancel();
                        }
                        if (SocketAdaptor.this.sc.isOpen()) {
                            SocketAdaptor.this.sc.configureBlocking(true);
                        }
                        if (sel == null) return n2;
                        Util.releaseTemporarySelector(sel);
                        return n2;
                    }
                    sel = Util.getTemporarySelector(SocketAdaptor.this.sc);
                    sk = SocketAdaptor.this.sc.register(sel, 1);
                    long to = SocketAdaptor.this.timeout;
                    do {
                        if (!SocketAdaptor.this.sc.isOpen()) {
                            throw new ClosedChannelException();
                        }
                        st = System.currentTimeMillis();
                        int ns = sel.select(to);
                        if (ns > 0 && sk.isReadable() && (n = SocketAdaptor.this.sc.read(bb)) != 0) {
                            int n3 = n;
                            Object var13_9 = null;
                            if (sk != null) {
                                sk.cancel();
                            }
                            if (SocketAdaptor.this.sc.isOpen()) {
                                SocketAdaptor.this.sc.configureBlocking(true);
                            }
                            if (sel == null) return n3;
                            Util.releaseTemporarySelector(sel);
                            return n3;
                        }
                        sel.selectedKeys().remove(sk);
                    } while ((to -= System.currentTimeMillis() - st) > 0L);
                    throw new SocketTimeoutException();
                }
                catch (Throwable throwable) {
                    Object var13_10 = null;
                    if (sk != null) {
                        sk.cancel();
                    }
                    if (SocketAdaptor.this.sc.isOpen()) {
                        SocketAdaptor.this.sc.configureBlocking(true);
                    }
                    if (sel == null) throw throwable;
                    Util.releaseTemporarySelector(sel);
                    throw throwable;
                }
            }
        }
    }
}

