/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.util.Vector;
import javax.print.PrintService;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.event.PrintServiceAttributeEvent;
import javax.print.event.PrintServiceAttributeListener;
import sun.print.AttributeUpdater;

class ServiceNotifier
extends Thread {
    private PrintService service;
    private Vector listeners;
    private boolean stop = false;
    private PrintServiceAttributeSet lastSet;

    ServiceNotifier(PrintService service) {
        super(service.getName() + " notifier");
        this.service = service;
        this.listeners = new Vector();
        try {
            this.setPriority(4);
            this.setDaemon(true);
            this.start();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(PrintServiceAttributeListener listener) {
        ServiceNotifier serviceNotifier = this;
        synchronized (serviceNotifier) {
            if (listener == null || this.listeners == null) {
                return;
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(PrintServiceAttributeListener listener) {
        ServiceNotifier serviceNotifier = this;
        synchronized (serviceNotifier) {
            if (listener == null || this.listeners == null) {
                return;
            }
            this.listeners.remove(listener);
        }
    }

    boolean isEmpty() {
        return this.listeners == null || this.listeners.isEmpty();
    }

    void stopNotifier() {
        this.stop = true;
    }

    void wake() {
        try {
            this.interrupt();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long minSleepTime = 15000L;
        long sleepTime = 2000L;
        while (!this.stop) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ServiceNotifier serviceNotifier = this;
            synchronized (serviceNotifier) {
                PrintServiceAttributeSet psa;
                if (this.listeners == null) {
                    continue;
                }
                long startTime = System.currentTimeMillis();
                if (this.listeners != null && (psa = this.service instanceof AttributeUpdater ? ((AttributeUpdater)((Object)this.service)).getUpdatedAttributes() : this.service.getAttributes()) != null && !psa.isEmpty()) {
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        PrintServiceAttributeListener listener = (PrintServiceAttributeListener)this.listeners.elementAt(i);
                        HashPrintServiceAttributeSet attrs = new HashPrintServiceAttributeSet(psa);
                        PrintServiceAttributeEvent attrEvent = new PrintServiceAttributeEvent(this.service, attrs);
                        listener.attributeUpdate(attrEvent);
                    }
                }
                if ((sleepTime = (System.currentTimeMillis() - startTime) * 10L) < minSleepTime) {
                    sleepTime = minSleepTime;
                }
            }
        }
    }
}

