/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.Socket;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.WeakHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.RuntimeUtil;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Connection;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.tcp.ConnectionAcceptor;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.TCPConnection;
import sun.rmi.transport.tcp.TCPEndpoint;
import sun.rmi.transport.tcp.TCPTransport;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetLongAction;

public class TCPChannel
implements Channel {
    private final TCPEndpoint ep;
    private final TCPTransport tr;
    private final List<TCPConnection> freeList = new ArrayList<TCPConnection>();
    private Future<?> reaper = null;
    private boolean usingMultiplexer = false;
    private ConnectionMultiplexer multiplexer = null;
    private ConnectionAcceptor acceptor;
    private AccessControlContext okContext;
    private WeakHashMap<AccessControlContext, Reference<AccessControlContext>> authcache;
    private SecurityManager cacheSecurityManager = null;
    private static final long idleTimeout = AccessController.doPrivileged(new GetLongAction("sun.rmi.transport.connectionTimeout", 15000L));
    private static final int handshakeTimeout = AccessController.doPrivileged(new GetIntegerAction("sun.rmi.transport.tcp.handshakeTimeout", 60000));
    private static final int responseTimeout = AccessController.doPrivileged(new GetIntegerAction("sun.rmi.transport.tcp.responseTimeout", 0));
    private static final ScheduledExecutorService scheduler = AccessController.doPrivileged(new RuntimeUtil.GetInstanceAction()).getScheduler();

    TCPChannel(TCPTransport tr, TCPEndpoint ep) {
        this.tr = tr;
        this.ep = ep;
    }

    public Endpoint getEndpoint() {
        return this.ep;
    }

    private void checkConnectPermission() throws SecurityException {
        SecurityManager security = System.getSecurityManager();
        if (security == null) {
            return;
        }
        if (security != this.cacheSecurityManager) {
            this.okContext = null;
            this.authcache = new WeakHashMap();
            this.cacheSecurityManager = security;
        }
        AccessControlContext ctx = AccessController.getContext();
        if (this.okContext == null || !this.okContext.equals(ctx) && !this.authcache.containsKey(ctx)) {
            security.checkConnect(this.ep.getHost(), this.ep.getPort());
            this.authcache.put(ctx, new SoftReference<AccessControlContext>(ctx));
        }
        this.okContext = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection newConnection() throws RemoteException {
        TCPConnection conn;
        do {
            conn = null;
            List<TCPConnection> list = this.freeList;
            synchronized (list) {
                int elementPos = this.freeList.size() - 1;
                if (elementPos >= 0) {
                    this.checkConnectPermission();
                    conn = this.freeList.get(elementPos);
                    this.freeList.remove(elementPos);
                }
            }
            if (conn == null) continue;
            if (!conn.isDead()) {
                TCPTransport.tcpLog.log(Log.BRIEF, "reuse connection");
                return conn;
            }
            this.free(conn, false);
        } while (conn != null);
        return this.createConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection createConnection() throws RemoteException {
        TCPConnection conn;
        TCPTransport.tcpLog.log(Log.BRIEF, "create connection");
        if (!this.usingMultiplexer) {
            Socket sock = this.ep.newSocket();
            conn = new TCPConnection(this, sock);
            try {
                DataOutputStream out = new DataOutputStream(conn.getOutputStream());
                this.writeTransportHeader(out);
                if (!conn.isReusable()) {
                    out.writeByte(76);
                }
                out.writeByte(75);
                out.flush();
                int originalSoTimeout = 0;
                try {
                    originalSoTimeout = sock.getSoTimeout();
                    sock.setSoTimeout(handshakeTimeout);
                }
                catch (Exception e) {
                    // empty catch block
                }
                DataInputStream in = new DataInputStream(conn.getInputStream());
                byte ack = in.readByte();
                if (ack != 78) {
                    throw new ConnectIOException(ack == 79 ? "JRMP StreamProtocol not supported by server" : "non-JRMP server at remote endpoint");
                }
                String suggestedHost = in.readUTF();
                int suggestedPort = in.readInt();
                if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
                    TCPTransport.tcpLog.log(Log.VERBOSE, "server suggested " + suggestedHost + ":" + suggestedPort);
                }
                TCPEndpoint.setLocalHost(suggestedHost);
                TCPEndpoint localEp = TCPEndpoint.getLocalEndpoint(0, null, null);
                out.writeUTF(localEp.getHost());
                out.writeInt(localEp.getPort());
                if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
                    TCPTransport.tcpLog.log(Log.VERBOSE, "using " + localEp.getHost() + ":" + localEp.getPort());
                }
                try {
                    sock.setSoTimeout(originalSoTimeout != 0 ? originalSoTimeout : responseTimeout);
                }
                catch (Exception e) {
                    // empty catch block
                }
                out.flush();
            }
            catch (IOException e) {
                if (e instanceof RemoteException) {
                    throw (RemoteException)e;
                }
                throw new ConnectIOException("error during JRMP connection establishment", e);
            }
        } else {
            try {
                conn = this.multiplexer.openConnection();
            }
            catch (IOException e) {
                TCPChannel tCPChannel = this;
                synchronized (tCPChannel) {
                    this.usingMultiplexer = false;
                    this.multiplexer = null;
                }
                throw new ConnectIOException("error opening virtual connection over multiplexed connection", e);
            }
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(Connection conn, boolean reuse) {
        if (conn == null) {
            return;
        }
        if (reuse && conn.isReusable()) {
            long lastuse = System.currentTimeMillis();
            TCPConnection tcpConnection = (TCPConnection)conn;
            TCPTransport.tcpLog.log(Log.BRIEF, "reuse connection");
            List<TCPConnection> list = this.freeList;
            synchronized (list) {
                this.freeList.add(tcpConnection);
                if (this.reaper == null) {
                    TCPTransport.tcpLog.log(Log.BRIEF, "create reaper");
                    this.reaper = scheduler.scheduleWithFixedDelay(new Runnable(){

                        public void run() {
                            TCPTransport.tcpLog.log(Log.VERBOSE, "wake up");
                            TCPChannel.this.freeCachedConnections();
                        }
                    }, idleTimeout, idleTimeout, TimeUnit.MILLISECONDS);
                }
            }
            tcpConnection.setLastUseTime(lastuse);
            tcpConnection.setExpiration(lastuse + idleTimeout);
        } else {
            TCPTransport.tcpLog.log(Log.BRIEF, "close connection");
            try {
                conn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void writeTransportHeader(DataOutputStream out) throws RemoteException {
        try {
            DataOutputStream dataOut = new DataOutputStream(out);
            dataOut.writeInt(1246907721);
            dataOut.writeShort(2);
        }
        catch (IOException e) {
            throw new ConnectIOException("error writing JRMP transport header", e);
        }
    }

    synchronized void useMultiplexer(ConnectionMultiplexer newMultiplexer) {
        this.multiplexer = newMultiplexer;
        this.usingMultiplexer = true;
    }

    void acceptMultiplexConnection(Connection conn) {
        if (this.acceptor == null) {
            this.acceptor = new ConnectionAcceptor(this.tr);
            this.acceptor.startNewAcceptor();
        }
        this.acceptor.accept(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shedCache() {
        Connection[] conn;
        List<TCPConnection> list = this.freeList;
        synchronized (list) {
            conn = this.freeList.toArray(new Connection[this.freeList.size()]);
            this.freeList.clear();
        }
        int i = conn.length;
        while (--i >= 0) {
            Connection c = conn[i];
            conn[i] = null;
            try {
                c.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeCachedConnections() {
        List<TCPConnection> list = this.freeList;
        synchronized (list) {
            int size = this.freeList.size();
            if (size > 0) {
                long time = System.currentTimeMillis();
                ListIterator<TCPConnection> iter = this.freeList.listIterator(size);
                while (iter.hasPrevious()) {
                    TCPConnection conn = iter.previous();
                    if (!conn.expired(time)) continue;
                    TCPTransport.tcpLog.log(Log.VERBOSE, "connection timeout expired");
                    try {
                        conn.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    iter.remove();
                }
            }
            if (this.freeList.isEmpty()) {
                this.reaper.cancel(false);
                this.reaper = null;
            }
        }
    }
}

