/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.wrapper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import javax.security.auth.kerberos.DelegationPermission;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSExceptionImpl;
import sun.security.jgss.GSSHeader;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.jgss.spnego.NegTokenInit;
import sun.security.jgss.spnego.NegTokenTarg;
import sun.security.jgss.wrapper.GSSCredElement;
import sun.security.jgss.wrapper.GSSLibStub;
import sun.security.jgss.wrapper.GSSNameElement;
import sun.security.jgss.wrapper.Krb5Util;
import sun.security.jgss.wrapper.SunNativeProvider;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

class NativeGSSContext
implements GSSContextSpi {
    private static final int GSS_C_DELEG_FLAG = 1;
    private static final int GSS_C_MUTUAL_FLAG = 2;
    private static final int GSS_C_REPLAY_FLAG = 4;
    private static final int GSS_C_SEQUENCE_FLAG = 8;
    private static final int GSS_C_CONF_FLAG = 16;
    private static final int GSS_C_INTEG_FLAG = 32;
    private static final int GSS_C_ANON_FLAG = 64;
    private static final int GSS_C_PROT_READY_FLAG = 128;
    private static final int GSS_C_TRANS_FLAG = 256;
    private static final int NUM_OF_INQUIRE_VALUES = 6;
    private long pContext = 0L;
    private GSSNameElement srcName;
    private GSSNameElement targetName;
    private GSSCredElement cred;
    private boolean isInitiator;
    private boolean isEstablished;
    private Oid actualMech;
    private ChannelBinding cb;
    private GSSCredElement delegatedCred;
    private int flags;
    private int lifetime = 0;
    private final GSSLibStub cStub;
    private boolean skipDelegPermCheck;
    private boolean skipServicePermCheck;

    private static Oid getMechFromSpNegoToken(byte[] token, boolean isInitiator) throws GSSException {
        Oid mech = null;
        if (isInitiator) {
            GSSHeader header = null;
            try {
                header = new GSSHeader(new ByteArrayInputStream(token));
            }
            catch (IOException ioe) {
                throw new GSSExceptionImpl(11, ioe);
            }
            int negTokenLen = header.getMechTokenLength();
            byte[] negToken = new byte[negTokenLen];
            System.arraycopy(token, token.length - negTokenLen, negToken, 0, negToken.length);
            NegTokenInit ntok = new NegTokenInit(negToken);
            if (ntok.getMechToken() != null) {
                Oid[] mechList = ntok.getMechTypeList();
                mech = mechList[0];
            }
        } else {
            NegTokenTarg ntok = new NegTokenTarg(token);
            mech = ntok.getSupportedMech();
        }
        return mech;
    }

    private void doServicePermCheck() throws GSSException {
        if (System.getSecurityManager() != null) {
            String action;
            String string = action = this.isInitiator ? "initiate" : "accept";
            if (GSSUtil.isSpNegoMech(this.cStub.getMech()) && this.isInitiator && !this.isEstablished) {
                if (this.srcName == null) {
                    GSSCredElement tempCred = new GSSCredElement(null, this.lifetime, 1, GSSLibStub.getInstance(GSSUtil.GSS_KRB5_MECH_OID));
                    tempCred.dispose();
                } else {
                    String tgsName = Krb5Util.getTGSName(this.srcName);
                    Krb5Util.checkServicePermission(tgsName, action);
                }
            }
            String targetStr = this.targetName.getKrbName();
            Krb5Util.checkServicePermission(targetStr, action);
            this.skipServicePermCheck = true;
        }
    }

    private void doDelegPermCheck() throws GSSException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            String targetStr = this.targetName.getKrbName();
            String tgsStr = Krb5Util.getTGSName(this.targetName);
            StringBuffer buf = new StringBuffer("\"");
            buf.append(targetStr).append("\" \"");
            buf.append(tgsStr).append('\"');
            String krbPrincPair = buf.toString();
            SunNativeProvider.debug("Checking DelegationPermission (" + krbPrincPair + ")");
            DelegationPermission perm = new DelegationPermission(krbPrincPair);
            sm.checkPermission(perm);
            this.skipDelegPermCheck = true;
        }
    }

    private byte[] retrieveToken(InputStream is, int mechTokenLen) throws GSSException {
        try {
            byte[] result = null;
            if (mechTokenLen != -1) {
                SunNativeProvider.debug("Precomputed mechToken length: " + mechTokenLen);
                GSSHeader gssHeader = new GSSHeader(new ObjectIdentifier(this.cStub.getMech().toString()), mechTokenLen);
                ByteArrayOutputStream baos = new ByteArrayOutputStream(600);
                byte[] mechToken = new byte[mechTokenLen];
                int len = is.read(mechToken);
                assert (mechTokenLen == len);
                gssHeader.encode(baos);
                baos.write(mechToken);
                result = baos.toByteArray();
            } else {
                assert (mechTokenLen == -1);
                DerValue dv = new DerValue(is);
                result = dv.toByteArray();
            }
            SunNativeProvider.debug("Complete Token length: " + result.length);
            return result;
        }
        catch (IOException ioe) {
            throw new GSSExceptionImpl(11, ioe);
        }
    }

    NativeGSSContext(GSSNameElement peer, GSSCredElement myCred, int time, GSSLibStub stub) throws GSSException {
        if (peer == null) {
            throw new GSSException(11, 1, "null peer");
        }
        this.cStub = stub;
        this.cred = myCred;
        this.targetName = peer;
        this.isInitiator = true;
        this.lifetime = time;
        if (GSSUtil.isKerberosMech(this.cStub.getMech())) {
            this.doServicePermCheck();
            if (this.cred == null) {
                this.cred = new GSSCredElement(null, this.lifetime, 1, this.cStub);
            }
            this.srcName = this.cred.getName();
        }
    }

    NativeGSSContext(GSSCredElement myCred, GSSLibStub stub) throws GSSException {
        this.cStub = stub;
        this.cred = myCred;
        if (this.cred != null) {
            this.targetName = this.cred.getName();
        }
        this.isInitiator = false;
        if (GSSUtil.isKerberosMech(this.cStub.getMech()) && this.targetName != null) {
            this.doServicePermCheck();
        }
    }

    NativeGSSContext(long pCtxt, GSSLibStub stub) throws GSSException {
        assert (this.pContext != 0L);
        this.pContext = pCtxt;
        this.cStub = stub;
        long[] info = this.cStub.inquireContext(this.pContext);
        if (info.length != 6) {
            throw new RuntimeException("Bug w/ GSSLibStub.inquireContext()");
        }
        this.srcName = new GSSNameElement(info[0], this.cStub);
        this.targetName = new GSSNameElement(info[1], this.cStub);
        this.isInitiator = info[2] != 0L;
        this.isEstablished = info[3] != 0L;
        this.flags = (int)info[4];
        this.lifetime = (int)info[5];
        Oid mech = this.cStub.getMech();
        if (GSSUtil.isSpNegoMech(mech) || GSSUtil.isKerberosMech(mech)) {
            this.doServicePermCheck();
        }
    }

    public Provider getProvider() {
        return SunNativeProvider.INSTANCE;
    }

    public byte[] initSecContext(InputStream is, int mechTokenLen) throws GSSException {
        byte[] outToken = null;
        if (!this.isEstablished && this.isInitiator) {
            byte[] inToken = null;
            if (this.pContext != 0L) {
                inToken = this.retrieveToken(is, mechTokenLen);
                SunNativeProvider.debug("initSecContext=> inToken len=" + inToken.length);
            }
            if (!this.getCredDelegState()) {
                this.skipDelegPermCheck = true;
            }
            if (GSSUtil.isKerberosMech(this.cStub.getMech()) && !this.skipDelegPermCheck) {
                this.doDelegPermCheck();
            }
            long pCred = this.cred == null ? 0L : this.cred.pCred;
            outToken = this.cStub.initContext(pCred, this.targetName.pName, this.cb, inToken, this);
            SunNativeProvider.debug("initSecContext=> outToken len=" + (outToken == null ? 0 : outToken.length));
            if (GSSUtil.isSpNegoMech(this.cStub.getMech()) && outToken != null) {
                this.actualMech = NativeGSSContext.getMechFromSpNegoToken(outToken, true);
                if (GSSUtil.isKerberosMech(this.actualMech)) {
                    if (!this.skipServicePermCheck) {
                        this.doServicePermCheck();
                    }
                    if (!this.skipDelegPermCheck) {
                        this.doDelegPermCheck();
                    }
                }
            }
            if (this.isEstablished) {
                if (this.srcName == null) {
                    this.srcName = new GSSNameElement(this.cStub.getContextName(this.pContext, true), this.cStub);
                }
                if (this.cred == null) {
                    this.cred = new GSSCredElement(this.srcName, this.lifetime, 1, this.cStub);
                }
            }
        }
        return outToken;
    }

    public byte[] acceptSecContext(InputStream is, int mechTokenLen) throws GSSException {
        byte[] outToken = null;
        if (!this.isEstablished && !this.isInitiator) {
            byte[] inToken = this.retrieveToken(is, mechTokenLen);
            SunNativeProvider.debug("acceptSecContext=> inToken len=" + inToken.length);
            long pCred = this.cred == null ? 0L : this.cred.pCred;
            outToken = this.cStub.acceptContext(pCred, this.cb, inToken, this);
            SunNativeProvider.debug("acceptSecContext=> outToken len=" + (outToken == null ? 0 : outToken.length));
            if (this.targetName == null) {
                this.targetName = new GSSNameElement(this.cStub.getContextName(this.pContext, false), this.cStub);
                if (this.cred != null) {
                    this.cred.dispose();
                }
                this.cred = new GSSCredElement(this.targetName, this.lifetime, 2, this.cStub);
            }
            if (GSSUtil.isSpNegoMech(this.cStub.getMech()) && outToken != null && !this.skipServicePermCheck && GSSUtil.isKerberosMech(NativeGSSContext.getMechFromSpNegoToken(outToken, false))) {
                this.doServicePermCheck();
            }
        }
        return outToken;
    }

    public boolean isEstablished() {
        return this.isEstablished;
    }

    public void dispose() throws GSSException {
        this.srcName = null;
        this.targetName = null;
        this.cred = null;
        this.delegatedCred = null;
        if (this.pContext != 0L) {
            this.pContext = this.cStub.deleteContext(this.pContext);
            this.pContext = 0L;
        }
    }

    public int getWrapSizeLimit(int qop, boolean confReq, int maxTokenSize) throws GSSException {
        return this.cStub.wrapSizeLimit(this.pContext, confReq ? 1 : 0, qop, maxTokenSize);
    }

    public byte[] wrap(byte[] inBuf, int offset, int len, MessageProp msgProp) throws GSSException {
        byte[] data = inBuf;
        if (offset != 0 || len != inBuf.length) {
            data = new byte[len];
            System.arraycopy(inBuf, offset, data, 0, len);
        }
        return this.cStub.wrap(this.pContext, data, msgProp);
    }

    public void wrap(byte[] inBuf, int offset, int len, OutputStream os, MessageProp msgProp) throws GSSException {
        try {
            byte[] result = this.wrap(inBuf, offset, len, msgProp);
            os.write(result);
        }
        catch (IOException ioe) {
            throw new GSSExceptionImpl(11, ioe);
        }
    }

    public int wrap(byte[] inBuf, int inOffset, int len, byte[] outBuf, int outOffset, MessageProp msgProp) throws GSSException {
        byte[] result = this.wrap(inBuf, inOffset, len, msgProp);
        System.arraycopy(result, 0, outBuf, outOffset, result.length);
        return result.length;
    }

    public void wrap(InputStream inStream, OutputStream outStream, MessageProp msgProp) throws GSSException {
        try {
            byte[] data = new byte[inStream.available()];
            int length = inStream.read(data);
            byte[] token = this.wrap(data, 0, length, msgProp);
            outStream.write(token);
        }
        catch (IOException ioe) {
            throw new GSSExceptionImpl(11, ioe);
        }
    }

    public byte[] unwrap(byte[] inBuf, int offset, int len, MessageProp msgProp) throws GSSException {
        if (offset != 0 || len != inBuf.length) {
            byte[] temp = new byte[len];
            System.arraycopy(inBuf, offset, temp, 0, len);
            return this.cStub.unwrap(this.pContext, temp, msgProp);
        }
        return this.cStub.unwrap(this.pContext, inBuf, msgProp);
    }

    public int unwrap(byte[] inBuf, int inOffset, int len, byte[] outBuf, int outOffset, MessageProp msgProp) throws GSSException {
        byte[] result = null;
        if (inOffset != 0 || len != inBuf.length) {
            byte[] temp = new byte[len];
            System.arraycopy(inBuf, inOffset, temp, 0, len);
            result = this.cStub.unwrap(this.pContext, temp, msgProp);
        } else {
            result = this.cStub.unwrap(this.pContext, inBuf, msgProp);
        }
        System.arraycopy(result, 0, outBuf, outOffset, result.length);
        return result.length;
    }

    public void unwrap(InputStream inStream, OutputStream outStream, MessageProp msgProp) throws GSSException {
        try {
            byte[] wrapped = new byte[inStream.available()];
            int wLength = inStream.read(wrapped);
            byte[] data = this.unwrap(wrapped, 0, wLength, msgProp);
            outStream.write(data);
            outStream.flush();
        }
        catch (IOException ioe) {
            throw new GSSExceptionImpl(11, ioe);
        }
    }

    public int unwrap(InputStream inStream, byte[] outBuf, int outOffset, MessageProp msgProp) throws GSSException {
        byte[] result;
        byte[] wrapped = null;
        int wLength = 0;
        try {
            wrapped = new byte[inStream.available()];
            wLength = inStream.read(wrapped);
            result = this.unwrap(wrapped, 0, wLength, msgProp);
        }
        catch (IOException ioe) {
            throw new GSSExceptionImpl(11, ioe);
        }
        result = this.unwrap(wrapped, 0, wLength, msgProp);
        System.arraycopy(result, 0, outBuf, outOffset, result.length);
        return result.length;
    }

    public byte[] getMIC(byte[] in, int offset, int len, MessageProp msgProp) throws GSSException {
        int qop = msgProp == null ? 0 : msgProp.getQOP();
        byte[] inMsg = in;
        if (offset != 0 || len != in.length) {
            inMsg = new byte[len];
            System.arraycopy(in, offset, inMsg, 0, len);
        }
        return this.cStub.getMic(this.pContext, qop, inMsg);
    }

    public void getMIC(InputStream inStream, OutputStream outStream, MessageProp msgProp) throws GSSException {
        try {
            int length = 0;
            byte[] msg = new byte[inStream.available()];
            length = inStream.read(msg);
            byte[] msgToken = this.getMIC(msg, 0, length, msgProp);
            if (msgToken != null && msgToken.length != 0) {
                outStream.write(msgToken);
            }
        }
        catch (IOException ioe) {
            throw new GSSExceptionImpl(11, ioe);
        }
    }

    public void verifyMIC(byte[] inToken, int tOffset, int tLen, byte[] inMsg, int mOffset, int mLen, MessageProp msgProp) throws GSSException {
        byte[] token = inToken;
        byte[] msg = inMsg;
        if (tOffset != 0 || tLen != inToken.length) {
            token = new byte[tLen];
            System.arraycopy(inToken, tOffset, token, 0, tLen);
        }
        if (mOffset != 0 || mLen != inMsg.length) {
            msg = new byte[mLen];
            System.arraycopy(inMsg, mOffset, msg, 0, mLen);
        }
        this.cStub.verifyMic(this.pContext, token, msg, msgProp);
    }

    public void verifyMIC(InputStream tokStream, InputStream msgStream, MessageProp msgProp) throws GSSException {
        try {
            byte[] msg = new byte[msgStream.available()];
            int mLength = msgStream.read(msg);
            byte[] tok = new byte[tokStream.available()];
            int tLength = tokStream.read(tok);
            this.verifyMIC(tok, 0, tLength, msg, 0, mLength, msgProp);
        }
        catch (IOException ioe) {
            throw new GSSExceptionImpl(11, ioe);
        }
    }

    public byte[] export() throws GSSException {
        byte[] result = this.cStub.exportContext(this.pContext);
        this.pContext = 0L;
        return result;
    }

    private void changeFlags(int flagMask, boolean isEnable) {
        if (this.isInitiator && this.pContext == 0L) {
            this.flags = isEnable ? (this.flags |= flagMask) : (this.flags &= ~flagMask);
        }
    }

    public void requestMutualAuth(boolean state) throws GSSException {
        this.changeFlags(2, state);
    }

    public void requestReplayDet(boolean state) throws GSSException {
        this.changeFlags(4, state);
    }

    public void requestSequenceDet(boolean state) throws GSSException {
        this.changeFlags(8, state);
    }

    public void requestCredDeleg(boolean state) throws GSSException {
        this.changeFlags(1, state);
    }

    public void requestAnonymity(boolean state) throws GSSException {
        this.changeFlags(64, state);
    }

    public void requestConf(boolean state) throws GSSException {
        this.changeFlags(16, state);
    }

    public void requestInteg(boolean state) throws GSSException {
        this.changeFlags(32, state);
    }

    public void requestLifetime(int lifetime) throws GSSException {
        if (this.isInitiator && this.pContext == 0L) {
            this.lifetime = lifetime;
        }
    }

    public void setChannelBinding(ChannelBinding cb) throws GSSException {
        if (this.pContext == 0L) {
            this.cb = cb;
        }
    }

    private boolean checkFlags(int flagMask) {
        return (this.flags & flagMask) != 0;
    }

    public boolean getCredDelegState() {
        return this.checkFlags(1);
    }

    public boolean getMutualAuthState() {
        return this.checkFlags(2);
    }

    public boolean getReplayDetState() {
        return this.checkFlags(4);
    }

    public boolean getSequenceDetState() {
        return this.checkFlags(8);
    }

    public boolean getAnonymityState() {
        return this.checkFlags(64);
    }

    public boolean isTransferable() throws GSSException {
        return this.checkFlags(256);
    }

    public boolean isProtReady() {
        return this.checkFlags(128);
    }

    public boolean getConfState() {
        return this.checkFlags(16);
    }

    public boolean getIntegState() {
        return this.checkFlags(32);
    }

    public int getLifetime() {
        return this.cStub.getContextTime(this.pContext);
    }

    public GSSNameSpi getSrcName() throws GSSException {
        return this.srcName;
    }

    public GSSNameSpi getTargName() throws GSSException {
        return this.targetName;
    }

    public Oid getMech() throws GSSException {
        if (this.isEstablished && this.actualMech != null) {
            return this.actualMech;
        }
        return this.cStub.getMech();
    }

    public GSSCredentialSpi getDelegCred() throws GSSException {
        return this.delegatedCred;
    }

    public boolean isInitiator() {
        return this.isInitiator;
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }
}

