/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.wrapper;

import java.io.UnsupportedEncodingException;
import java.security.Provider;
import java.util.Vector;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSExceptionImpl;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.jgss.spi.MechanismFactory;
import sun.security.jgss.wrapper.GSSCredElement;
import sun.security.jgss.wrapper.GSSLibStub;
import sun.security.jgss.wrapper.GSSNameElement;
import sun.security.jgss.wrapper.NativeGSSContext;
import sun.security.jgss.wrapper.SunNativeProvider;

public final class NativeGSSFactory
implements MechanismFactory {
    GSSLibStub cStub = null;
    private final int caller;

    private GSSCredElement getCredFromSubject(GSSNameElement name, boolean initiate) throws GSSException {
        GSSCredElement result;
        Oid mech = this.cStub.getMech();
        Vector creds = GSSUtil.searchSubject(name, mech, initiate, GSSCredElement.class);
        if (creds != null && creds.isEmpty() && GSSUtil.useSubjectCredsOnly(this.caller)) {
            throw new GSSException(13);
        }
        GSSCredElement gSSCredElement = result = creds == null || creds.isEmpty() ? null : (GSSCredElement)creds.firstElement();
        if (result != null) {
            result.doServicePermCheck();
        }
        return result;
    }

    public NativeGSSFactory(int caller) {
        this.caller = caller;
    }

    public void setMech(Oid mech) throws GSSException {
        this.cStub = GSSLibStub.getInstance(mech);
    }

    public GSSNameSpi getNameElement(String nameStr, Oid nameType) throws GSSException {
        try {
            byte[] nameBytes = nameStr == null ? null : nameStr.getBytes("UTF-8");
            return new GSSNameElement(nameBytes, nameType, this.cStub);
        }
        catch (UnsupportedEncodingException uee) {
            throw new GSSExceptionImpl(11, uee);
        }
    }

    public GSSNameSpi getNameElement(byte[] name, Oid nameType) throws GSSException {
        return new GSSNameElement(name, nameType, this.cStub);
    }

    public GSSCredentialSpi getCredentialElement(GSSNameSpi name, int initLifetime, int acceptLifetime, int usage) throws GSSException {
        GSSCredElement credElement;
        GSSNameElement nname = null;
        nname = name != null && !(name instanceof GSSNameElement) ? (GSSNameElement)this.getNameElement(((Object)name).toString(), name.getStringNameType()) : (GSSNameElement)name;
        if (usage == 0) {
            usage = 1;
        }
        if ((credElement = this.getCredFromSubject(nname, usage == 1)) == null) {
            if (usage == 1) {
                credElement = new GSSCredElement(nname, initLifetime, usage, this.cStub);
            } else if (usage == 2) {
                if (nname == null) {
                    nname = GSSNameElement.DEF_ACCEPTOR;
                }
                credElement = new GSSCredElement(nname, acceptLifetime, usage, this.cStub);
            } else {
                throw new GSSException(11, -1, "Unknown usage mode requested");
            }
        }
        return credElement;
    }

    public GSSContextSpi getMechanismContext(GSSNameSpi peer, GSSCredentialSpi myCred, int lifetime) throws GSSException {
        if (peer == null) {
            throw new GSSException(3);
        }
        if (!(peer instanceof GSSNameElement)) {
            peer = (GSSNameElement)this.getNameElement(((Object)peer).toString(), peer.getStringNameType());
        }
        if (myCred == null) {
            myCred = this.getCredFromSubject(null, true);
        } else if (!(myCred instanceof GSSCredElement)) {
            throw new GSSException(13);
        }
        return new NativeGSSContext((GSSNameElement)peer, (GSSCredElement)myCred, lifetime, this.cStub);
    }

    public GSSContextSpi getMechanismContext(GSSCredentialSpi myCred) throws GSSException {
        if (myCred == null) {
            myCred = this.getCredFromSubject(null, false);
        } else if (!(myCred instanceof GSSCredElement)) {
            throw new GSSException(13);
        }
        return new NativeGSSContext((GSSCredElement)myCred, this.cStub);
    }

    public GSSContextSpi getMechanismContext(byte[] exportedContext) throws GSSException {
        return this.cStub.importContext(exportedContext);
    }

    public final Oid getMechanismOid() {
        return this.cStub.getMech();
    }

    public Provider getProvider() {
        return SunNativeProvider.INSTANCE;
    }

    public Oid[] getNameTypes() throws GSSException {
        return this.cStub.inquireNamesForMech();
    }
}

