/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.ccache;

import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.AuthorizationData;
import sun.security.krb5.internal.AuthorizationDataEntry;
import sun.security.krb5.internal.HostAddress;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.Ticket;
import sun.security.krb5.internal.TicketFlags;
import sun.security.krb5.internal.ccache.Credentials;
import sun.security.krb5.internal.ccache.FileCCacheConstants;
import sun.security.krb5.internal.ccache.Tag;
import sun.security.krb5.internal.util.KrbDataInputStream;

public class CCacheInputStream
extends KrbDataInputStream
implements FileCCacheConstants {
    private static boolean DEBUG = Krb5.DEBUG;

    public CCacheInputStream(InputStream is) {
        super(is);
    }

    public Tag readTag() throws IOException {
        char[] buf = new char[1024];
        int tag = -1;
        Integer time_offset = null;
        Integer usec_offset = null;
        int len = this.read(2);
        if (len < 0) {
            throw new IOException("stop.");
        }
        byte[] bytes = new byte[len + 2];
        if (len > buf.length) {
            throw new IOException("Invalid tag length.");
        }
        while (len > 0) {
            tag = this.read(2);
            int taglen = this.read(2);
            switch (tag) {
                case 1: {
                    time_offset = new Integer(this.read(4));
                    usec_offset = new Integer(this.read(4));
                    break;
                }
            }
            len -= 4 + taglen;
        }
        if (tag == -1) {
            // empty if block
        }
        Tag result = new Tag(len, tag, time_offset, usec_offset);
        return result;
    }

    public PrincipalName readPrincipal(int version) throws IOException, RealmException {
        PrincipalName p;
        String[] pname = null;
        int type = version == 1281 ? 0 : this.read(4);
        int length = this.read(4);
        String[] result = new String[length + 1];
        if (version == 1281) {
            --length;
        }
        for (int i = 0; i <= length; ++i) {
            int namelength = this.read(4);
            if (namelength > 1024) {
                throw new IOException("Invalid name length in principal name.");
            }
            byte[] bytes = new byte[namelength];
            this.read(bytes, 0, namelength);
            result[i] = new String(bytes);
        }
        if (this.isRealm(result[0])) {
            String realm = result[0];
            pname = new String[length];
            System.arraycopy(result, 1, pname, 0, length);
            p = new PrincipalName(pname, type);
            p.setRealm(realm);
        } else {
            p = new PrincipalName(result, type);
        }
        return p;
    }

    boolean isRealm(String str) {
        try {
            Realm r = new Realm(str);
        }
        catch (Exception e) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(str, ".");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) < '\u008d') continue;
                return false;
            }
        }
        return true;
    }

    EncryptionKey readKey(int version) throws IOException {
        int keyType = this.read(2);
        if (version == 1283) {
            this.read(2);
        }
        int keyLen = this.read(4);
        byte[] bytes = new byte[keyLen];
        for (int i = 0; i < keyLen; ++i) {
            bytes[i] = (byte)this.read();
        }
        return new EncryptionKey(bytes, keyType, new Integer(version));
    }

    long[] readTimes() throws IOException {
        long[] times = new long[]{(long)this.read(4) * 1000L, (long)this.read(4) * 1000L, (long)this.read(4) * 1000L, (long)this.read(4) * 1000L};
        return times;
    }

    boolean readskey() throws IOException {
        return this.read() != 0;
    }

    HostAddress[] readAddr() throws IOException, KrbApErrException {
        int numAddrs = this.read(4);
        if (numAddrs > 0) {
            HostAddress[] addrs = new HostAddress[numAddrs];
            for (int i = 0; i < numAddrs; ++i) {
                int addrType = this.read(2);
                int addrLength = this.read(4);
                if (addrLength != 4 && addrLength != 16) {
                    System.out.println("Incorrect address format.");
                    return null;
                }
                byte[] result = new byte[addrLength];
                for (int j = 0; j < addrLength; ++j) {
                    result[j] = (byte)this.read(1);
                }
                addrs[i] = new HostAddress(addrType, result);
            }
            return addrs;
        }
        return null;
    }

    AuthorizationDataEntry[] readAuth() throws IOException {
        int num = this.read(4);
        if (num > 0) {
            AuthorizationDataEntry[] auData = new AuthorizationDataEntry[num];
            byte[] data = null;
            for (int i = 0; i < num; ++i) {
                int adtype = this.read(2);
                int adlength = this.read(4);
                data = new byte[adlength];
                for (int j = 0; j < adlength; ++j) {
                    data[j] = (byte)this.read();
                }
                auData[i] = new AuthorizationDataEntry(adtype, data);
            }
            return auData;
        }
        return null;
    }

    byte[] readData() throws IOException {
        int length = this.read(4);
        if (length == 0) {
            return null;
        }
        byte[] bytes = new byte[length];
        this.read(bytes, 0, length);
        return bytes;
    }

    boolean[] readFlags() throws IOException {
        boolean[] flags = new boolean[32];
        int ticketFlags = this.read(4);
        if ((ticketFlags & 0x40000000) == 0x40000000) {
            flags[1] = true;
        }
        if ((ticketFlags & 0x20000000) == 0x20000000) {
            flags[2] = true;
        }
        if ((ticketFlags & 0x10000000) == 0x10000000) {
            flags[3] = true;
        }
        if ((ticketFlags & 0x8000000) == 0x8000000) {
            flags[4] = true;
        }
        if ((ticketFlags & 0x4000000) == 0x4000000) {
            flags[5] = true;
        }
        if ((ticketFlags & 0x2000000) == 0x2000000) {
            flags[6] = true;
        }
        if ((ticketFlags & 0x1000000) == 0x1000000) {
            flags[7] = true;
        }
        if ((ticketFlags & 0x800000) == 0x800000) {
            flags[8] = true;
        }
        if ((ticketFlags & 0x400000) == 0x400000) {
            flags[9] = true;
        }
        if ((ticketFlags & 0x200000) == 0x200000) {
            flags[10] = true;
        }
        if ((ticketFlags & 0x100000) == 0x100000) {
            flags[11] = true;
        }
        if (DEBUG) {
            String msg = ">>> CCacheInputStream: readFlags() ";
            if (flags[1]) {
                msg = msg + " FORWARDABLE;";
            }
            if (flags[2]) {
                msg = msg + " FORWARDED;";
            }
            if (flags[3]) {
                msg = msg + " PROXIABLE;";
            }
            if (flags[4]) {
                msg = msg + " PROXY;";
            }
            if (flags[5]) {
                msg = msg + " MAY_POSTDATE;";
            }
            if (flags[6]) {
                msg = msg + " POSTDATED;";
            }
            if (flags[7]) {
                msg = msg + " INVALID;";
            }
            if (flags[8]) {
                msg = msg + " RENEWABLE;";
            }
            if (flags[9]) {
                msg = msg + " INITIAL;";
            }
            if (flags[10]) {
                msg = msg + " PRE_AUTH;";
            }
            if (flags[11]) {
                msg = msg + " HW_AUTH;";
            }
            System.out.println(msg);
        }
        return flags;
    }

    Credentials readCred(int version) throws IOException, RealmException, KrbApErrException, Asn1Exception {
        PrincipalName cpname = this.readPrincipal(version);
        if (DEBUG) {
            System.out.println(">>>DEBUG <CCacheInputStream>  client principal is " + cpname.toString());
        }
        PrincipalName spname = this.readPrincipal(version);
        if (DEBUG) {
            System.out.println(">>>DEBUG <CCacheInputStream> server principal is " + spname.toString());
        }
        EncryptionKey key = this.readKey(version);
        if (DEBUG) {
            System.out.println(">>>DEBUG <CCacheInputStream> key type: " + key.getEType());
        }
        long[] times = this.readTimes();
        KerberosTime authtime = new KerberosTime(times[0]);
        KerberosTime starttime = new KerberosTime(times[1]);
        KerberosTime endtime = new KerberosTime(times[2]);
        KerberosTime renewTill = new KerberosTime(times[3]);
        if (DEBUG) {
            System.out.println(">>>DEBUG <CCacheInputStream> auth time: " + authtime.toDate().toString());
            System.out.println(">>>DEBUG <CCacheInputStream> start time: " + starttime.toDate().toString());
            System.out.println(">>>DEBUG <CCacheInputStream> end time: " + endtime.toDate().toString());
            System.out.println(">>>DEBUG <CCacheInputStream> renew_till time: " + renewTill.toDate().toString());
        }
        boolean skey = this.readskey();
        boolean[] flags = this.readFlags();
        TicketFlags tFlags = new TicketFlags(flags);
        HostAddress[] addr = this.readAddr();
        HostAddresses addrs = null;
        if (addr != null) {
            addrs = new HostAddresses(addr);
        }
        AuthorizationDataEntry[] auDataEntry = this.readAuth();
        AuthorizationData auData = null;
        if (auData != null) {
            auData = new AuthorizationData(auDataEntry);
        }
        byte[] ticketData = this.readData();
        byte[] ticketData2 = this.readData();
        try {
            return new Credentials(cpname, spname, key, authtime, starttime, endtime, renewTill, skey, tFlags, addrs, auData, ticketData != null ? new Ticket(ticketData) : null, ticketData2 != null ? new Ticket(ticketData2) : null);
        }
        catch (Exception e) {
            return null;
        }
    }
}

