/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto;

import java.security.GeneralSecurityException;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.crypto.Aes128;
import sun.security.krb5.internal.crypto.CksumType;

public class HmacSha1Aes128CksumType
extends CksumType {
    public int confounderSize() {
        return 16;
    }

    public int cksumType() {
        return 15;
    }

    public boolean isSafe() {
        return true;
    }

    public int cksumSize() {
        return 12;
    }

    public int keyType() {
        return 3;
    }

    public int keySize() {
        return 16;
    }

    public byte[] calculateChecksum(byte[] data, int size) {
        return null;
    }

    public byte[] calculateKeyedChecksum(byte[] data, int size, byte[] key, int usage) throws KrbCryptoException {
        try {
            return Aes128.calculateChecksum(key, usage, data, 0, size);
        }
        catch (GeneralSecurityException e) {
            KrbCryptoException ke = new KrbCryptoException(e.getMessage());
            ke.initCause(e);
            throw ke;
        }
    }

    public boolean verifyKeyedChecksum(byte[] data, int size, byte[] key, byte[] checksum, int usage) throws KrbCryptoException {
        try {
            byte[] newCksum = Aes128.calculateChecksum(key, usage, data, 0, size);
            return HmacSha1Aes128CksumType.isChecksumEqual(checksum, newCksum);
        }
        catch (GeneralSecurityException e) {
            KrbCryptoException ke = new KrbCryptoException(e.getMessage());
            ke.initCause(e);
            throw ke;
        }
    }
}

