/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import sun.text.CodePointIterator;

final class CharArrayCodePointIterator
extends CodePointIterator {
    private char[] text;
    private int start;
    private int limit;
    private int index;

    public CharArrayCodePointIterator(char[] text) {
        this.text = text;
        this.limit = text.length;
    }

    public CharArrayCodePointIterator(char[] text, int start, int limit) {
        if (start < 0 || limit < start || limit > text.length) {
            throw new IllegalArgumentException();
        }
        this.text = text;
        this.start = this.index = start;
        this.limit = limit;
    }

    public void setToStart() {
        this.index = this.start;
    }

    public void setToLimit() {
        this.index = this.limit;
    }

    public int next() {
        if (this.index < this.limit) {
            char cp2;
            char cp1;
            if (Character.isHighSurrogate(cp1 = this.text[this.index++]) && this.index < this.limit && Character.isLowSurrogate(cp2 = this.text[this.index])) {
                ++this.index;
                return Character.toCodePoint(cp1, cp2);
            }
            return cp1;
        }
        return -1;
    }

    public int prev() {
        if (this.index > this.start) {
            char cp1;
            char cp2;
            if (Character.isLowSurrogate(cp2 = this.text[--this.index]) && this.index > this.start && Character.isHighSurrogate(cp1 = this.text[this.index - 1])) {
                --this.index;
                return Character.toCodePoint(cp1, cp2);
            }
            return cp2;
        }
        return -1;
    }

    public int charIndex() {
        return this.index;
    }
}

