/*
 * Decompiled with CFR 0.152.
 */
package sun.text.normalizer;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.text.normalizer.CharTrie;
import sun.text.normalizer.ICUData;
import sun.text.normalizer.NormalizerImpl;
import sun.text.normalizer.RangeValueIterator;
import sun.text.normalizer.Trie;
import sun.text.normalizer.TrieIterator;
import sun.text.normalizer.UCharacter;
import sun.text.normalizer.UCharacterPropertyReader;
import sun.text.normalizer.UTF16;
import sun.text.normalizer.UnicodeSet;
import sun.text.normalizer.VersionInfo;

public final class UCharacterProperty
implements Trie.DataManipulate {
    public CharTrie m_trie_;
    public char[] m_trieIndex_;
    public char[] m_trieData_;
    public int m_trieInitialValue_;
    public int[] m_property_;
    public VersionInfo m_unicodeVersion_;
    public static final int EXC_UPPERCASE_ = 0;
    public static final int EXC_LOWERCASE_ = 1;
    public static final int EXC_TITLECASE_ = 2;
    public static final int EXC_UNUSED_ = 3;
    public static final int EXC_NUMERIC_VALUE_ = 4;
    public static final int EXC_DENOMINATOR_VALUE_ = 5;
    public static final int EXC_MIRROR_MAPPING_ = 6;
    public static final int EXC_SPECIAL_CASING_ = 7;
    public static final int EXC_CASE_FOLDING_ = 8;
    public static final int EXC_COMBINING_CLASS_ = 9;
    public static final char LATIN_SMALL_LETTER_I_ = 'i';
    public static final int TYPE_MASK = 31;
    public static final int EXCEPTION_MASK = 32;
    char[] m_case_;
    int[] m_exception_;
    CharTrie m_additionalTrie_;
    int[] m_additionalVectors_;
    int m_additionalColumnsCount_;
    int m_maxBlockScriptValue_;
    int m_maxJTGValue_;
    private static UCharacterProperty INSTANCE_ = null;
    private static final String DATA_FILE_NAME_ = "/sun/text/resources/uprops.icu";
    private static final int DATA_BUFFER_SIZE_ = 25000;
    private static final int EXC_GROUP_ = 8;
    private static final int EXC_GROUP_MASK_ = 255;
    private static final int EXC_DIGIT_MASK_ = 65535;
    private static final byte[] FLAGS_OFFSET_ = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    private static final int VALUE_SHIFT_ = 20;
    private static final int UNSIGNED_VALUE_MASK_AFTER_SHIFT_ = 2047;
    private static final int NUMERIC_TYPE_SHIFT = 12;
    private static final int SUPPLEMENTARY_FOLD_INDICATOR_MASK_ = 32768;
    private static final int SUPPLEMENTARY_FOLD_OFFSET_MASK_ = Short.MAX_VALUE;
    private static final int LEAD_SURROGATE_SHIFT_ = 10;
    private static final int SURROGATE_OFFSET_ = -56613888;
    private static final int LAST_CHAR_MASK_ = 65535;
    private static final int FIRST_NIBBLE_SHIFT_ = 4;
    private static final int LAST_NIBBLE_MASK_ = 15;
    private static final int AGE_SHIFT_ = 24;
    private static final int TAB = 9;
    private static final int LF = 10;
    private static final int FF = 12;
    private static final int CR = 13;
    private static final int U_A = 65;
    private static final int U_Z = 90;
    private static final int U_a = 97;
    private static final int U_z = 122;
    private static final int DEL = 127;
    private static final int NL = 133;
    private static final int NBSP = 160;
    private static final int CGJ = 847;
    private static final int FIGURESP = 8199;
    private static final int HAIRSP = 8202;
    private static final int ZWNJ = 8204;
    private static final int ZWJ = 8205;
    private static final int RLM = 8207;
    private static final int NNBSP = 8239;
    private static final int WJ = 8288;
    private static final int INHSWAP = 8298;
    private static final int NOMDIG = 8303;
    private static final int ZWNBSP = 65279;

    public void setIndexData(CharTrie.FriendAgent friendagent) {
        this.m_trieIndex_ = friendagent.getPrivateIndex();
        this.m_trieData_ = friendagent.getPrivateData();
        this.m_trieInitialValue_ = friendagent.getPrivateInitialValue();
    }

    public int getFoldingOffset(int value) {
        if ((value & 0x8000) != 0) {
            return value & Short.MAX_VALUE;
        }
        return 0;
    }

    public int getProperty(int ch) {
        if (ch < 55296 || ch > 56319 && ch < 65536) {
            try {
                return this.m_property_[this.m_trieData_[(this.m_trieIndex_[ch >> 5] << 2) + (ch & 0x1F)]];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return this.m_property_[this.m_trieInitialValue_];
            }
        }
        if (ch <= 56319) {
            return this.m_property_[this.m_trieData_[(this.m_trieIndex_[320 + (ch >> 5)] << 2) + (ch & 0x1F)]];
        }
        if (ch <= 0x10FFFF) {
            return this.m_property_[this.m_trie_.getSurrogateValue(UTF16.getLeadSurrogate(ch), (char)(ch & 0x3FF))];
        }
        return this.m_property_[this.m_trieInitialValue_];
    }

    public static int getSignedValue(int prop) {
        return prop >> 20;
    }

    public static int getExceptionIndex(int prop) {
        return prop >> 20 & 0x7FF;
    }

    public boolean hasExceptionValue(int index, int indicator) {
        return (this.m_exception_[index] & 1 << indicator) != 0;
    }

    public int getException(int index, int etype) {
        if (etype == 9) {
            return this.m_exception_[index];
        }
        int n = this.m_exception_[index];
        ++index;
        index = this.addExceptionOffset(n, etype, index);
        return this.m_exception_[index];
    }

    public void getFoldCase(int index, int count, StringBuffer str) {
        index += 2;
        while (count > 0) {
            str.append(this.m_case_[index]);
            ++index;
            --count;
        }
    }

    public int getAdditional(int codepoint) {
        return this.m_additionalVectors_[this.m_additionalTrie_.getCodePointValue(codepoint)];
    }

    public VersionInfo getAge(int codepoint) {
        int version = this.getAdditional(codepoint) >> 24;
        return VersionInfo.getInstance(version >> 4 & 0xF, version & 0xF, 0, 0);
    }

    public static int getRawSupplementary(char lead, char trail) {
        return (lead << 10) + trail + -56613888;
    }

    public static UCharacterProperty getInstance() throws RuntimeException {
        if (INSTANCE_ == null) {
            try {
                INSTANCE_ = new UCharacterProperty();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return INSTANCE_;
    }

    public static boolean isRuleWhiteSpace(int c) {
        return c >= 9 && c <= 8233 && (c <= 13 || c == 32 || c == 133 || c == 8206 || c == 8207 || c >= 8232);
    }

    private UCharacterProperty() throws IOException {
        InputStream is = ICUData.getRequiredStream(DATA_FILE_NAME_);
        BufferedInputStream b = new BufferedInputStream(is, 25000);
        UCharacterPropertyReader reader = new UCharacterPropertyReader(b);
        reader.read(this);
        b.close();
        this.m_trie_.putIndexData(this);
    }

    private int addExceptionOffset(int evalue, int indicator, int address) {
        int result = address;
        if (indicator >= 8) {
            result += FLAGS_OFFSET_[evalue & 0xFF];
            evalue >>= 8;
            indicator -= 8;
        }
        int mask = (1 << indicator) - 1;
        return result += FLAGS_OFFSET_[evalue & mask];
    }

    public UnicodeSet addPropertyStarts(UnicodeSet set) {
        int value2;
        int c;
        TrieIterator propsIter = new TrieIterator(this.m_trie_);
        RangeValueIterator.Element propsResult = new RangeValueIterator.Element();
        while (propsIter.next(propsResult)) {
            set.add(propsResult.start);
        }
        TrieIterator propsVectorsIter = new TrieIterator(this.m_additionalTrie_);
        RangeValueIterator.Element propsVectorsResult = new RangeValueIterator.Element();
        while (propsVectorsIter.next(propsVectorsResult)) {
            set.add(propsVectorsResult.start);
        }
        set.add(9);
        set.add(14);
        set.add(28);
        set.add(32);
        set.add(133);
        set.add(134);
        set.add(127);
        set.add(8202);
        set.add(8208);
        set.add(8298);
        set.add(8304);
        set.add(65279);
        set.add(65280);
        set.add(160);
        set.add(161);
        set.add(8199);
        set.add(8200);
        set.add(8239);
        set.add(8240);
        set.add(12295);
        set.add(12296);
        set.add(19968);
        set.add(19969);
        set.add(20108);
        set.add(20109);
        set.add(19977);
        set.add(19978);
        set.add(22235);
        set.add(22236);
        set.add(20116);
        set.add(20117);
        set.add(20845);
        set.add(20846);
        set.add(19971);
        set.add(19972);
        set.add(20843);
        set.add(20844);
        set.add(20061);
        set.add(20062);
        set.add(97);
        set.add(123);
        set.add(65);
        set.add(91);
        set.add(8288);
        set.add(65520);
        set.add(65532);
        set.add(917504);
        set.add(921600);
        set.add(847);
        set.add(848);
        set.add(8204);
        set.add(8206);
        set.add(4352);
        int value = 1;
        for (c = 4442; c <= 4447; ++c) {
            value2 = UCharacter.getIntPropertyValue(c, 4107);
            if (value == value2) continue;
            value = value2;
            set.add(c);
        }
        set.add(4448);
        value = 2;
        for (c = 4515; c <= 4519; ++c) {
            value2 = UCharacter.getIntPropertyValue(c, 4107);
            if (value == value2) continue;
            value = value2;
            set.add(c);
        }
        set.add(4520);
        value = 3;
        for (c = 4602; c <= 4607; ++c) {
            value2 = UCharacter.getIntPropertyValue(c, 4107);
            if (value == value2) continue;
            value = value2;
            set.add(c);
        }
        return set;
    }

    public UnicodeSet getInclusions() {
        UnicodeSet set = new UnicodeSet();
        NormalizerImpl.addPropertyStarts(set);
        this.addPropertyStarts(set);
        return set;
    }
}

