/*
 * Decompiled with CFR 0.152.
 */
package sun.util.resources;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import sun.security.action.GetPropertyAction;
import sun.util.LocaleDataMetaInfo;
import sun.util.resources.OpenListResourceBundle;

public class LocaleData {
    private static final String localeDataJarName = "localedata.jar";

    public static Locale[] getAvailableLocales() {
        return (Locale[])AvailableLocales.localeList.clone();
    }

    public static ResourceBundle getCalendarData(Locale locale) {
        return LocaleData.getBundle("sun.util.resources.CalendarData", locale);
    }

    public static OpenListResourceBundle getCurrencyNames(Locale locale) {
        return (OpenListResourceBundle)LocaleData.getBundle("sun.util.resources.CurrencyNames", locale);
    }

    public static OpenListResourceBundle getLocaleNames(Locale locale) {
        return (OpenListResourceBundle)LocaleData.getBundle("sun.util.resources.LocaleNames", locale);
    }

    public static OpenListResourceBundle getTimeZoneNames(Locale locale) {
        return (OpenListResourceBundle)LocaleData.getBundle("sun.util.resources.TimeZoneNames", locale);
    }

    public static ResourceBundle getCollationData(Locale locale) {
        return LocaleData.getBundle("sun.text.resources.CollationData", locale);
    }

    public static ResourceBundle getDateFormatData(Locale locale) {
        return LocaleData.getBundle("sun.text.resources.FormatData", locale);
    }

    public static ResourceBundle getNumberFormatData(Locale locale) {
        return LocaleData.getBundle("sun.text.resources.FormatData", locale);
    }

    private static ResourceBundle getBundle(final String baseName, final Locale locale) {
        return (ResourceBundle)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ResourceBundle.getBundle(baseName, locale, LocaleDataResourceBundleControl.getRBControlInstance());
            }
        });
    }

    private static boolean isNonEuroLangSupported() {
        String sep = File.separator;
        String localeDataJar = AccessController.doPrivileged(new GetPropertyAction("java.home")) + sep + "lib" + sep + "ext" + sep + localeDataJarName;
        final File f = new File(localeDataJar);
        boolean isNonEuroResJarExist = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return f.exists();
            }
        });
        return isNonEuroResJarExist;
    }

    private static Locale[] createLocaleList() {
        String supportedLocaleString = LocaleDataMetaInfo.getSupportedLocaleString("sun.text.resources.FormatData");
        if (supportedLocaleString.length() == 0) {
            return null;
        }
        int barIndex = supportedLocaleString.indexOf("|");
        StringTokenizer localeStringTokenizer = null;
        localeStringTokenizer = LocaleData.isNonEuroLangSupported() ? new StringTokenizer(supportedLocaleString.substring(0, barIndex) + supportedLocaleString.substring(barIndex + 1)) : new StringTokenizer(supportedLocaleString.substring(0, barIndex));
        Locale[] locales = new Locale[localeStringTokenizer.countTokens()];
        for (int i = 0; i < locales.length; ++i) {
            String currentToken = localeStringTokenizer.nextToken();
            int p2 = 0;
            int p1 = currentToken.indexOf(95);
            String language = "";
            String country = "";
            String variant = "";
            if (p1 == -1) {
                language = currentToken;
            } else {
                language = currentToken.substring(0, p1);
                p2 = currentToken.indexOf(95, p1 + 1);
                if (p2 == -1) {
                    country = currentToken.substring(p1 + 1);
                } else {
                    country = currentToken.substring(p1 + 1, p2);
                    if (p2 < currentToken.length()) {
                        variant = currentToken.substring(p2 + 1);
                    }
                }
            }
            locales[i] = new Locale(language, country, variant);
        }
        return locales;
    }

    static /* synthetic */ Locale[] access$000() {
        return LocaleData.createLocaleList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LocaleDataResourceBundleControl
    extends ResourceBundle.Control {
        private static LocaleDataResourceBundleControl rbControlInstance = new LocaleDataResourceBundleControl();

        LocaleDataResourceBundleControl() {
        }

        public static LocaleDataResourceBundleControl getRBControlInstance() {
            return rbControlInstance;
        }

        @Override
        public List<Locale> getCandidateLocales(String baseName, Locale locale) {
            List<Locale> candidates = super.getCandidateLocales(baseName, locale);
            String localeString = LocaleDataMetaInfo.getSupportedLocaleString(baseName);
            if (localeString.length() == 0) {
                return candidates;
            }
            Iterator<Locale> l = candidates.iterator();
            while (l.hasNext()) {
                String lstr = l.next().toString();
                if (lstr.length() == 0 || localeString.indexOf(" " + lstr + " ") != -1) continue;
                l.remove();
            }
            return candidates;
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            if (baseName == null || locale == null) {
                throw new NullPointerException();
            }
            return null;
        }
    }

    private static class AvailableLocales {
        static final Locale[] localeList = LocaleData.access$000();

        private AvailableLocales() {
        }
    }
}

