/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

class ByteBufferInputStream
extends InputStream {
    ByteBuffer bb;

    ByteBufferInputStream(ByteBuffer bb) {
        this.bb = bb;
    }

    public int read() throws IOException {
        if (this.bb == null) {
            throw new IOException("read on a closed InputStream");
        }
        if (this.bb.remaining() == 0) {
            return -1;
        }
        return this.bb.get();
    }

    public int read(byte[] b) throws IOException {
        if (this.bb == null) {
            throw new IOException("read on a closed InputStream");
        }
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bb == null) {
            throw new IOException("read on a closed InputStream");
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int length = Math.min(this.bb.remaining(), len);
        if (length == 0) {
            return -1;
        }
        this.bb.get(b, off, length);
        return length;
    }

    public long skip(long n) throws IOException {
        if (this.bb == null) {
            throw new IOException("skip on a closed InputStream");
        }
        if (n <= 0L) {
            return 0L;
        }
        int nInt = (int)n;
        int skip = Math.min(this.bb.remaining(), nInt);
        this.bb.position(this.bb.position() + skip);
        return nInt;
    }

    public int available() throws IOException {
        if (this.bb == null) {
            throw new IOException("available on a closed InputStream");
        }
        return this.bb.remaining();
    }

    public void close() throws IOException {
        this.bb = null;
    }

    public synchronized void mark(int readlimit) {
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public boolean markSupported() {
        return false;
    }
}

