/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLProtocolException;
import javax.security.auth.x500.X500Principal;
import sun.security.internal.spec.TlsPrfParameterSpec;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.DHCrypt;
import sun.security.ssl.Debug;
import sun.security.ssl.ECDHCrypt;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HelloExtensions;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.RSASignature;
import sun.security.ssl.RandomCookie;
import sun.security.ssl.RenegotiationInfoExtension;
import sun.security.ssl.SessionId;
import sun.security.ssl.SupportedEllipticCurvesExtension;
import sun.security.ssl.SupportedEllipticPointFormatsExtension;

abstract class HandshakeMessage {
    static final byte ht_hello_request = 0;
    static final byte ht_client_hello = 1;
    static final byte ht_server_hello = 2;
    static final byte ht_certificate = 11;
    static final byte ht_server_key_exchange = 12;
    static final byte ht_certificate_request = 13;
    static final byte ht_server_hello_done = 14;
    static final byte ht_certificate_verify = 15;
    static final byte ht_client_key_exchange = 16;
    static final byte ht_finished = 20;
    static final Debug debug = Debug.getInstance("ssl");
    static final byte[] MD5_pad1 = HandshakeMessage.genPad(54, 48);
    static final byte[] MD5_pad2 = HandshakeMessage.genPad(92, 48);
    static final byte[] SHA_pad1 = HandshakeMessage.genPad(54, 40);
    static final byte[] SHA_pad2 = HandshakeMessage.genPad(92, 40);

    HandshakeMessage() {
    }

    static byte[] toByteArray(BigInteger bi) {
        byte[] b = bi.toByteArray();
        if (b.length > 1 && b[0] == 0) {
            int n = b.length - 1;
            byte[] newarray = new byte[n];
            System.arraycopy(b, 1, newarray, 0, n);
            b = newarray;
        }
        return b;
    }

    private static byte[] genPad(int b, int count) {
        byte[] padding = new byte[count];
        Arrays.fill(padding, (byte)b);
        return padding;
    }

    final void write(HandshakeOutStream s) throws IOException {
        int len = this.messageLength();
        if (len > 0x1000000) {
            throw new SSLException("Handshake message too big, type = " + this.messageType() + ", len = " + len);
        }
        s.write(this.messageType());
        s.putInt24(len);
        this.send(s);
    }

    abstract int messageType();

    abstract int messageLength();

    abstract void send(HandshakeOutStream var1) throws IOException;

    abstract void print(PrintStream var1) throws IOException;

    static final class Finished
    extends HandshakeMessage {
        static final int CLIENT = 1;
        static final int SERVER = 2;
        private static final byte[] SSL_CLIENT = new byte[]{67, 76, 78, 84};
        private static final byte[] SSL_SERVER = new byte[]{83, 82, 86, 82};
        private byte[] verifyData;

        Finished(ProtocolVersion protocolVersion, HandshakeHash handshakeHash, int sender, SecretKey master) {
            this.verifyData = Finished.getFinished(protocolVersion, handshakeHash, sender, master);
        }

        Finished(ProtocolVersion protocolVersion, HandshakeInStream input) throws IOException {
            int msgLen = protocolVersion.v >= ProtocolVersion.TLS10.v ? 12 : 36;
            this.verifyData = new byte[msgLen];
            input.read(this.verifyData);
        }

        boolean verify(ProtocolVersion protocolVersion, HandshakeHash handshakeHash, int sender, SecretKey master) {
            byte[] myFinished = Finished.getFinished(protocolVersion, handshakeHash, sender, master);
            return Arrays.equals(myFinished, this.verifyData);
        }

        private static byte[] getFinished(ProtocolVersion protocolVersion, HandshakeHash handshakeHash, int sender, SecretKey masterKey) {
            String tlsLabel;
            byte[] sslLabel;
            if (sender == 1) {
                sslLabel = SSL_CLIENT;
                tlsLabel = "client finished";
            } else if (sender == 2) {
                sslLabel = SSL_SERVER;
                tlsLabel = "server finished";
            } else {
                throw new RuntimeException("Invalid sender: " + sender);
            }
            MessageDigest md5Clone = handshakeHash.getMD5Clone();
            MessageDigest shaClone = handshakeHash.getSHAClone();
            if (protocolVersion.v >= ProtocolVersion.TLS10.v) {
                try {
                    byte[] seed = new byte[36];
                    md5Clone.digest(seed, 0, 16);
                    shaClone.digest(seed, 16, 20);
                    TlsPrfParameterSpec spec = new TlsPrfParameterSpec(masterKey, tlsLabel, seed, 12);
                    KeyGenerator prf = JsseJce.getKeyGenerator("SunTlsPrf");
                    prf.init(spec);
                    SecretKey prfKey = prf.generateKey();
                    if (!"RAW".equals(prfKey.getFormat())) {
                        throw new ProviderException("Invalid PRF output, format must be RAW");
                    }
                    byte[] finished = prfKey.getEncoded();
                    return finished;
                }
                catch (GeneralSecurityException e) {
                    throw new RuntimeException("PRF failed", e);
                }
            }
            Finished.updateDigest(md5Clone, sslLabel, MD5_pad1, MD5_pad2, masterKey);
            Finished.updateDigest(shaClone, sslLabel, SHA_pad1, SHA_pad2, masterKey);
            byte[] finished = new byte[36];
            try {
                md5Clone.digest(finished, 0, 16);
                shaClone.digest(finished, 16, 20);
            }
            catch (DigestException e) {
                throw new RuntimeException("Digest failed", e);
            }
            return finished;
        }

        private static void updateDigest(MessageDigest md, byte[] sender, byte[] pad1, byte[] pad2, SecretKey masterSecret) {
            md.update(sender);
            CertificateVerify.updateDigest(md, pad1, pad2, masterSecret);
        }

        byte[] getVerifyData() {
            return this.verifyData;
        }

        int messageType() {
            return 20;
        }

        int messageLength() {
            return this.verifyData.length;
        }

        void send(HandshakeOutStream out) throws IOException {
            out.write(this.verifyData);
        }

        void print(PrintStream s) throws IOException {
            s.println("*** Finished");
            if (debug != null && Debug.isOn("verbose")) {
                Debug.println(s, "verify_data", this.verifyData);
                s.println("***");
            }
        }
    }

    static final class CertificateVerify
    extends HandshakeMessage {
        private byte[] signature;
        private static final Class delegate;
        private static final Field spiField;
        private static final Object NULL_OBJECT;
        private static final Map<Class, Object> methodCache;

        int messageType() {
            return 15;
        }

        CertificateVerify(ProtocolVersion protocolVersion, HandshakeHash handshakeHash, PrivateKey privateKey, SecretKey masterSecret, SecureRandom sr) throws GeneralSecurityException {
            String algorithm = privateKey.getAlgorithm();
            Signature sig = CertificateVerify.getSignature(protocolVersion, algorithm);
            sig.initSign(privateKey, sr);
            CertificateVerify.updateSignature(sig, protocolVersion, handshakeHash, algorithm, masterSecret);
            this.signature = sig.sign();
        }

        CertificateVerify(HandshakeInStream input) throws IOException {
            this.signature = input.getBytes16();
        }

        boolean verify(ProtocolVersion protocolVersion, HandshakeHash handshakeHash, PublicKey publicKey, SecretKey masterSecret) throws GeneralSecurityException {
            String algorithm = publicKey.getAlgorithm();
            Signature sig = CertificateVerify.getSignature(protocolVersion, algorithm);
            sig.initVerify(publicKey);
            CertificateVerify.updateSignature(sig, protocolVersion, handshakeHash, algorithm, masterSecret);
            return sig.verify(this.signature);
        }

        private static Signature getSignature(ProtocolVersion protocolVersion, String algorithm) throws GeneralSecurityException {
            if (algorithm.equals("RSA")) {
                return RSASignature.getInternalInstance();
            }
            if (algorithm.equals("DSA")) {
                return JsseJce.getSignature("RawDSA");
            }
            if (algorithm.equals("EC")) {
                return JsseJce.getSignature("NONEwithECDSA");
            }
            throw new SignatureException("Unrecognized algorithm: " + algorithm);
        }

        private static void updateSignature(Signature sig, ProtocolVersion protocolVersion, HandshakeHash handshakeHash, String algorithm, SecretKey masterKey) throws SignatureException {
            boolean tls;
            MessageDigest md5Clone = handshakeHash.getMD5Clone();
            MessageDigest shaClone = handshakeHash.getSHAClone();
            boolean bl = tls = protocolVersion.v >= ProtocolVersion.TLS10.v;
            if (algorithm.equals("RSA")) {
                if (!tls) {
                    CertificateVerify.updateDigest(md5Clone, MD5_pad1, MD5_pad2, masterKey);
                    CertificateVerify.updateDigest(shaClone, SHA_pad1, SHA_pad2, masterKey);
                }
                RSASignature.setHashes(sig, md5Clone, shaClone);
            } else {
                if (!tls) {
                    CertificateVerify.updateDigest(shaClone, SHA_pad1, SHA_pad2, masterKey);
                }
                sig.update(shaClone.digest());
            }
        }

        static void updateDigest(MessageDigest md, byte[] pad1, byte[] pad2, SecretKey masterSecret) {
            byte[] keyBytes;
            byte[] byArray = keyBytes = "RAW".equals(masterSecret.getFormat()) ? masterSecret.getEncoded() : null;
            if (keyBytes != null) {
                md.update(keyBytes);
            } else {
                CertificateVerify.digestKey(md, masterSecret);
            }
            md.update(pad1);
            byte[] temp = md.digest();
            if (keyBytes != null) {
                md.update(keyBytes);
            } else {
                CertificateVerify.digestKey(md, masterSecret);
            }
            md.update(pad2);
            md.update(temp);
        }

        private static void makeAccessible(final AccessibleObject o) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    o.setAccessible(true);
                    return null;
                }
            });
        }

        private static void digestKey(MessageDigest md, SecretKey key) {
            try {
                if (md.getClass() != delegate) {
                    throw new Exception("Digest is not a MessageDigestSpi");
                }
                MessageDigestSpi spi = (MessageDigestSpi)spiField.get(md);
                Class<?> clazz = spi.getClass();
                Object r = methodCache.get(clazz);
                if (r == null) {
                    try {
                        r = clazz.getDeclaredMethod("implUpdate", SecretKey.class);
                        CertificateVerify.makeAccessible((Method)r);
                    }
                    catch (NoSuchMethodException e) {
                        r = NULL_OBJECT;
                    }
                    methodCache.put(clazz, r);
                }
                if (r == NULL_OBJECT) {
                    throw new Exception("Digest does not support implUpdate(SecretKey)");
                }
                Method update = (Method)r;
                update.invoke((Object)spi, key);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not obtain encoded key and MessageDigest cannot digest key", e);
            }
        }

        int messageLength() {
            return 2 + this.signature.length;
        }

        void send(HandshakeOutStream s) throws IOException {
            s.putBytes16(this.signature);
        }

        void print(PrintStream s) throws IOException {
            s.println("*** CertificateVerify");
        }

        static {
            try {
                delegate = Class.forName("java.security.MessageDigest$Delegate");
                spiField = delegate.getDeclaredField("digestSpi");
            }
            catch (Exception e) {
                throw new RuntimeException("Reflection failed", e);
            }
            CertificateVerify.makeAccessible(spiField);
            NULL_OBJECT = new Object();
            methodCache = new ConcurrentHashMap<Class, Object>();
        }
    }

    static final class ServerHelloDone
    extends HandshakeMessage {
        int messageType() {
            return 14;
        }

        ServerHelloDone() {
        }

        ServerHelloDone(HandshakeInStream input) {
        }

        int messageLength() {
            return 0;
        }

        void send(HandshakeOutStream s) throws IOException {
        }

        void print(PrintStream s) throws IOException {
            s.println("*** ServerHelloDone");
        }
    }

    static final class CertificateRequest
    extends HandshakeMessage {
        static final int cct_rsa_sign = 1;
        static final int cct_dss_sign = 2;
        static final int cct_rsa_fixed_dh = 3;
        static final int cct_dss_fixed_dh = 4;
        static final int cct_rsa_ephemeral_dh = 5;
        static final int cct_dss_ephemeral_dh = 6;
        static final int cct_ecdsa_sign = 64;
        static final int cct_rsa_fixed_ecdh = 65;
        static final int cct_ecdsa_fixed_ecdh = 66;
        private static final byte[] TYPES_NO_ECC = new byte[]{1, 2};
        private static final byte[] TYPES_ECC = new byte[]{1, 2, 64};
        byte[] types;
        DistinguishedName[] authorities;

        int messageType() {
            return 13;
        }

        CertificateRequest(X509Certificate[] ca, CipherSuite.KeyExchange keyExchange) throws IOException {
            this.authorities = new DistinguishedName[ca.length];
            for (int i = 0; i < ca.length; ++i) {
                X500Principal x500Principal = ca[i].getSubjectX500Principal();
                this.authorities[i] = new DistinguishedName(x500Principal);
            }
            this.types = JsseJce.isEcAvailable() ? TYPES_ECC : TYPES_NO_ECC;
        }

        CertificateRequest(HandshakeInStream input) throws IOException {
            int len;
            DistinguishedName dn;
            this.types = input.getBytes8();
            ArrayList<DistinguishedName> v = new ArrayList<DistinguishedName>();
            for (len = input.getInt16(); len >= 3; len -= dn.length()) {
                dn = new DistinguishedName(input);
                v.add(dn);
            }
            if (len != 0) {
                throw new SSLProtocolException("Bad CertificateRequest DN length");
            }
            this.authorities = v.toArray(new DistinguishedName[v.size()]);
        }

        X500Principal[] getAuthorities() throws IOException {
            X500Principal[] ret = new X500Principal[this.authorities.length];
            for (int i = 0; i < this.authorities.length; ++i) {
                ret[i] = this.authorities[i].getX500Principal();
            }
            return ret;
        }

        int messageLength() {
            int len = 1 + this.types.length + 2;
            for (int i = 0; i < this.authorities.length; ++i) {
                len += this.authorities[i].length();
            }
            return len;
        }

        void send(HandshakeOutStream output) throws IOException {
            int i;
            int len = 0;
            for (i = 0; i < this.authorities.length; ++i) {
                len += this.authorities[i].length();
            }
            output.putBytes8(this.types);
            output.putInt16(len);
            for (i = 0; i < this.authorities.length; ++i) {
                this.authorities[i].send(output);
            }
        }

        void print(PrintStream s) throws IOException {
            s.println("*** CertificateRequest");
            if (debug != null && Debug.isOn("verbose")) {
                int i;
                s.print("Cert Types: ");
                for (i = 0; i < this.types.length; ++i) {
                    switch (this.types[i]) {
                        case 1: {
                            s.print("RSA");
                            break;
                        }
                        case 2: {
                            s.print("DSS");
                            break;
                        }
                        case 3: {
                            s.print("Fixed DH (RSA sig)");
                            break;
                        }
                        case 4: {
                            s.print("Fixed DH (DSS sig)");
                            break;
                        }
                        case 5: {
                            s.print("Ephemeral DH (RSA sig)");
                            break;
                        }
                        case 6: {
                            s.print("Ephemeral DH (DSS sig)");
                            break;
                        }
                        case 64: {
                            s.print("ECDSA");
                            break;
                        }
                        case 65: {
                            s.print("Fixed ECDH (RSA sig)");
                            break;
                        }
                        case 66: {
                            s.print("Fixed ECDH (ECDSA sig)");
                            break;
                        }
                        default: {
                            s.print("Type-" + (this.types[i] & 0xFF));
                        }
                    }
                    if (i == this.types.length - 1) continue;
                    s.print(", ");
                }
                s.println();
                s.println("Cert Authorities:");
                for (i = 0; i < this.authorities.length; ++i) {
                    this.authorities[i].print(s);
                }
            }
        }
    }

    static final class DistinguishedName {
        byte[] name;

        DistinguishedName(HandshakeInStream input) throws IOException {
            this.name = input.getBytes16();
        }

        DistinguishedName(X500Principal dn) {
            this.name = dn.getEncoded();
        }

        X500Principal getX500Principal() throws IOException {
            try {
                return new X500Principal(this.name);
            }
            catch (IllegalArgumentException e) {
                throw (SSLProtocolException)new SSLProtocolException(e.getMessage()).initCause(e);
            }
        }

        int length() {
            return 2 + this.name.length;
        }

        void send(HandshakeOutStream output) throws IOException {
            output.putBytes16(this.name);
        }

        void print(PrintStream output) throws IOException {
            X500Principal principal = new X500Principal(this.name);
            output.println("<" + principal.toString() + ">");
        }
    }

    static final class ECDH_ServerKeyExchange
    extends ServerKeyExchange {
        private static final int CURVE_EXPLICIT_PRIME = 1;
        private static final int CURVE_EXPLICIT_CHAR2 = 2;
        private static final int CURVE_NAMED_CURVE = 3;
        private int curveId;
        private byte[] pointBytes;
        private byte[] signatureBytes;
        private ECPublicKey publicKey;

        ECDH_ServerKeyExchange(ECDHCrypt obj, PrivateKey privateKey, byte[] clntNonce, byte[] svrNonce, SecureRandom sr) throws GeneralSecurityException {
            this.publicKey = (ECPublicKey)obj.getPublicKey();
            ECParameterSpec params = this.publicKey.getParams();
            ECPoint point = this.publicKey.getW();
            this.pointBytes = JsseJce.encodePoint(point, params.getCurve());
            this.curveId = SupportedEllipticCurvesExtension.getCurveIndex(params);
            if (privateKey == null) {
                return;
            }
            Signature sig = ECDH_ServerKeyExchange.getSignature(privateKey.getAlgorithm());
            sig.initSign(privateKey);
            this.updateSignature(sig, clntNonce, svrNonce);
            this.signatureBytes = sig.sign();
        }

        ECDH_ServerKeyExchange(HandshakeInStream input, PublicKey signingKey, byte[] clntNonce, byte[] svrNonce) throws IOException, GeneralSecurityException {
            ECParameterSpec parameters;
            int curveType = input.getInt8();
            if (curveType == 3) {
                this.curveId = input.getInt16();
                if (!SupportedEllipticCurvesExtension.isSupported(this.curveId)) {
                    throw new SSLHandshakeException("Unsupported curveId: " + this.curveId);
                }
                String curveOid = SupportedEllipticCurvesExtension.getCurveOid(this.curveId);
                if (curveOid == null) {
                    throw new SSLHandshakeException("Unknown named curve: " + this.curveId);
                }
                parameters = JsseJce.getECParameterSpec(curveOid);
                if (parameters == null) {
                    throw new SSLHandshakeException("Unsupported curve: " + curveOid);
                }
            } else {
                throw new SSLHandshakeException("Unsupported ECCurveType: " + curveType);
            }
            this.pointBytes = input.getBytes8();
            ECPoint point = JsseJce.decodePoint(this.pointBytes, parameters.getCurve());
            KeyFactory factory = JsseJce.getKeyFactory("EC");
            this.publicKey = (ECPublicKey)factory.generatePublic(new ECPublicKeySpec(point, parameters));
            if (signingKey == null) {
                return;
            }
            this.signatureBytes = input.getBytes16();
            Signature sig = ECDH_ServerKeyExchange.getSignature(signingKey.getAlgorithm());
            sig.initVerify(signingKey);
            this.updateSignature(sig, clntNonce, svrNonce);
            if (!sig.verify(this.signatureBytes)) {
                throw new SSLKeyException("Invalid signature on ECDH server key exchange message");
            }
        }

        ECPublicKey getPublicKey() {
            return this.publicKey;
        }

        private static Signature getSignature(String keyAlgorithm) throws NoSuchAlgorithmException {
            if (keyAlgorithm.equals("EC")) {
                return JsseJce.getSignature("SHA1withECDSA");
            }
            if (keyAlgorithm.equals("RSA")) {
                return RSASignature.getInstance();
            }
            throw new NoSuchAlgorithmException("neither an RSA or a EC key");
        }

        private void updateSignature(Signature sig, byte[] clntNonce, byte[] svrNonce) throws SignatureException {
            sig.update(clntNonce);
            sig.update(svrNonce);
            sig.update((byte)3);
            sig.update((byte)(this.curveId >> 8));
            sig.update((byte)this.curveId);
            sig.update((byte)this.pointBytes.length);
            sig.update(this.pointBytes);
        }

        int messageLength() {
            int sigLen = this.signatureBytes == null ? 0 : 2 + this.signatureBytes.length;
            return 4 + this.pointBytes.length + sigLen;
        }

        void send(HandshakeOutStream s) throws IOException {
            s.putInt8(3);
            s.putInt16(this.curveId);
            s.putBytes8(this.pointBytes);
            if (this.signatureBytes != null) {
                s.putBytes16(this.signatureBytes);
            }
        }

        void print(PrintStream s) throws IOException {
            s.println("*** ECDH ServerKeyExchange");
            if (debug != null && Debug.isOn("verbose")) {
                s.println("Server key: " + this.publicKey);
            }
        }
    }

    static final class DH_ServerKeyExchange
    extends ServerKeyExchange {
        private static final boolean dhKeyExchangeFix = Debug.getBooleanProperty("com.sun.net.ssl.dhKeyExchangeFix", true);
        private byte[] dh_p;
        private byte[] dh_g;
        private byte[] dh_Ys;
        private byte[] signature;

        BigInteger getModulus() {
            return new BigInteger(1, this.dh_p);
        }

        BigInteger getBase() {
            return new BigInteger(1, this.dh_g);
        }

        BigInteger getServerPublicKey() {
            return new BigInteger(1, this.dh_Ys);
        }

        private void updateSignature(Signature sig, byte[] clntNonce, byte[] svrNonce) throws SignatureException {
            sig.update(clntNonce);
            sig.update(svrNonce);
            int tmp = this.dh_p.length;
            sig.update((byte)(tmp >> 8));
            sig.update((byte)(tmp & 0xFF));
            sig.update(this.dh_p);
            tmp = this.dh_g.length;
            sig.update((byte)(tmp >> 8));
            sig.update((byte)(tmp & 0xFF));
            sig.update(this.dh_g);
            tmp = this.dh_Ys.length;
            sig.update((byte)(tmp >> 8));
            sig.update((byte)(tmp & 0xFF));
            sig.update(this.dh_Ys);
        }

        DH_ServerKeyExchange(DHCrypt obj) {
            this.getValues(obj);
            this.signature = null;
        }

        DH_ServerKeyExchange(DHCrypt obj, PrivateKey key, byte[] clntNonce, byte[] svrNonce, SecureRandom sr) throws GeneralSecurityException {
            this.getValues(obj);
            Signature sig = key.getAlgorithm().equals("DSA") ? JsseJce.getSignature("DSA") : RSASignature.getInstance();
            sig.initSign(key, sr);
            this.updateSignature(sig, clntNonce, svrNonce);
            this.signature = sig.sign();
        }

        private void getValues(DHCrypt obj) {
            this.dh_p = DH_ServerKeyExchange.toByteArray(obj.getModulus());
            this.dh_g = DH_ServerKeyExchange.toByteArray(obj.getBase());
            this.dh_Ys = DH_ServerKeyExchange.toByteArray(obj.getPublicKey());
        }

        DH_ServerKeyExchange(HandshakeInStream input) throws IOException {
            this.dh_p = input.getBytes16();
            this.dh_g = input.getBytes16();
            this.dh_Ys = input.getBytes16();
            this.signature = null;
        }

        DH_ServerKeyExchange(HandshakeInStream input, PublicKey publicKey, byte[] clntNonce, byte[] svrNonce, int messageSize) throws IOException, GeneralSecurityException {
            Signature sig;
            byte[] signature;
            this.dh_p = input.getBytes16();
            this.dh_g = input.getBytes16();
            this.dh_Ys = input.getBytes16();
            if (dhKeyExchangeFix) {
                signature = input.getBytes16();
            } else {
                messageSize -= this.dh_p.length + 2;
                messageSize -= this.dh_g.length + 2;
                signature = new byte[messageSize -= this.dh_Ys.length + 2];
                input.read(signature);
            }
            String algorithm = publicKey.getAlgorithm();
            if (algorithm.equals("DSA")) {
                sig = JsseJce.getSignature("DSA");
            } else if (algorithm.equals("RSA")) {
                sig = RSASignature.getInstance();
            } else {
                throw new SSLKeyException("neither an RSA or a DSA key");
            }
            sig.initVerify(publicKey);
            this.updateSignature(sig, clntNonce, svrNonce);
            if (!sig.verify(signature)) {
                throw new SSLKeyException("Server D-H key verification failed");
            }
        }

        int messageLength() {
            int temp = 6;
            temp += this.dh_p.length;
            temp += this.dh_g.length;
            temp += this.dh_Ys.length;
            if (this.signature != null) {
                temp += this.signature.length;
                if (dhKeyExchangeFix) {
                    temp += 2;
                }
            }
            return temp;
        }

        void send(HandshakeOutStream s) throws IOException {
            s.putBytes16(this.dh_p);
            s.putBytes16(this.dh_g);
            s.putBytes16(this.dh_Ys);
            if (this.signature != null) {
                if (dhKeyExchangeFix) {
                    s.putBytes16(this.signature);
                } else {
                    s.write(this.signature);
                }
            }
        }

        void print(PrintStream s) throws IOException {
            s.println("*** Diffie-Hellman ServerKeyExchange");
            if (debug != null && Debug.isOn("verbose")) {
                Debug.println(s, "DH Modulus", this.dh_p);
                Debug.println(s, "DH Base", this.dh_g);
                Debug.println(s, "Server DH Public Key", this.dh_Ys);
                if (this.signature == null) {
                    s.println("Anonymous");
                } else {
                    s.println("Signed with a DSA or RSA public key");
                }
            }
        }
    }

    static final class RSA_ServerKeyExchange
    extends ServerKeyExchange {
        private byte[] rsa_modulus;
        private byte[] rsa_exponent;
        private Signature signature;
        private byte[] signatureBytes;

        private void updateSignature(byte[] clntNonce, byte[] svrNonce) throws SignatureException {
            this.signature.update(clntNonce);
            this.signature.update(svrNonce);
            int tmp = this.rsa_modulus.length;
            this.signature.update((byte)(tmp >> 8));
            this.signature.update((byte)(tmp & 0xFF));
            this.signature.update(this.rsa_modulus);
            tmp = this.rsa_exponent.length;
            this.signature.update((byte)(tmp >> 8));
            this.signature.update((byte)(tmp & 0xFF));
            this.signature.update(this.rsa_exponent);
        }

        RSA_ServerKeyExchange(PublicKey ephemeralKey, PrivateKey privateKey, RandomCookie clntNonce, RandomCookie svrNonce, SecureRandom sr) throws GeneralSecurityException {
            RSAPublicKeySpec rsaKey = JsseJce.getRSAPublicKeySpec(ephemeralKey);
            this.rsa_modulus = RSA_ServerKeyExchange.toByteArray(rsaKey.getModulus());
            this.rsa_exponent = RSA_ServerKeyExchange.toByteArray(rsaKey.getPublicExponent());
            this.signature = RSASignature.getInstance();
            this.signature.initSign(privateKey, sr);
            this.updateSignature(clntNonce.random_bytes, svrNonce.random_bytes);
            this.signatureBytes = this.signature.sign();
        }

        RSA_ServerKeyExchange(HandshakeInStream input) throws IOException, NoSuchAlgorithmException {
            this.signature = RSASignature.getInstance();
            this.rsa_modulus = input.getBytes16();
            this.rsa_exponent = input.getBytes16();
            this.signatureBytes = input.getBytes16();
        }

        PublicKey getPublicKey() {
            try {
                KeyFactory kfac = JsseJce.getKeyFactory("RSA");
                RSAPublicKeySpec kspec = new RSAPublicKeySpec(new BigInteger(1, this.rsa_modulus), new BigInteger(1, this.rsa_exponent));
                return kfac.generatePublic(kspec);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        boolean verify(PublicKey certifiedKey, RandomCookie clntNonce, RandomCookie svrNonce) throws GeneralSecurityException {
            this.signature.initVerify(certifiedKey);
            this.updateSignature(clntNonce.random_bytes, svrNonce.random_bytes);
            return this.signature.verify(this.signatureBytes);
        }

        int messageLength() {
            return 6 + this.rsa_modulus.length + this.rsa_exponent.length + this.signatureBytes.length;
        }

        void send(HandshakeOutStream s) throws IOException {
            s.putBytes16(this.rsa_modulus);
            s.putBytes16(this.rsa_exponent);
            s.putBytes16(this.signatureBytes);
        }

        void print(PrintStream s) throws IOException {
            s.println("*** RSA ServerKeyExchange");
            if (debug != null && Debug.isOn("verbose")) {
                Debug.println(s, "RSA Modulus", this.rsa_modulus);
                Debug.println(s, "RSA Public Exponent", this.rsa_exponent);
            }
        }
    }

    static abstract class ServerKeyExchange
    extends HandshakeMessage {
        ServerKeyExchange() {
        }

        int messageType() {
            return 12;
        }
    }

    static final class CertificateMsg
    extends HandshakeMessage {
        private X509Certificate[] chain;
        private List<byte[]> encodedChain;
        private int messageLength;

        int messageType() {
            return 11;
        }

        CertificateMsg(X509Certificate[] certs) {
            this.chain = certs;
        }

        CertificateMsg(HandshakeInStream input) throws IOException {
            int chainLen = input.getInt24();
            ArrayList<Certificate> v = new ArrayList<Certificate>(4);
            CertificateFactory cf = null;
            while (chainLen > 0) {
                byte[] cert = input.getBytes24();
                chainLen -= 3 + cert.length;
                try {
                    if (cf == null) {
                        cf = CertificateFactory.getInstance("X.509");
                    }
                    v.add(cf.generateCertificate(new ByteArrayInputStream(cert)));
                }
                catch (CertificateException e) {
                    throw (SSLProtocolException)new SSLProtocolException(e.getMessage()).initCause(e);
                }
            }
            this.chain = v.toArray(new X509Certificate[v.size()]);
        }

        int messageLength() {
            if (this.encodedChain == null) {
                this.messageLength = 3;
                this.encodedChain = new ArrayList<byte[]>(this.chain.length);
                try {
                    for (X509Certificate cert : this.chain) {
                        byte[] b = cert.getEncoded();
                        this.encodedChain.add(b);
                        this.messageLength += b.length + 3;
                    }
                }
                catch (CertificateEncodingException e) {
                    this.encodedChain = null;
                    throw new RuntimeException("Could not encode certificates", e);
                }
            }
            return this.messageLength;
        }

        void send(HandshakeOutStream s) throws IOException {
            s.putInt24(this.messageLength() - 3);
            for (byte[] b : this.encodedChain) {
                s.putBytes24(b);
            }
        }

        void print(PrintStream s) throws IOException {
            s.println("*** Certificate chain");
            if (debug != null && Debug.isOn("verbose")) {
                for (int i = 0; i < this.chain.length; ++i) {
                    s.println("chain [" + i + "] = " + this.chain[i]);
                }
                s.println("***");
            }
        }

        X509Certificate[] getCertificateChain() {
            return this.chain;
        }
    }

    static final class ServerHello
    extends HandshakeMessage {
        ProtocolVersion protocolVersion;
        RandomCookie svr_random;
        SessionId sessionId;
        CipherSuite cipherSuite;
        byte compression_method;
        HelloExtensions extensions = new HelloExtensions();

        int messageType() {
            return 2;
        }

        ServerHello() {
        }

        ServerHello(HandshakeInStream input, int messageLength) throws IOException {
            this.protocolVersion = ProtocolVersion.valueOf(input.getInt8(), input.getInt8());
            this.svr_random = new RandomCookie(input);
            this.sessionId = new SessionId(input.getBytes8());
            this.cipherSuite = CipherSuite.valueOf(input.getInt8(), input.getInt8());
            this.compression_method = (byte)input.getInt8();
            if (this.messageLength() != messageLength) {
                this.extensions = new HelloExtensions(input);
            }
        }

        int messageLength() {
            return 38 + this.sessionId.length() + this.extensions.length();
        }

        void send(HandshakeOutStream s) throws IOException {
            s.putInt8(this.protocolVersion.major);
            s.putInt8(this.protocolVersion.minor);
            this.svr_random.send(s);
            s.putBytes8(this.sessionId.getId());
            s.putInt8(this.cipherSuite.id >> 8);
            s.putInt8(this.cipherSuite.id & 0xFF);
            s.putInt8(this.compression_method);
            this.extensions.send(s);
        }

        void print(PrintStream s) throws IOException {
            s.println("*** ServerHello, " + this.protocolVersion);
            if (debug != null && Debug.isOn("verbose")) {
                s.print("RandomCookie:  ");
                this.svr_random.print(s);
                s.print("Session ID:  ");
                s.println(this.sessionId);
                s.println("Cipher Suite: " + this.cipherSuite);
                s.println("Compression Method: " + this.compression_method);
                this.extensions.print(s);
                s.println("***");
            }
        }
    }

    static final class ClientHello
    extends HandshakeMessage {
        ProtocolVersion protocolVersion;
        RandomCookie clnt_random;
        SessionId sessionId;
        private CipherSuiteList cipherSuites;
        byte[] compression_methods;
        HelloExtensions extensions = new HelloExtensions();
        private static final byte[] NULL_COMPRESSION = new byte[]{0};

        ClientHello(SecureRandom generator, ProtocolVersion protocolVersion, SessionId sessionId, CipherSuiteList cipherSuites) {
            this.protocolVersion = protocolVersion;
            this.sessionId = sessionId;
            this.cipherSuites = cipherSuites;
            if (cipherSuites.containsEC()) {
                this.extensions.add(SupportedEllipticCurvesExtension.DEFAULT);
                this.extensions.add(SupportedEllipticPointFormatsExtension.DEFAULT);
            }
            this.clnt_random = new RandomCookie(generator);
            this.compression_methods = NULL_COMPRESSION;
        }

        ClientHello(HandshakeInStream s, int messageLength) throws IOException {
            this.protocolVersion = ProtocolVersion.valueOf(s.getInt8(), s.getInt8());
            this.clnt_random = new RandomCookie(s);
            this.sessionId = new SessionId(s.getBytes8());
            this.cipherSuites = new CipherSuiteList(s);
            this.compression_methods = s.getBytes8();
            if (this.messageLength() != messageLength) {
                this.extensions = new HelloExtensions(s);
            }
        }

        CipherSuiteList getCipherSuites() {
            return this.cipherSuites;
        }

        void addRenegotiationInfoExtension(byte[] clientVerifyData) {
            RenegotiationInfoExtension renegotiationInfo = new RenegotiationInfoExtension(clientVerifyData, new byte[0]);
            this.extensions.add(renegotiationInfo);
        }

        int messageType() {
            return 1;
        }

        int messageLength() {
            return 38 + this.sessionId.length() + this.cipherSuites.size() * 2 + this.compression_methods.length + this.extensions.length();
        }

        void send(HandshakeOutStream s) throws IOException {
            s.putInt8(this.protocolVersion.major);
            s.putInt8(this.protocolVersion.minor);
            this.clnt_random.send(s);
            s.putBytes8(this.sessionId.getId());
            this.cipherSuites.send(s);
            s.putBytes8(this.compression_methods);
            this.extensions.send(s);
        }

        void print(PrintStream s) throws IOException {
            s.println("*** ClientHello, " + this.protocolVersion);
            if (debug != null && Debug.isOn("verbose")) {
                s.print("RandomCookie:  ");
                this.clnt_random.print(s);
                s.print("Session ID:  ");
                s.println(this.sessionId);
                s.println("Cipher Suites: " + this.cipherSuites);
                Debug.println(s, "Compression Methods", this.compression_methods);
                this.extensions.print(s);
                s.println("***");
            }
        }
    }

    static final class HelloRequest
    extends HandshakeMessage {
        int messageType() {
            return 0;
        }

        HelloRequest() {
        }

        HelloRequest(HandshakeInStream in) throws IOException {
        }

        int messageLength() {
            return 0;
        }

        void send(HandshakeOutStream out) throws IOException {
        }

        void print(PrintStream out) throws IOException {
            out.println("*** HelloRequest (empty)");
        }
    }
}

