/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;

final class MAC {
    static final MAC NULL = new MAC();
    private static final byte[] nullMAC = new byte[0];
    private final CipherSuite.MacAlg macAlg;
    private final int macSize;
    private final Mac mac;
    private final byte[] block;
    private static final int BLOCK_SIZE_SSL = 11;
    private static final int BLOCK_SIZE_TLS = 13;
    private static final int BLOCK_OFFSET_TYPE = 8;
    private static final int BLOCK_OFFSET_VERSION = 9;

    private MAC() {
        this.macSize = 0;
        this.macAlg = CipherSuite.M_NULL;
        this.mac = null;
        this.block = null;
    }

    MAC(CipherSuite.MacAlg macAlg, ProtocolVersion protocolVersion, SecretKey key) throws NoSuchAlgorithmException, InvalidKeyException {
        String algorithm;
        boolean tls;
        this.macAlg = macAlg;
        this.macSize = macAlg.size;
        boolean bl = tls = protocolVersion.v >= ProtocolVersion.TLS10.v;
        if (macAlg == CipherSuite.M_MD5) {
            algorithm = tls ? "HmacMD5" : "SslMacMD5";
        } else if (macAlg == CipherSuite.M_SHA) {
            algorithm = tls ? "HmacSHA1" : "SslMacSHA1";
        } else {
            throw new RuntimeException("Unknown Mac " + macAlg);
        }
        this.mac = JsseJce.getMac(algorithm);
        this.mac.init(key);
        if (tls) {
            this.block = new byte[13];
            this.block[9] = protocolVersion.major;
            this.block[10] = protocolVersion.minor;
        } else {
            this.block = new byte[11];
        }
    }

    int MAClen() {
        return this.macSize;
    }

    final byte[] compute(byte type, byte[] buf, int offset, int len) {
        return this.compute(type, null, buf, offset, len);
    }

    final byte[] compute(byte type, ByteBuffer bb) {
        return this.compute(type, bb, null, 0, bb.remaining());
    }

    private void incrementSequenceNumber() {
        int k = 7;
        while (k >= 0) {
            int n = k--;
            this.block[n] = (byte)(this.block[n] + 1);
            if (this.block[n] == 0) continue;
        }
    }

    private byte[] compute(byte type, ByteBuffer bb, byte[] buf, int offset, int len) {
        if (this.macSize == 0) {
            return nullMAC;
        }
        this.block[8] = type;
        this.block[this.block.length - 2] = (byte)(len >> 8);
        this.block[this.block.length - 1] = (byte)len;
        this.mac.update(this.block);
        this.incrementSequenceNumber();
        if (bb != null) {
            this.mac.update(bb);
        } else {
            this.mac.update(buf, offset, len);
        }
        return this.mac.doFinal();
    }
}

