/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.DefaultSSLContextImpl;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLServerSocketImpl;

public final class SSLServerSocketFactoryImpl
extends SSLServerSocketFactory {
    private static final int DEFAULT_BACKLOG = 50;
    private SSLContextImpl context;

    public SSLServerSocketFactoryImpl() throws Exception {
        this.context = DefaultSSLContextImpl.getDefaultImpl();
    }

    SSLServerSocketFactoryImpl(SSLContextImpl context) {
        this.context = context;
    }

    public ServerSocket createServerSocket() throws IOException {
        return new SSLServerSocketImpl(this.context);
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        return new SSLServerSocketImpl(port, 50, this.context);
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return new SSLServerSocketImpl(port, backlog, this.context);
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        return new SSLServerSocketImpl(port, backlog, ifAddress, this.context);
    }

    public String[] getDefaultCipherSuites() {
        CipherSuiteList.clearAvailableCache();
        return CipherSuiteList.getDefault().toStringArray();
    }

    public String[] getSupportedCipherSuites() {
        CipherSuiteList.clearAvailableCache();
        return CipherSuiteList.getSupported().toStringArray();
    }
}

