/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertPathParameters;
import java.security.cert.PKIXBuilderParameters;
import java.util.HashMap;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509TrustManager;
import sun.security.ssl.Debug;
import sun.security.ssl.X509TrustManagerImpl;

abstract class TrustManagerFactoryImpl
extends TrustManagerFactorySpi {
    private static final Debug debug = Debug.getInstance("ssl");
    private X509TrustManager trustManager = null;
    private boolean isInitialized = false;

    TrustManagerFactoryImpl() {
    }

    protected void engineInit(KeyStore ks) throws KeyStoreException {
        if (ks == null) {
            try {
                ks = TrustManagerFactoryImpl.getCacertsKeyStore("trustmanager");
            }
            catch (SecurityException se) {
                if (debug != null && Debug.isOn("trustmanager")) {
                    System.out.println("SunX509: skip default keystore: " + se);
                }
            }
            catch (Error err) {
                if (debug != null && Debug.isOn("trustmanager")) {
                    System.out.println("SunX509: skip default keystore: " + err);
                }
                throw err;
            }
            catch (RuntimeException re) {
                if (debug != null && Debug.isOn("trustmanager")) {
                    System.out.println("SunX509: skip default keystore: " + re);
                }
                throw re;
            }
            catch (Exception e) {
                if (debug != null && Debug.isOn("trustmanager")) {
                    System.out.println("SunX509: skip default keystore: " + e);
                }
                throw new KeyStoreException("problem accessing trust store" + e);
            }
        }
        this.trustManager = this.getInstance(ks);
        this.isInitialized = true;
    }

    abstract X509TrustManager getInstance(KeyStore var1) throws KeyStoreException;

    abstract X509TrustManager getInstance(ManagerFactoryParameters var1) throws InvalidAlgorithmParameterException;

    protected void engineInit(ManagerFactoryParameters spec) throws InvalidAlgorithmParameterException {
        this.trustManager = this.getInstance(spec);
        this.isInitialized = true;
    }

    protected TrustManager[] engineGetTrustManagers() {
        if (!this.isInitialized) {
            throw new IllegalStateException("TrustManagerFactoryImpl is not initialized");
        }
        return new TrustManager[]{this.trustManager};
    }

    private static FileInputStream getFileInputStream(final File file) throws Exception {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

            @Override
            public FileInputStream run() throws Exception {
                try {
                    if (file.exists()) {
                        return new FileInputStream(file);
                    }
                    return null;
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }
        });
    }

    static KeyStore getCacertsKeyStore(String dbgname) throws Exception {
        String storeFileName = null;
        File storeFile = null;
        FileInputStream fis = null;
        final HashMap props = new HashMap();
        String sep = File.separator;
        KeyStore ks = null;
        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                props.put("trustStore", System.getProperty("javax.net.ssl.trustStore"));
                props.put("javaHome", System.getProperty("java.home"));
                props.put("trustStoreType", System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType()));
                props.put("trustStoreProvider", System.getProperty("javax.net.ssl.trustStoreProvider", ""));
                props.put("trustStorePasswd", System.getProperty("javax.net.ssl.trustStorePassword", ""));
                return null;
            }
        });
        storeFileName = (String)props.get("trustStore");
        if (!"NONE".equals(storeFileName)) {
            if (storeFileName != null) {
                storeFile = new File(storeFileName);
                fis = TrustManagerFactoryImpl.getFileInputStream(storeFile);
            } else {
                String javaHome = (String)props.get("javaHome");
                storeFile = new File(javaHome + sep + "lib" + sep + "security" + sep + "jssecacerts");
                fis = TrustManagerFactoryImpl.getFileInputStream(storeFile);
                if (fis == null) {
                    storeFile = new File(javaHome + sep + "lib" + sep + "security" + sep + "cacerts");
                    fis = TrustManagerFactoryImpl.getFileInputStream(storeFile);
                }
            }
            storeFileName = fis != null ? storeFile.getPath() : "No File Available, using empty keystore.";
        }
        String defaultTrustStoreType = (String)props.get("trustStoreType");
        String defaultTrustStoreProvider = (String)props.get("trustStoreProvider");
        if (debug != null && Debug.isOn(dbgname)) {
            System.out.println("trustStore is: " + storeFileName);
            System.out.println("trustStore type is : " + defaultTrustStoreType);
            System.out.println("trustStore provider is : " + defaultTrustStoreProvider);
        }
        if (defaultTrustStoreType.length() != 0) {
            if (debug != null && Debug.isOn(dbgname)) {
                System.out.println("init truststore");
            }
            ks = defaultTrustStoreProvider.length() == 0 ? KeyStore.getInstance(defaultTrustStoreType) : KeyStore.getInstance(defaultTrustStoreType, defaultTrustStoreProvider);
            char[] passwd = null;
            String defaultTrustStorePassword = (String)props.get("trustStorePasswd");
            if (defaultTrustStorePassword.length() != 0) {
                passwd = defaultTrustStorePassword.toCharArray();
            }
            ks.load(fis, passwd);
            if (passwd != null) {
                for (int i = 0; i < passwd.length; ++i) {
                    passwd[i] = '\u0000';
                }
            }
        }
        if (fis != null) {
            fis.close();
        }
        return ks;
    }

    public static final class PKIXFactory
    extends TrustManagerFactoryImpl {
        X509TrustManager getInstance(KeyStore ks) throws KeyStoreException {
            return new X509TrustManagerImpl("PKIX", ks);
        }

        X509TrustManager getInstance(ManagerFactoryParameters spec) throws InvalidAlgorithmParameterException {
            if (!(spec instanceof CertPathTrustManagerParameters)) {
                throw new InvalidAlgorithmParameterException("Parameters must be CertPathTrustManagerParameters");
            }
            CertPathParameters params = ((CertPathTrustManagerParameters)spec).getParameters();
            if (!(params instanceof PKIXBuilderParameters)) {
                throw new InvalidAlgorithmParameterException("Encapsulated parameters must be PKIXBuilderParameters");
            }
            PKIXBuilderParameters pkixParams = (PKIXBuilderParameters)params;
            return new X509TrustManagerImpl("PKIX", pkixParams);
        }
    }

    public static final class SimpleFactory
    extends TrustManagerFactoryImpl {
        X509TrustManager getInstance(KeyStore ks) throws KeyStoreException {
            return new X509TrustManagerImpl("Simple", ks);
        }

        X509TrustManager getInstance(ManagerFactoryParameters spec) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("SunX509 TrustManagerFactory does not use ManagerFactoryParameters");
        }
    }
}

