/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.resolver;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.IORFactories;
import com.sun.corba.se.spi.ior.IORTemplate;
import com.sun.corba.se.spi.ior.ObjectKey;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.ior.iiop.IIOPAddress;
import com.sun.corba.se.spi.ior.iiop.IIOPFactories;
import com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.resolver.Resolver;
import java.util.HashSet;
import java.util.Set;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.RemarshalException;

public class BootstrapResolverImpl
implements Resolver {
    private Delegate bootstrapDelegate;
    private ORBUtilSystemException wrapper;

    public BootstrapResolverImpl(ORB orb, String host, int port) {
        this.wrapper = ORBUtilSystemException.get(orb, "orb.resolver");
        byte[] initialKey = "INIT".getBytes();
        ObjectKey okey = orb.getObjectKeyFactory().create(initialKey);
        IIOPAddress addr = IIOPFactories.makeIIOPAddress(orb, host, port);
        IIOPProfileTemplate ptemp = IIOPFactories.makeIIOPProfileTemplate(orb, GIOPVersion.V1_0, addr);
        IORTemplate iortemp = IORFactories.makeIORTemplate(okey.getTemplate());
        iortemp.add(ptemp);
        IOR initialIOR = iortemp.makeIOR(orb, "", okey.getId());
        this.bootstrapDelegate = ORBUtility.makeClientDelegate(initialIOR);
    }

    private InputStream invoke(String operationName, String parameter) {
        boolean remarshal = true;
        InputStream inStream = null;
        while (remarshal) {
            Object objref = null;
            remarshal = false;
            OutputStream os = this.bootstrapDelegate.request(objref, operationName, true);
            if (parameter != null) {
                os.write_string(parameter);
            }
            try {
                inStream = this.bootstrapDelegate.invoke(objref, os);
            }
            catch (ApplicationException e) {
                throw this.wrapper.bootstrapApplicationException(e);
            }
            catch (RemarshalException e) {
                remarshal = true;
            }
        }
        return inStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object resolve(String identifier) {
        InputStream inStream = null;
        Object result = null;
        try {
            inStream = this.invoke("get", identifier);
            result = inStream.read_Object();
        }
        finally {
            this.bootstrapDelegate.releaseReply(null, inStream);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set list() {
        InputStream inStream = null;
        HashSet<String> result = new HashSet<String>();
        try {
            inStream = this.invoke("list", null);
            int count = inStream.read_long();
            for (int i = 0; i < count; ++i) {
                result.add(inStream.read_string());
            }
        }
        finally {
            this.bootstrapDelegate.releaseReply(null, inStream);
        }
        return result;
    }
}

