/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.protocol.CorbaInvocationInfo;
import com.sun.corba.se.pept.transport.ContactInfo;
import com.sun.corba.se.pept.transport.ContactInfoList;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.transport.CorbaContactInfo;
import com.sun.corba.se.spi.transport.CorbaContactInfoList;
import com.sun.corba.se.spi.transport.CorbaContactInfoListIterator;
import com.sun.corba.se.spi.transport.IIOPPrimaryToContactInfo;
import java.util.Iterator;
import java.util.List;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;

public class CorbaContactInfoListIteratorImpl
implements CorbaContactInfoListIterator {
    protected ORB orb;
    protected CorbaContactInfoList contactInfoList;
    protected CorbaContactInfo successContactInfo;
    protected CorbaContactInfo failureContactInfo;
    protected RuntimeException failureException;
    protected Iterator effectiveTargetIORIterator;
    protected CorbaContactInfo previousContactInfo;
    protected boolean isAddrDispositionRetry;
    protected IIOPPrimaryToContactInfo primaryToContactInfo;
    protected ContactInfo primaryContactInfo;
    protected List listOfContactInfos;

    public CorbaContactInfoListIteratorImpl(ORB orb, CorbaContactInfoList corbaContactInfoList, ContactInfo primaryContactInfo, List listOfContactInfos) {
        this.orb = orb;
        this.contactInfoList = corbaContactInfoList;
        this.primaryContactInfo = primaryContactInfo;
        if (listOfContactInfos != null) {
            this.effectiveTargetIORIterator = listOfContactInfos.iterator();
        }
        this.listOfContactInfos = listOfContactInfos;
        this.previousContactInfo = null;
        this.isAddrDispositionRetry = false;
        this.successContactInfo = null;
        this.failureContactInfo = null;
        this.failureException = null;
        this.primaryToContactInfo = orb.getORBData().getIIOPPrimaryToContactInfo();
    }

    public boolean hasNext() {
        if (this.isAddrDispositionRetry) {
            return true;
        }
        boolean result = this.primaryToContactInfo != null ? this.primaryToContactInfo.hasNext(this.primaryContactInfo, this.previousContactInfo, this.listOfContactInfos) : this.effectiveTargetIORIterator.hasNext();
        return result;
    }

    public Object next() {
        if (this.isAddrDispositionRetry) {
            this.isAddrDispositionRetry = false;
            return this.previousContactInfo;
        }
        this.previousContactInfo = this.primaryToContactInfo != null ? (CorbaContactInfo)this.primaryToContactInfo.next(this.primaryContactInfo, this.previousContactInfo, this.listOfContactInfos) : (CorbaContactInfo)this.effectiveTargetIORIterator.next();
        return this.previousContactInfo;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public ContactInfoList getContactInfoList() {
        return this.contactInfoList;
    }

    public void reportSuccess(ContactInfo contactInfo) {
        this.successContactInfo = (CorbaContactInfo)contactInfo;
    }

    public boolean reportException(ContactInfo contactInfo, RuntimeException ex) {
        this.failureContactInfo = (CorbaContactInfo)contactInfo;
        this.failureException = ex;
        if (ex instanceof COMM_FAILURE) {
            SystemException se = (SystemException)ex;
            if (se.completed == CompletionStatus.COMPLETED_NO) {
                if (this.hasNext()) {
                    return true;
                }
                if (this.contactInfoList.getEffectiveTargetIOR() != this.contactInfoList.getTargetIOR()) {
                    this.updateEffectiveTargetIOR(this.contactInfoList.getTargetIOR());
                    return true;
                }
            }
        }
        return false;
    }

    public RuntimeException getFailureException() {
        if (this.failureException == null) {
            return ORBUtilSystemException.get(this.orb, "rpc.transport").invalidContactInfoListIteratorFailureException();
        }
        return this.failureException;
    }

    public void reportAddrDispositionRetry(CorbaContactInfo contactInfo, short disposition) {
        this.previousContactInfo.setAddressingDisposition(disposition);
        this.isAddrDispositionRetry = true;
    }

    public void reportRedirect(CorbaContactInfo contactInfo, IOR forwardedIOR) {
        this.updateEffectiveTargetIOR(forwardedIOR);
    }

    public void updateEffectiveTargetIOR(IOR newIOR) {
        this.contactInfoList.setEffectiveTargetIOR(newIOR);
        ((CorbaInvocationInfo)this.orb.getInvocationInfo()).setContactInfoListIterator(this.contactInfoList.iterator());
    }
}

