/*
 * Decompiled with CFR 0.152.
 */
package com.sun.image.codec.jpeg;

import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.io.InputStream;
import java.io.OutputStream;
import sun.awt.image.codec.JPEGImageDecoderImpl;
import sun.awt.image.codec.JPEGImageEncoderImpl;
import sun.awt.image.codec.JPEGParam;

public class JPEGCodec {
    private JPEGCodec() {
    }

    public static JPEGImageDecoder createJPEGDecoder(InputStream src) {
        return new JPEGImageDecoderImpl(src);
    }

    public static JPEGImageDecoder createJPEGDecoder(InputStream src, JPEGDecodeParam jdp) {
        return new JPEGImageDecoderImpl(src, jdp);
    }

    public static JPEGImageEncoder createJPEGEncoder(OutputStream os) {
        return new JPEGImageEncoderImpl(os);
    }

    public static JPEGImageEncoder createJPEGEncoder(OutputStream dest, JPEGEncodeParam jep) {
        return new JPEGImageEncoderImpl(dest, jep);
    }

    public static JPEGEncodeParam getDefaultJPEGEncodeParam(BufferedImage bi) {
        return JPEGCodec.getDefaultJPEGEncodeParam(bi.getRaster(), JPEGCodec.getDefaultColorID(bi.getColorModel()));
    }

    public static JPEGEncodeParam getDefaultJPEGEncodeParam(int numBands, int colorID) {
        return new JPEGParam(colorID, numBands);
    }

    public static JPEGEncodeParam getDefaultJPEGEncodeParam(JPEGDecodeParam jdp) {
        return new JPEGParam(jdp);
    }

    public static JPEGEncodeParam getDefaultJPEGEncodeParam(Raster ras, int colorID) {
        return JPEGCodec.getDefaultJPEGEncodeParam(ras.getNumBands(), colorID);
    }

    private static int getDefaultColorID(ColorModel cm) {
        ColorSpace cs = cm.getColorSpace();
        int type = cs.getType();
        int id = -1;
        switch (type) {
            case 6: {
                id = 1;
                break;
            }
            case 5: {
                id = cm.hasAlpha() ? 6 : 2;
            }
            case 3: {
                try {
                    if (cs == ColorSpace.getInstance(1002)) {
                        id = cm.hasAlpha() ? 10 : 5;
                    }
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                if (id != -1) break;
                id = cm.hasAlpha() ? 7 : 3;
                break;
            }
            case 9: {
                id = 4;
                break;
            }
            default: {
                id = 0;
            }
        }
        return id;
    }
}

