/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKEngine;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;

class GTKStyleFactory
extends SynthStyleFactory {
    private final Map<Object, GTKStyle> stylesCache = new HashMap<Object, GTKStyle>();
    private Font defaultFont;

    GTKStyleFactory() {
    }

    @Override
    public synchronized SynthStyle getStyle(JComponent c, Region id) {
        GTKStyle result;
        GTKEngine.WidgetType wt = GTKEngine.getWidgetType(c, id);
        Object key = null;
        if (id == Region.SCROLL_BAR) {
            if (c != null) {
                JScrollBar sb = (JScrollBar)c;
                boolean sp = sb.getParent() instanceof JScrollPane;
                boolean horiz = sb.getOrientation() == 0;
                boolean ltr = sb.getComponentOrientation().isLeftToRight();
                boolean focusable = sb.isFocusable();
                key = new ComplexKey(wt, sp, horiz, ltr, focusable);
            }
        } else if (id == Region.CHECK_BOX || id == Region.RADIO_BUTTON) {
            if (c != null) {
                boolean ltr = c.getComponentOrientation().isLeftToRight();
                key = new ComplexKey(wt, ltr);
            }
        } else if (id == Region.BUTTON && c != null) {
            JButton btn = (JButton)c;
            boolean toolButton = btn.getParent() instanceof JToolBar;
            boolean defaultCapable = btn.isDefaultCapable();
            key = new ComplexKey(wt, toolButton, defaultCapable);
        }
        if (key == null) {
            key = wt;
        }
        if ((result = this.stylesCache.get(key)) == null) {
            result = new GTKStyle(this.defaultFont, wt);
            this.stylesCache.put(key, result);
        }
        return result;
    }

    void initStyles(Font defaultFont) {
        this.defaultFont = defaultFont;
        this.stylesCache.clear();
    }

    private static class ComplexKey {
        private final GTKEngine.WidgetType wt;
        private final Object[] args;

        ComplexKey(GTKEngine.WidgetType wt, Object ... args) {
            this.wt = wt;
            this.args = args;
        }

        public int hashCode() {
            int hash = this.wt.hashCode();
            if (this.args != null) {
                for (Object arg : this.args) {
                    hash = hash * 29 + (arg == null ? 0 : arg.hashCode());
                }
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ComplexKey)) {
                return false;
            }
            ComplexKey that = (ComplexKey)o;
            if (this.wt == that.wt) {
                if (this.args == null && that.args == null) {
                    return true;
                }
                if (this.args != null && that.args != null && this.args.length == that.args.length) {
                    for (int i = 0; i < this.args.length; ++i) {
                        Object a1 = this.args[i];
                        Object a2 = that.args[i];
                        if (a1 != null ? a1.equals(a2) : a2 == null) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            String str = "ComplexKey[wt=" + (Object)((Object)this.wt);
            if (this.args != null) {
                str = str + ",args=[";
                for (int i = 0; i < this.args.length; ++i) {
                    str = str + this.args[i];
                    if (i >= this.args.length - 1) continue;
                    str = str + ",";
                }
                str = str + "]";
            }
            str = str + "]";
            return str;
        }
    }
}

