/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.plaf.motif.MotifGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class MotifInternalFrameTitlePane
extends BasicInternalFrameTitlePane
implements LayoutManager,
ActionListener,
PropertyChangeListener {
    SystemButton systemButton;
    MinimizeButton minimizeButton;
    MaximizeButton maximizeButton;
    JPopupMenu systemMenu;
    Title title;
    Color color;
    Color highlight;
    Color shadow;
    public static final int BUTTON_SIZE = 19;
    static Dimension buttonDimension = new Dimension(19, 19);

    public MotifInternalFrameTitlePane(JInternalFrame frame) {
        super(frame);
    }

    @Override
    protected void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont"));
        this.setPreferredSize(new Dimension(100, 19));
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return this;
    }

    @Override
    protected LayoutManager createLayout() {
        return this;
    }

    JPopupMenu getSystemMenu() {
        return this.systemMenu;
    }

    @Override
    protected void assembleSystemMenu() {
        this.systemMenu = new JPopupMenu();
        JMenuItem mi = this.systemMenu.add(new JMenuItem(this.restoreAction));
        mi.setMnemonic('R');
        mi = this.systemMenu.add(new JMenuItem(this.moveAction));
        mi.setMnemonic('M');
        mi = this.systemMenu.add(new JMenuItem(this.sizeAction));
        mi.setMnemonic('S');
        mi = this.systemMenu.add(new JMenuItem(this.iconifyAction));
        mi.setMnemonic('n');
        mi = this.systemMenu.add(new JMenuItem(this.maximizeAction));
        mi.setMnemonic('x');
        this.systemMenu.add(new JSeparator());
        mi = this.systemMenu.add(new JMenuItem(this.closeAction));
        mi.setMnemonic('C');
        this.systemButton = new SystemButton();
        this.systemButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MotifInternalFrameTitlePane.this.systemMenu.show(MotifInternalFrameTitlePane.this.systemButton, 0, 19);
            }
        });
        this.systemButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                try {
                    MotifInternalFrameTitlePane.this.frame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                if (evt.getClickCount() == 2) {
                    MotifInternalFrameTitlePane.this.closeAction.actionPerformed(new ActionEvent(evt.getSource(), 1001, null, evt.getWhen(), 0));
                    MotifInternalFrameTitlePane.this.systemMenu.setVisible(false);
                }
            }
        });
    }

    @Override
    protected void createButtons() {
        this.minimizeButton = new MinimizeButton();
        this.minimizeButton.addActionListener(this.iconifyAction);
        this.maximizeButton = new MaximizeButton();
        this.maximizeButton.addActionListener(this.maximizeAction);
    }

    @Override
    protected void addSubComponents() {
        this.title = new Title(this.frame.getTitle());
        this.title.setFont(this.getFont());
        this.add(this.systemButton);
        this.add(this.title);
        this.add(this.minimizeButton);
        this.add(this.maximizeButton);
    }

    @Override
    public void paintComponent(Graphics g) {
    }

    void setColors(Color c, Color h, Color s) {
        this.color = c;
        this.highlight = h;
        this.shadow = s;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        JInternalFrame f = (JInternalFrame)evt.getSource();
        boolean value = false;
        if ("selected".equals(prop)) {
            this.repaint();
        } else if (prop.equals("maximizable")) {
            if ((Boolean)evt.getNewValue() == Boolean.TRUE) {
                this.add(this.maximizeButton);
            } else {
                this.remove(this.maximizeButton);
            }
            this.revalidate();
            this.repaint();
        } else if (prop.equals("iconable")) {
            if ((Boolean)evt.getNewValue() == Boolean.TRUE) {
                this.add(this.minimizeButton);
            } else {
                this.remove(this.minimizeButton);
            }
            this.revalidate();
            this.repaint();
        } else if (prop.equals("title")) {
            this.repaint();
        }
        this.enableActions();
    }

    @Override
    public void addLayoutComponent(String name, Component c) {
    }

    @Override
    public void removeLayoutComponent(Component c) {
    }

    @Override
    public Dimension preferredLayoutSize(Container c) {
        return this.minimumLayoutSize(c);
    }

    @Override
    public Dimension minimumLayoutSize(Container c) {
        return new Dimension(100, 19);
    }

    @Override
    public void layoutContainer(Container c) {
        int w = this.getWidth();
        this.systemButton.setBounds(0, 0, 19, 19);
        int x = w - 19;
        if (this.frame.isMaximizable()) {
            this.maximizeButton.setBounds(x, 0, 19, 19);
            x -= 19;
        } else if (this.maximizeButton.getParent() != null) {
            this.maximizeButton.getParent().remove(this.maximizeButton);
        }
        if (this.frame.isIconifiable()) {
            this.minimizeButton.setBounds(x, 0, 19, 19);
            x -= 19;
        } else if (this.minimizeButton.getParent() != null) {
            this.minimizeButton.getParent().remove(this.minimizeButton);
        }
        this.title.setBounds(19, 0, x, 19);
    }

    @Override
    protected void showSystemMenu() {
        this.systemMenu.show(this.systemButton, 0, 19);
    }

    protected void hideSystemMenu() {
        this.systemMenu.setVisible(false);
    }

    private class Title
    extends FrameButton {
        Title(String title) {
            this.setText(title);
            this.setHorizontalAlignment(0);
            this.setBorder(BorderFactory.createBevelBorder(0, UIManager.getColor("activeCaptionBorder"), UIManager.getColor("inactiveCaptionBorder")));
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    Title.this.forwardEventToParent(e);
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    Title.this.forwardEventToParent(e);
                }
            });
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Title.this.forwardEventToParent(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    Title.this.forwardEventToParent(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    Title.this.forwardEventToParent(e);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    Title.this.forwardEventToParent(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    Title.this.forwardEventToParent(e);
                }
            });
        }

        void forwardEventToParent(MouseEvent e) {
            this.getParent().dispatchEvent(new MouseEvent(this.getParent(), e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), 0));
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (MotifInternalFrameTitlePane.this.frame.isSelected()) {
                g.setColor(UIManager.getColor("activeCaptionText"));
            } else {
                g.setColor(UIManager.getColor("inactiveCaptionText"));
            }
            Dimension d = this.getSize();
            String frameTitle = MotifInternalFrameTitlePane.this.frame.getTitle();
            if (frameTitle != null) {
                MotifGraphicsUtils.drawStringInRect(MotifInternalFrameTitlePane.this.frame, g, frameTitle, 0, 0, d.width, d.height, 0);
            }
        }
    }

    private class SystemButton
    extends FrameButton {
        private SystemButton() {
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(MotifInternalFrameTitlePane.this.highlight);
            g.drawLine(4, 8, 4, 11);
            g.drawLine(4, 8, 14, 8);
            g.setColor(MotifInternalFrameTitlePane.this.shadow);
            g.drawLine(5, 11, 14, 11);
            g.drawLine(14, 9, 14, 11);
        }
    }

    private class MaximizeButton
    extends FrameButton {
        private MaximizeButton() {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int max = 14;
            boolean isMaxed = MotifInternalFrameTitlePane.this.frame.isMaximum();
            g.setColor(isMaxed ? MotifInternalFrameTitlePane.this.shadow : MotifInternalFrameTitlePane.this.highlight);
            g.drawLine(4, 4, 4, max);
            g.drawLine(4, 4, max, 4);
            g.setColor(isMaxed ? MotifInternalFrameTitlePane.this.highlight : MotifInternalFrameTitlePane.this.shadow);
            g.drawLine(5, max, max, max);
            g.drawLine(max, 5, max, max);
        }
    }

    private class MinimizeButton
    extends FrameButton {
        private MinimizeButton() {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(MotifInternalFrameTitlePane.this.highlight);
            g.drawLine(7, 8, 7, 11);
            g.drawLine(7, 8, 10, 8);
            g.setColor(MotifInternalFrameTitlePane.this.shadow);
            g.drawLine(8, 11, 10, 11);
            g.drawLine(11, 9, 11, 11);
        }
    }

    private abstract class FrameButton
    extends JButton {
        FrameButton() {
            this.setFocusPainted(false);
            this.setBorderPainted(false);
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public Dimension getMinimumSize() {
            return buttonDimension;
        }

        @Override
        public Dimension getPreferredSize() {
            return buttonDimension;
        }

        @Override
        public void paintComponent(Graphics g) {
            Dimension d = this.getSize();
            int maxX = d.width - 1;
            int maxY = d.height - 1;
            g.setColor(MotifInternalFrameTitlePane.this.color);
            g.fillRect(1, 1, d.width, d.height);
            boolean pressed = this.getModel().isPressed();
            g.setColor(pressed ? MotifInternalFrameTitlePane.this.shadow : MotifInternalFrameTitlePane.this.highlight);
            g.drawLine(0, 0, maxX, 0);
            g.drawLine(0, 0, 0, maxY);
            g.setColor(pressed ? MotifInternalFrameTitlePane.this.highlight : MotifInternalFrameTitlePane.this.shadow);
            g.drawLine(1, maxY, maxX, maxY);
            g.drawLine(maxX, 1, maxX, maxY);
        }
    }
}

