/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.nimbus;

import java.awt.Color;
import javax.swing.UIManager;

class DerivedColor
extends Color {
    private final String uiDefaultParentName;
    private final float hOffset;
    private final float sOffset;
    private final float bOffset;
    private final int aOffset;
    private int argbValue;

    DerivedColor(String uiDefaultParentName, float hOffset, float sOffset, float bOffset, int aOffset) {
        super(0);
        this.uiDefaultParentName = uiDefaultParentName;
        this.hOffset = hOffset;
        this.sOffset = sOffset;
        this.bOffset = bOffset;
        this.aOffset = aOffset;
    }

    public String getUiDefaultParentName() {
        return this.uiDefaultParentName;
    }

    public float getHueOffset() {
        return this.hOffset;
    }

    public float getSaturationOffset() {
        return this.sOffset;
    }

    public float getBrightnessOffset() {
        return this.bOffset;
    }

    public int getAlphaOffset() {
        return this.aOffset;
    }

    public void rederiveColor() {
        Color src = UIManager.getColor(this.uiDefaultParentName);
        if (src != null) {
            float[] tmp = Color.RGBtoHSB(src.getRed(), src.getGreen(), src.getBlue(), null);
            tmp[0] = this.clamp(tmp[0] + this.hOffset);
            tmp[1] = this.clamp(tmp[1] + this.sOffset);
            tmp[2] = this.clamp(tmp[2] + this.bOffset);
            int alpha = this.clamp(src.getAlpha() + this.aOffset);
            this.argbValue = Color.HSBtoRGB(tmp[0], tmp[1], tmp[2]) & 0xFFFFFF | alpha << 24;
        } else {
            float[] tmp = new float[]{this.clamp(this.hOffset), this.clamp(this.sOffset), this.clamp(this.bOffset)};
            int alpha = this.clamp(this.aOffset);
            this.argbValue = Color.HSBtoRGB(tmp[0], tmp[1], tmp[2]) & 0xFFFFFF | alpha << 24;
        }
    }

    @Override
    public int getRGB() {
        return this.argbValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DerivedColor)) {
            return false;
        }
        DerivedColor that = (DerivedColor)o;
        if (this.aOffset != that.aOffset) {
            return false;
        }
        if (Float.compare(that.bOffset, this.bOffset) != 0) {
            return false;
        }
        if (Float.compare(that.hOffset, this.hOffset) != 0) {
            return false;
        }
        if (Float.compare(that.sOffset, this.sOffset) != 0) {
            return false;
        }
        return this.uiDefaultParentName.equals(that.uiDefaultParentName);
    }

    @Override
    public int hashCode() {
        int result = this.uiDefaultParentName.hashCode();
        result = (float)(31 * result) + this.hOffset != 0.0f ? Float.floatToIntBits(this.hOffset) : 0;
        result = (float)(31 * result) + this.sOffset != 0.0f ? Float.floatToIntBits(this.sOffset) : 0;
        result = (float)(31 * result) + this.bOffset != 0.0f ? Float.floatToIntBits(this.bOffset) : 0;
        result = 31 * result + this.aOffset;
        return result;
    }

    private float clamp(float value) {
        if (value < 0.0f) {
            value = 0.0f;
        } else if (value > 1.0f) {
            value = 1.0f;
        }
        return value;
    }

    private int clamp(int value) {
        if (value < 0) {
            value = 0;
        } else if (value > 255) {
            value = 255;
        }
        return value;
    }

    @Override
    public String toString() {
        Color src = UIManager.getColor(this.uiDefaultParentName);
        String s = "DerivedColor(color=" + this.getRed() + "," + this.getGreen() + "," + this.getBlue() + " parent=" + this.uiDefaultParentName + " offsets=" + this.getHueOffset() + "," + this.getSaturationOffset() + "," + this.getBrightnessOffset() + "," + this.getAlphaOffset();
        return src == null ? s : s + " pColor=" + src.getRed() + "," + src.getGreen() + "," + src.getBlue();
    }

    static class UIResource
    extends DerivedColor
    implements javax.swing.plaf.UIResource {
        UIResource(String uiDefaultParentName, float hOffset, float sOffset, float bOffset, int aOffset) {
            super(uiDefaultParentName, hOffset, sOffset, bOffset, aOffset);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof UIResource && super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 7;
        }
    }
}

