/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.DesktopProperty;
import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsIconFactory;
import com.sun.java.swing.plaf.windows.WindowsPopupMenuUI;
import com.sun.java.swing.plaf.windows.WindowsRootPaneUI;
import com.sun.java.swing.plaf.windows.WindowsTreeUI;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.security.AccessController;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.LayoutStyle;
import javax.swing.LookAndFeel;
import javax.swing.MenuSelectionManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import sun.awt.OSInfo;
import sun.awt.shell.ShellFolder;
import sun.font.FontManager;
import sun.security.action.GetPropertyAction;
import sun.swing.DefaultLayoutStyle;
import sun.swing.ImageIconUIResource;
import sun.swing.StringUIClientPropertyKey;
import sun.swing.SwingLazyValue;
import sun.swing.SwingUtilities2;

public class WindowsLookAndFeel
extends BasicLookAndFeel {
    static final Object HI_RES_DISABLED_ICON_CLIENT_KEY = new StringUIClientPropertyKey("WindowsLookAndFeel.generateHiResDisabledIcon");
    private Toolkit toolkit;
    private boolean updatePending = false;
    private boolean useSystemFontSettings = true;
    private boolean useSystemFontSizeSettings;
    private DesktopProperty themeActive;
    private DesktopProperty dllName;
    private DesktopProperty colorName;
    private DesktopProperty sizeName;
    private DesktopProperty aaSettings;
    private transient LayoutStyle style;
    private int baseUnitX;
    private int baseUnitY;
    private static boolean isMnemonicHidden = true;
    private static boolean isClassicWindows = false;

    public String getName() {
        return "Windows";
    }

    public String getDescription() {
        return "The Microsoft Windows Look and Feel";
    }

    public String getID() {
        return "Windows";
    }

    public boolean isNativeLookAndFeel() {
        return OSInfo.getOSType() == OSInfo.OSType.WINDOWS;
    }

    public boolean isSupportedLookAndFeel() {
        return this.isNativeLookAndFeel();
    }

    public void initialize() {
        super.initialize();
        this.toolkit = Toolkit.getDefaultToolkit();
        if (OSInfo.getWindowsVersion().compareTo(OSInfo.WINDOWS_95) <= 0) {
            isClassicWindows = true;
        } else {
            isClassicWindows = false;
            XPStyle.invalidateStyle();
        }
        String systemFonts = AccessController.doPrivileged(new GetPropertyAction("swing.useSystemFontSettings"));
        boolean bl = this.useSystemFontSettings = systemFonts == null || Boolean.valueOf(systemFonts) != false;
        if (this.useSystemFontSettings) {
            Object value = UIManager.get("Application.useSystemFontSettings");
            this.useSystemFontSettings = value == null || Boolean.TRUE.equals(value);
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(WindowsRootPaneUI.altProcessor);
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String windowsPackageName = "com.sun.java.swing.plaf.windows.";
        Object[] uiDefaults = new Object[]{"ButtonUI", "com.sun.java.swing.plaf.windows.WindowsButtonUI", "CheckBoxUI", "com.sun.java.swing.plaf.windows.WindowsCheckBoxUI", "CheckBoxMenuItemUI", "com.sun.java.swing.plaf.windows.WindowsCheckBoxMenuItemUI", "LabelUI", "com.sun.java.swing.plaf.windows.WindowsLabelUI", "RadioButtonUI", "com.sun.java.swing.plaf.windows.WindowsRadioButtonUI", "RadioButtonMenuItemUI", "com.sun.java.swing.plaf.windows.WindowsRadioButtonMenuItemUI", "ToggleButtonUI", "com.sun.java.swing.plaf.windows.WindowsToggleButtonUI", "ProgressBarUI", "com.sun.java.swing.plaf.windows.WindowsProgressBarUI", "SliderUI", "com.sun.java.swing.plaf.windows.WindowsSliderUI", "SeparatorUI", "com.sun.java.swing.plaf.windows.WindowsSeparatorUI", "SplitPaneUI", "com.sun.java.swing.plaf.windows.WindowsSplitPaneUI", "SpinnerUI", "com.sun.java.swing.plaf.windows.WindowsSpinnerUI", "TabbedPaneUI", "com.sun.java.swing.plaf.windows.WindowsTabbedPaneUI", "TextAreaUI", "com.sun.java.swing.plaf.windows.WindowsTextAreaUI", "TextFieldUI", "com.sun.java.swing.plaf.windows.WindowsTextFieldUI", "PasswordFieldUI", "com.sun.java.swing.plaf.windows.WindowsPasswordFieldUI", "TextPaneUI", "com.sun.java.swing.plaf.windows.WindowsTextPaneUI", "EditorPaneUI", "com.sun.java.swing.plaf.windows.WindowsEditorPaneUI", "TreeUI", "com.sun.java.swing.plaf.windows.WindowsTreeUI", "ToolBarUI", "com.sun.java.swing.plaf.windows.WindowsToolBarUI", "ToolBarSeparatorUI", "com.sun.java.swing.plaf.windows.WindowsToolBarSeparatorUI", "ComboBoxUI", "com.sun.java.swing.plaf.windows.WindowsComboBoxUI", "TableHeaderUI", "com.sun.java.swing.plaf.windows.WindowsTableHeaderUI", "InternalFrameUI", "com.sun.java.swing.plaf.windows.WindowsInternalFrameUI", "DesktopPaneUI", "com.sun.java.swing.plaf.windows.WindowsDesktopPaneUI", "DesktopIconUI", "com.sun.java.swing.plaf.windows.WindowsDesktopIconUI", "FileChooserUI", "com.sun.java.swing.plaf.windows.WindowsFileChooserUI", "MenuUI", "com.sun.java.swing.plaf.windows.WindowsMenuUI", "MenuItemUI", "com.sun.java.swing.plaf.windows.WindowsMenuItemUI", "MenuBarUI", "com.sun.java.swing.plaf.windows.WindowsMenuBarUI", "PopupMenuUI", "com.sun.java.swing.plaf.windows.WindowsPopupMenuUI", "PopupMenuSeparatorUI", "com.sun.java.swing.plaf.windows.WindowsPopupMenuSeparatorUI", "ScrollBarUI", "com.sun.java.swing.plaf.windows.WindowsScrollBarUI", "RootPaneUI", "com.sun.java.swing.plaf.windows.WindowsRootPaneUI"};
        table.putDefaults(uiDefaults);
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        String[] defaultSystemColors = new String[]{"desktop", "#005C5C", "activeCaption", "#000080", "activeCaptionText", "#FFFFFF", "activeCaptionBorder", "#C0C0C0", "inactiveCaption", "#808080", "inactiveCaptionText", "#C0C0C0", "inactiveCaptionBorder", "#C0C0C0", "window", "#FFFFFF", "windowBorder", "#000000", "windowText", "#000000", "menu", "#C0C0C0", "menuPressedItemB", "#000080", "menuPressedItemF", "#FFFFFF", "menuText", "#000000", "text", "#C0C0C0", "textText", "#000000", "textHighlight", "#000080", "textHighlightText", "#FFFFFF", "textInactiveText", "#808080", "control", "#C0C0C0", "controlText", "#000000", "controlHighlight", "#C0C0C0", "controlLtHighlight", "#FFFFFF", "controlShadow", "#808080", "controlDkShadow", "#000000", "scrollbar", "#E0E0E0", "info", "#FFFFE1", "infoText", "#000000"};
        this.loadSystemColors(table, defaultSystemColors, this.isNativeLookAndFeel());
    }

    private void initResourceBundle(UIDefaults table) {
        table.addResourceBundle("com.sun.java.swing.plaf.windows.resources.windows");
    }

    protected void initComponentDefaults(UIDefaults table) {
        ColorUIResource darkGray;
        super.initComponentDefaults(table);
        this.initResourceBundle(table);
        Integer twelve = new Integer(12);
        Integer fontPlain = new Integer(0);
        Integer fontBold = new Integer(1);
        SwingLazyValue dialogPlain12 = new SwingLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"Dialog", fontPlain, twelve});
        SwingLazyValue sansSerifPlain12 = new SwingLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"SansSerif", fontPlain, twelve});
        SwingLazyValue monospacedPlain12 = new SwingLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"Monospaced", fontPlain, twelve});
        SwingLazyValue dialogBold12 = new SwingLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"Dialog", fontBold, twelve});
        ColorUIResource red = new ColorUIResource(Color.red);
        ColorUIResource black = new ColorUIResource(Color.black);
        ColorUIResource white = new ColorUIResource(Color.white);
        ColorUIResource gray = new ColorUIResource(Color.gray);
        ColorUIResource scrollBarTrackHighlight = darkGray = new ColorUIResource(Color.darkGray);
        isClassicWindows = OSInfo.getWindowsVersion().compareTo(OSInfo.WINDOWS_95) <= 0;
        Icon treeExpandedIcon = WindowsTreeUI.ExpandedIcon.createExpandedIcon();
        Icon treeCollapsedIcon = WindowsTreeUI.CollapsedIcon.createCollapsedIcon();
        UIDefaults.LazyInputMap fieldInputMap = new UIDefaults.LazyInputMap(new Object[]{"control C", "copy-to-clipboard", "control V", "paste-from-clipboard", "control X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "control A", "select-all", "control BACK_SLASH", "unselect", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-previous-word", "control RIGHT", "caret-next-word", "control shift LEFT", "selection-previous-word", "control shift RIGHT", "selection-next-word", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "control shift O", "toggle-componentOrientation"});
        UIDefaults.LazyInputMap passwordInputMap = new UIDefaults.LazyInputMap(new Object[]{"control C", "copy-to-clipboard", "control V", "paste-from-clipboard", "control X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "control A", "select-all", "control BACK_SLASH", "unselect", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-begin-line", "control RIGHT", "caret-end-line", "control shift LEFT", "selection-begin-line", "control shift RIGHT", "selection-end-line", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "control shift O", "toggle-componentOrientation"});
        UIDefaults.LazyInputMap multilineInputMap = new UIDefaults.LazyInputMap(new Object[]{"control C", "copy-to-clipboard", "control V", "paste-from-clipboard", "control X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-previous-word", "control RIGHT", "caret-next-word", "control shift LEFT", "selection-previous-word", "control shift RIGHT", "selection-next-word", "control A", "select-all", "control BACK_SLASH", "unselect", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "control HOME", "caret-begin", "control END", "caret-end", "control shift HOME", "selection-begin", "control shift END", "selection-end", "UP", "caret-up", "DOWN", "caret-down", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift DOWN", "selection-down", "ENTER", "insert-break", "TAB", "insert-tab", "control T", "next-link-action", "control shift T", "previous-link-action", "control SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
        String menuItemAcceleratorDelimiter = "+";
        DesktopProperty ControlBackgroundColor = new DesktopProperty("win.3d.backgroundColor", table.get("control"), this.toolkit);
        DesktopProperty ControlLightColor = new DesktopProperty("win.3d.lightColor", table.get("controlHighlight"), this.toolkit);
        DesktopProperty ControlHighlightColor = new DesktopProperty("win.3d.highlightColor", table.get("controlLtHighlight"), this.toolkit);
        DesktopProperty ControlShadowColor = new DesktopProperty("win.3d.shadowColor", table.get("controlShadow"), this.toolkit);
        DesktopProperty ControlDarkShadowColor = new DesktopProperty("win.3d.darkShadowColor", table.get("controlDkShadow"), this.toolkit);
        DesktopProperty ControlTextColor = new DesktopProperty("win.button.textColor", table.get("controlText"), this.toolkit);
        DesktopProperty MenuBackgroundColor = new DesktopProperty("win.menu.backgroundColor", table.get("menu"), this.toolkit);
        DesktopProperty MenuBarBackgroundColor = new DesktopProperty("win.menubar.backgroundColor", table.get("menu"), this.toolkit);
        DesktopProperty MenuTextColor = new DesktopProperty("win.menu.textColor", table.get("menuText"), this.toolkit);
        DesktopProperty SelectionBackgroundColor = new DesktopProperty("win.item.highlightColor", table.get("textHighlight"), this.toolkit);
        DesktopProperty SelectionTextColor = new DesktopProperty("win.item.highlightTextColor", table.get("textHighlightText"), this.toolkit);
        DesktopProperty WindowBackgroundColor = new DesktopProperty("win.frame.backgroundColor", table.get("window"), this.toolkit);
        DesktopProperty WindowTextColor = new DesktopProperty("win.frame.textColor", table.get("windowText"), this.toolkit);
        DesktopProperty WindowBorderWidth = new DesktopProperty("win.frame.sizingBorderWidth", new Integer(1), this.toolkit);
        DesktopProperty TitlePaneHeight = new DesktopProperty("win.frame.captionHeight", new Integer(18), this.toolkit);
        DesktopProperty TitleButtonWidth = new DesktopProperty("win.frame.captionButtonWidth", new Integer(16), this.toolkit);
        DesktopProperty TitleButtonHeight = new DesktopProperty("win.frame.captionButtonHeight", new Integer(16), this.toolkit);
        DesktopProperty InactiveTextColor = new DesktopProperty("win.text.grayedTextColor", table.get("textInactiveText"), this.toolkit);
        DesktopProperty ScrollbarBackgroundColor = new DesktopProperty("win.scrollbar.backgroundColor", table.get("scrollbar"), this.toolkit);
        XPColorValue TextBackground = new XPColorValue(TMSchema.Part.EP_EDIT, null, TMSchema.Prop.FILLCOLOR, WindowBackgroundColor);
        DesktopProperty ReadOnlyTextBackground = ControlBackgroundColor;
        DesktopProperty DisabledTextBackground = ControlBackgroundColor;
        Object MenuFont = dialogPlain12;
        Object FixedControlFont = monospacedPlain12;
        Object ControlFont = dialogPlain12;
        Object MessageFont = dialogPlain12;
        Object WindowFont = dialogBold12;
        Object ToolTipFont = sansSerifPlain12;
        Object IconFont = ControlFont;
        DesktopProperty scrollBarWidth = new DesktopProperty("win.scrollbar.width", new Integer(16), this.toolkit);
        DesktopProperty menuBarHeight = new DesktopProperty("win.menu.height", null, this.toolkit);
        DesktopProperty hotTrackingOn = new DesktopProperty("win.item.hotTrackingOn", true, this.toolkit);
        DesktopProperty showMnemonics = new DesktopProperty("win.menu.keyboardCuesOn", Boolean.TRUE, this.toolkit);
        if (this.useSystemFontSettings) {
            MenuFont = this.getDesktopFontValue("win.menu.font", MenuFont, this.toolkit);
            FixedControlFont = this.getDesktopFontValue("win.ansiFixed.font", FixedControlFont, this.toolkit);
            ControlFont = this.getDesktopFontValue("win.defaultGUI.font", ControlFont, this.toolkit);
            MessageFont = this.getDesktopFontValue("win.messagebox.font", MessageFont, this.toolkit);
            WindowFont = this.getDesktopFontValue("win.frame.captionFont", WindowFont, this.toolkit);
            IconFont = this.getDesktopFontValue("win.icon.font", IconFont, this.toolkit);
            ToolTipFont = this.getDesktopFontValue("win.tooltip.font", ToolTipFont, this.toolkit);
            SwingUtilities2.AATextInfo aaTextInfo = SwingUtilities2.AATextInfo.getAATextInfo(true);
            table.put(SwingUtilities2.AA_TEXT_PROPERTY_KEY, aaTextInfo);
            this.aaSettings = new FontDesktopProperty("awt.font.desktophints");
        }
        if (this.useSystemFontSizeSettings) {
            MenuFont = new WindowsFontSizeProperty("win.menu.font.height", this.toolkit, "Dialog", 0, 12);
            FixedControlFont = new WindowsFontSizeProperty("win.ansiFixed.font.height", this.toolkit, "Monospaced", 0, 12);
            ControlFont = new WindowsFontSizeProperty("win.defaultGUI.font.height", this.toolkit, "Dialog", 0, 12);
            MessageFont = new WindowsFontSizeProperty("win.messagebox.font.height", this.toolkit, "Dialog", 0, 12);
            WindowFont = new WindowsFontSizeProperty("win.frame.captionFont.height", this.toolkit, "Dialog", 1, 12);
            ToolTipFont = new WindowsFontSizeProperty("win.tooltip.font.height", this.toolkit, "SansSerif", 0, 12);
            IconFont = new WindowsFontSizeProperty("win.icon.font.height", this.toolkit, "Dialog", 0, 12);
        }
        if (!(this instanceof WindowsClassicLookAndFeel) && OSInfo.getOSType() == OSInfo.OSType.WINDOWS && OSInfo.getWindowsVersion().compareTo(OSInfo.WINDOWS_XP) >= 0 && AccessController.doPrivileged(new GetPropertyAction("swing.noxp")) == null) {
            this.themeActive = new TriggerDesktopProperty("win.xpstyle.themeActive");
            this.dllName = new TriggerDesktopProperty("win.xpstyle.dllName");
            this.colorName = new TriggerDesktopProperty("win.xpstyle.colorName");
            this.sizeName = new TriggerDesktopProperty("win.xpstyle.sizeName");
        }
        Object[] defaults = new Object[]{"AuditoryCues.playList", null, "Application.useSystemFontSettings", this.useSystemFontSettings, "TextField.focusInputMap", fieldInputMap, "PasswordField.focusInputMap", passwordInputMap, "TextArea.focusInputMap", multilineInputMap, "TextPane.focusInputMap", multilineInputMap, "EditorPane.focusInputMap", multilineInputMap, "Button.font", ControlFont, "Button.background", ControlBackgroundColor, "Button.foreground", ControlTextColor, "Button.shadow", ControlShadowColor, "Button.darkShadow", ControlDarkShadowColor, "Button.light", ControlLightColor, "Button.highlight", ControlHighlightColor, "Button.disabledForeground", InactiveTextColor, "Button.disabledShadow", ControlHighlightColor, "Button.focus", black, "Button.dashedRectGapX", new XPValue(new Integer(3), new Integer(5)), "Button.dashedRectGapY", new XPValue(new Integer(3), new Integer(4)), "Button.dashedRectGapWidth", new XPValue(new Integer(6), new Integer(10)), "Button.dashedRectGapHeight", new XPValue(new Integer(6), new Integer(8)), "Button.textShiftOffset", new XPValue(new Integer(0), new Integer(1)), "Button.showMnemonics", showMnemonics, "Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "CheckBox.font", ControlFont, "CheckBox.interiorBackground", WindowBackgroundColor, "CheckBox.background", ControlBackgroundColor, "CheckBox.foreground", WindowTextColor, "CheckBox.shadow", ControlShadowColor, "CheckBox.darkShadow", ControlDarkShadowColor, "CheckBox.light", ControlLightColor, "CheckBox.highlight", ControlHighlightColor, "CheckBox.focus", black, "CheckBox.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "CheckBox.totalInsets", new Insets(4, 4, 4, 4), "CheckBoxMenuItem.font", MenuFont, "CheckBoxMenuItem.background", MenuBackgroundColor, "CheckBoxMenuItem.foreground", MenuTextColor, "CheckBoxMenuItem.selectionForeground", SelectionTextColor, "CheckBoxMenuItem.selectionBackground", SelectionBackgroundColor, "CheckBoxMenuItem.acceleratorForeground", MenuTextColor, "CheckBoxMenuItem.acceleratorSelectionForeground", SelectionTextColor, "CheckBoxMenuItem.commandSound", "win.sound.menuCommand", "ComboBox.font", ControlFont, "ComboBox.background", WindowBackgroundColor, "ComboBox.foreground", WindowTextColor, "ComboBox.buttonBackground", ControlBackgroundColor, "ComboBox.buttonShadow", ControlShadowColor, "ComboBox.buttonDarkShadow", ControlDarkShadowColor, "ComboBox.buttonHighlight", ControlHighlightColor, "ComboBox.selectionBackground", SelectionBackgroundColor, "ComboBox.selectionForeground", SelectionTextColor, "ComboBox.editorBorder", new XPValue(new EmptyBorder(1, 2, 1, 1), new EmptyBorder(1, 4, 1, 4)), "ComboBox.disabledBackground", new XPColorValue(TMSchema.Part.CP_COMBOBOX, TMSchema.State.DISABLED, TMSchema.Prop.FILLCOLOR, DisabledTextBackground), "ComboBox.disabledForeground", new XPColorValue(TMSchema.Part.CP_COMBOBOX, TMSchema.State.DISABLED, TMSchema.Prop.TEXTCOLOR, InactiveTextColor), "ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "DOWN", "selectNext2", "KP_DOWN", "selectNext2", "UP", "selectPrevious2", "KP_UP", "selectPrevious2", "ENTER", "enterPressed", "F4", "togglePopup", "alt DOWN", "togglePopup", "alt KP_DOWN", "togglePopup", "alt UP", "togglePopup", "alt KP_UP", "togglePopup"}), "Desktop.background", new DesktopProperty("win.desktop.backgroundColor", table.get("desktop"), this.toolkit), "Desktop.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl F5", "restore", "ctrl F4", "close", "ctrl F7", "move", "ctrl F8", "resize", "RIGHT", "right", "KP_RIGHT", "right", "LEFT", "left", "KP_LEFT", "left", "UP", "up", "KP_UP", "up", "DOWN", "down", "KP_DOWN", "down", "ESCAPE", "escape", "ctrl F9", "minimize", "ctrl F10", "maximize", "ctrl F6", "selectNextFrame", "ctrl TAB", "selectNextFrame", "ctrl alt F6", "selectNextFrame", "shift ctrl alt F6", "selectPreviousFrame", "ctrl F12", "navigateNext", "shift ctrl F12", "navigatePrevious"}), "DesktopIcon.width", new Integer(160), "EditorPane.font", ControlFont, "EditorPane.background", WindowBackgroundColor, "EditorPane.foreground", WindowTextColor, "EditorPane.selectionBackground", SelectionBackgroundColor, "EditorPane.selectionForeground", SelectionTextColor, "EditorPane.caretForeground", WindowTextColor, "EditorPane.inactiveForeground", InactiveTextColor, "EditorPane.inactiveBackground", WindowBackgroundColor, "EditorPane.disabledBackground", DisabledTextBackground, "FileChooser.homeFolderIcon", new LazyWindowsIcon(null, "icons/HomeFolder.gif"), "FileChooser.listFont", IconFont, "FileChooser.listViewBackground", new XPColorValue(TMSchema.Part.LVP_LISTVIEW, null, TMSchema.Prop.FILLCOLOR, WindowBackgroundColor), "FileChooser.listViewBorder", new XPBorderValue(TMSchema.Part.LVP_LISTVIEW, (Object)new SwingLazyValue("javax.swing.plaf.BorderUIResource", "getLoweredBevelBorderUIResource")), "FileChooser.listViewIcon", new LazyWindowsIcon("fileChooserIcon ListView", "icons/ListView.gif"), "FileChooser.listViewWindowsStyle", Boolean.TRUE, "FileChooser.detailsViewIcon", new LazyWindowsIcon("fileChooserIcon DetailsView", "icons/DetailsView.gif"), "FileChooser.viewMenuIcon", new LazyWindowsIcon("fileChooserIcon ViewMenu", "icons/ListView.gif"), "FileChooser.upFolderIcon", new LazyWindowsIcon("fileChooserIcon UpFolder", "icons/UpFolder.gif"), "FileChooser.newFolderIcon", new LazyWindowsIcon("fileChooserIcon NewFolder", "icons/NewFolder.gif"), "FileChooser.useSystemExtensionHiding", Boolean.TRUE, "FileChooser.lookInLabelMnemonic", new Integer(73), "FileChooser.fileNameLabelMnemonic", new Integer(78), "FileChooser.filesOfTypeLabelMnemonic", new Integer(84), "FileChooser.usesSingleFilePane", Boolean.TRUE, "FileChooser.noPlacesBar", new DesktopProperty("win.comdlg.noPlacesBar", Boolean.FALSE, this.toolkit), "FileChooser.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection", "F2", "editFileName", "F5", "refresh", "BACK_SPACE", "Go Up", "ENTER", "approveSelection", "ctrl ENTER", "approveSelection"}), "FileView.directoryIcon", SwingUtilities2.makeIcon(this.getClass(), WindowsLookAndFeel.class, "icons/Directory.gif"), "FileView.fileIcon", SwingUtilities2.makeIcon(this.getClass(), WindowsLookAndFeel.class, "icons/File.gif"), "FileView.computerIcon", SwingUtilities2.makeIcon(this.getClass(), WindowsLookAndFeel.class, "icons/Computer.gif"), "FileView.hardDriveIcon", SwingUtilities2.makeIcon(this.getClass(), WindowsLookAndFeel.class, "icons/HardDrive.gif"), "FileView.floppyDriveIcon", SwingUtilities2.makeIcon(this.getClass(), WindowsLookAndFeel.class, "icons/FloppyDrive.gif"), "FormattedTextField.font", ControlFont, "InternalFrame.titleFont", WindowFont, "InternalFrame.titlePaneHeight", TitlePaneHeight, "InternalFrame.titleButtonWidth", TitleButtonWidth, "InternalFrame.titleButtonHeight", TitleButtonHeight, "InternalFrame.titleButtonToolTipsOn", hotTrackingOn, "InternalFrame.borderColor", ControlBackgroundColor, "InternalFrame.borderShadow", ControlShadowColor, "InternalFrame.borderDarkShadow", ControlDarkShadowColor, "InternalFrame.borderHighlight", ControlHighlightColor, "InternalFrame.borderLight", ControlLightColor, "InternalFrame.borderWidth", WindowBorderWidth, "InternalFrame.minimizeIconBackground", ControlBackgroundColor, "InternalFrame.resizeIconHighlight", ControlLightColor, "InternalFrame.resizeIconShadow", ControlShadowColor, "InternalFrame.activeBorderColor", new DesktopProperty("win.frame.activeBorderColor", table.get("windowBorder"), this.toolkit), "InternalFrame.inactiveBorderColor", new DesktopProperty("win.frame.inactiveBorderColor", table.get("windowBorder"), this.toolkit), "InternalFrame.activeTitleBackground", new DesktopProperty("win.frame.activeCaptionColor", table.get("activeCaption"), this.toolkit), "InternalFrame.activeTitleGradient", new DesktopProperty("win.frame.activeCaptionGradientColor", table.get("activeCaption"), this.toolkit), "InternalFrame.activeTitleForeground", new DesktopProperty("win.frame.captionTextColor", table.get("activeCaptionText"), this.toolkit), "InternalFrame.inactiveTitleBackground", new DesktopProperty("win.frame.inactiveCaptionColor", table.get("inactiveCaption"), this.toolkit), "InternalFrame.inactiveTitleGradient", new DesktopProperty("win.frame.inactiveCaptionGradientColor", table.get("inactiveCaption"), this.toolkit), "InternalFrame.inactiveTitleForeground", new DesktopProperty("win.frame.inactiveCaptionTextColor", table.get("inactiveCaptionText"), this.toolkit), "InternalFrame.maximizeIcon", WindowsIconFactory.createFrameMaximizeIcon(), "InternalFrame.minimizeIcon", WindowsIconFactory.createFrameMinimizeIcon(), "InternalFrame.iconifyIcon", WindowsIconFactory.createFrameIconifyIcon(), "InternalFrame.closeIcon", WindowsIconFactory.createFrameCloseIcon(), "InternalFrame.icon", new SwingLazyValue("com.sun.java.swing.plaf.windows.WindowsInternalFrameTitlePane$ScalableIconUIResource", (Object[])new Object[][]{{SwingUtilities2.makeIcon(this.getClass(), BasicLookAndFeel.class, "icons/JavaCup16.png"), SwingUtilities2.makeIcon(this.getClass(), WindowsLookAndFeel.class, "icons/JavaCup32.png")}}), "InternalFrame.closeSound", "win.sound.close", "InternalFrame.maximizeSound", "win.sound.maximize", "InternalFrame.minimizeSound", "win.sound.minimize", "InternalFrame.restoreDownSound", "win.sound.restoreDown", "InternalFrame.restoreUpSound", "win.sound.restoreUp", "InternalFrame.windowBindings", new Object[]{"shift ESCAPE", "showSystemMenu", "ctrl SPACE", "showSystemMenu", "ESCAPE", "hideSystemMenu"}, "Label.font", ControlFont, "Label.background", ControlBackgroundColor, "Label.foreground", WindowTextColor, "Label.disabledForeground", InactiveTextColor, "Label.disabledShadow", ControlHighlightColor, "List.font", ControlFont, "List.background", WindowBackgroundColor, "List.foreground", WindowTextColor, "List.selectionBackground", SelectionBackgroundColor, "List.selectionForeground", SelectionTextColor, "List.lockToPositionOnScroll", Boolean.TRUE, "List.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "control INSERT", "copy", "shift INSERT", "paste", "shift DELETE", "cut", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "ctrl shift UP", "selectPreviousRowExtendSelection", "ctrl shift KP_UP", "selectPreviousRowExtendSelection", "ctrl UP", "selectPreviousRowChangeLead", "ctrl KP_UP", "selectPreviousRowChangeLead", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "ctrl shift DOWN", "selectNextRowExtendSelection", "ctrl shift KP_DOWN", "selectNextRowExtendSelection", "ctrl DOWN", "selectNextRowChangeLead", "ctrl KP_DOWN", "selectNextRowChangeLead", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "ctrl shift LEFT", "selectPreviousColumnExtendSelection", "ctrl shift KP_LEFT", "selectPreviousColumnExtendSelection", "ctrl LEFT", "selectPreviousColumnChangeLead", "ctrl KP_LEFT", "selectPreviousColumnChangeLead", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl shift RIGHT", "selectNextColumnExtendSelection", "ctrl shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl RIGHT", "selectNextColumnChangeLead", "ctrl KP_RIGHT", "selectNextColumnChangeLead", "HOME", "selectFirstRow", "shift HOME", "selectFirstRowExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl HOME", "selectFirstRowChangeLead", "END", "selectLastRow", "shift END", "selectLastRowExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "ctrl END", "selectLastRowChangeLead", "PAGE_UP", "scrollUp", "shift PAGE_UP", "scrollUpExtendSelection", "ctrl shift PAGE_UP", "scrollUpExtendSelection", "ctrl PAGE_UP", "scrollUpChangeLead", "PAGE_DOWN", "scrollDown", "shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl PAGE_DOWN", "scrollDownChangeLead", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "SPACE", "addToSelection", "ctrl SPACE", "toggleAndAnchor", "shift SPACE", "extendTo", "ctrl shift SPACE", "moveSelectionTo"}), "PopupMenu.font", MenuFont, "PopupMenu.background", MenuBackgroundColor, "PopupMenu.foreground", MenuTextColor, "PopupMenu.popupSound", "win.sound.menuPopup", "PopupMenu.consumeEventOnClose", Boolean.TRUE, "Menu.font", MenuFont, "Menu.foreground", MenuTextColor, "Menu.background", MenuBackgroundColor, "Menu.useMenuBarBackgroundForTopLevel", Boolean.TRUE, "Menu.selectionForeground", SelectionTextColor, "Menu.selectionBackground", SelectionBackgroundColor, "Menu.acceleratorForeground", MenuTextColor, "Menu.acceleratorSelectionForeground", SelectionTextColor, "Menu.menuPopupOffsetX", new Integer(0), "Menu.menuPopupOffsetY", new Integer(0), "Menu.submenuPopupOffsetX", new Integer(-4), "Menu.submenuPopupOffsetY", new Integer(-3), "Menu.crossMenuMnemonic", Boolean.FALSE, "Menu.preserveTopLevelSelection", Boolean.TRUE, "MenuBar.font", MenuFont, "MenuBar.background", new XPValue(MenuBarBackgroundColor, MenuBackgroundColor), "MenuBar.foreground", MenuTextColor, "MenuBar.shadow", ControlShadowColor, "MenuBar.highlight", ControlHighlightColor, "MenuBar.height", menuBarHeight, "MenuBar.rolloverEnabled", hotTrackingOn, "MenuBar.windowBindings", new Object[]{"F10", "takeFocus"}, "MenuItem.font", MenuFont, "MenuItem.acceleratorFont", MenuFont, "MenuItem.foreground", MenuTextColor, "MenuItem.background", MenuBackgroundColor, "MenuItem.selectionForeground", SelectionTextColor, "MenuItem.selectionBackground", SelectionBackgroundColor, "MenuItem.disabledForeground", InactiveTextColor, "MenuItem.acceleratorForeground", MenuTextColor, "MenuItem.acceleratorSelectionForeground", SelectionTextColor, "MenuItem.acceleratorDelimiter", menuItemAcceleratorDelimiter, "MenuItem.commandSound", "win.sound.menuCommand", "MenuItem.disabledAreNavigable", Boolean.TRUE, "RadioButton.font", ControlFont, "RadioButton.interiorBackground", WindowBackgroundColor, "RadioButton.background", ControlBackgroundColor, "RadioButton.foreground", WindowTextColor, "RadioButton.shadow", ControlShadowColor, "RadioButton.darkShadow", ControlDarkShadowColor, "RadioButton.light", ControlLightColor, "RadioButton.highlight", ControlHighlightColor, "RadioButton.focus", black, "RadioButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "RadioButton.totalInsets", new Insets(4, 4, 4, 4), "RadioButtonMenuItem.font", MenuFont, "RadioButtonMenuItem.foreground", MenuTextColor, "RadioButtonMenuItem.background", MenuBackgroundColor, "RadioButtonMenuItem.selectionForeground", SelectionTextColor, "RadioButtonMenuItem.selectionBackground", SelectionBackgroundColor, "RadioButtonMenuItem.disabledForeground", InactiveTextColor, "RadioButtonMenuItem.acceleratorForeground", MenuTextColor, "RadioButtonMenuItem.acceleratorSelectionForeground", SelectionTextColor, "RadioButtonMenuItem.commandSound", "win.sound.menuCommand", "OptionPane.font", MessageFont, "OptionPane.messageFont", MessageFont, "OptionPane.buttonFont", MessageFont, "OptionPane.background", ControlBackgroundColor, "OptionPane.foreground", WindowTextColor, "OptionPane.buttonMinimumWidth", new XPDLUValue(50, 50, 3), "OptionPane.messageForeground", ControlTextColor, "OptionPane.errorIcon", new LazyWindowsIcon("optionPaneIcon Error", "icons/Error.gif"), "OptionPane.informationIcon", new LazyWindowsIcon("optionPaneIcon Information", "icons/Inform.gif"), "OptionPane.questionIcon", new LazyWindowsIcon("optionPaneIcon Question", "icons/Question.gif"), "OptionPane.warningIcon", new LazyWindowsIcon("optionPaneIcon Warning", "icons/Warn.gif"), "OptionPane.windowBindings", new Object[]{"ESCAPE", "close"}, "OptionPane.errorSound", "win.sound.hand", "OptionPane.informationSound", "win.sound.asterisk", "OptionPane.questionSound", "win.sound.question", "OptionPane.warningSound", "win.sound.exclamation", "FormattedTextField.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation", "ESCAPE", "reset-field-edit", "UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}), "FormattedTextField.inactiveBackground", ReadOnlyTextBackground, "FormattedTextField.disabledBackground", DisabledTextBackground, "Panel.font", ControlFont, "Panel.background", ControlBackgroundColor, "Panel.foreground", WindowTextColor, "PasswordField.font", ControlFont, "PasswordField.background", TextBackground, "PasswordField.foreground", WindowTextColor, "PasswordField.inactiveForeground", InactiveTextColor, "PasswordField.inactiveBackground", ReadOnlyTextBackground, "PasswordField.disabledBackground", DisabledTextBackground, "PasswordField.selectionBackground", SelectionBackgroundColor, "PasswordField.selectionForeground", SelectionTextColor, "PasswordField.caretForeground", WindowTextColor, "PasswordField.echoChar", new XPValue(new Character('\u25cf'), new Character('*')), "ProgressBar.font", ControlFont, "ProgressBar.foreground", SelectionBackgroundColor, "ProgressBar.background", ControlBackgroundColor, "ProgressBar.shadow", ControlShadowColor, "ProgressBar.highlight", ControlHighlightColor, "ProgressBar.selectionForeground", ControlBackgroundColor, "ProgressBar.selectionBackground", SelectionBackgroundColor, "ProgressBar.cellLength", new Integer(7), "ProgressBar.cellSpacing", new Integer(2), "ProgressBar.indeterminateInsets", new Insets(3, 3, 3, 3), "RootPane.defaultButtonWindowKeyBindings", new Object[]{"ENTER", "press", "released ENTER", "release", "ctrl ENTER", "press", "ctrl released ENTER", "release"}, "ScrollBar.background", ScrollbarBackgroundColor, "ScrollBar.foreground", ControlBackgroundColor, "ScrollBar.track", white, "ScrollBar.trackForeground", ScrollbarBackgroundColor, "ScrollBar.trackHighlight", black, "ScrollBar.trackHighlightForeground", scrollBarTrackHighlight, "ScrollBar.thumb", ControlBackgroundColor, "ScrollBar.thumbHighlight", ControlHighlightColor, "ScrollBar.thumbDarkShadow", ControlDarkShadowColor, "ScrollBar.thumbShadow", ControlShadowColor, "ScrollBar.width", scrollBarWidth, "ScrollBar.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "positiveUnitIncrement", "KP_DOWN", "positiveUnitIncrement", "PAGE_DOWN", "positiveBlockIncrement", "ctrl PAGE_DOWN", "positiveBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "negativeUnitIncrement", "KP_UP", "negativeUnitIncrement", "PAGE_UP", "negativeBlockIncrement", "ctrl PAGE_UP", "negativeBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}), "ScrollPane.font", ControlFont, "ScrollPane.background", ControlBackgroundColor, "ScrollPane.foreground", ControlTextColor, "ScrollPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "unitScrollRight", "KP_RIGHT", "unitScrollRight", "DOWN", "unitScrollDown", "KP_DOWN", "unitScrollDown", "LEFT", "unitScrollLeft", "KP_LEFT", "unitScrollLeft", "UP", "unitScrollUp", "KP_UP", "unitScrollUp", "PAGE_UP", "scrollUp", "PAGE_DOWN", "scrollDown", "ctrl PAGE_UP", "scrollLeft", "ctrl PAGE_DOWN", "scrollRight", "ctrl HOME", "scrollHome", "ctrl END", "scrollEnd"}), "Separator.background", ControlHighlightColor, "Separator.foreground", ControlShadowColor, "Slider.font", ControlFont, "Slider.foreground", ControlBackgroundColor, "Slider.background", ControlBackgroundColor, "Slider.highlight", ControlHighlightColor, "Slider.shadow", ControlShadowColor, "Slider.focus", ControlDarkShadowColor, "Slider.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "negativeUnitIncrement", "KP_DOWN", "negativeUnitIncrement", "PAGE_DOWN", "negativeBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "positiveUnitIncrement", "KP_UP", "positiveUnitIncrement", "PAGE_UP", "positiveBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}), "Spinner.font", ControlFont, "Spinner.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}), "SplitPane.background", ControlBackgroundColor, "SplitPane.highlight", ControlHighlightColor, "SplitPane.shadow", ControlShadowColor, "SplitPane.darkShadow", ControlDarkShadowColor, "SplitPane.dividerSize", new Integer(5), "SplitPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "negativeIncrement", "DOWN", "positiveIncrement", "LEFT", "negativeIncrement", "RIGHT", "positiveIncrement", "KP_UP", "negativeIncrement", "KP_DOWN", "positiveIncrement", "KP_LEFT", "negativeIncrement", "KP_RIGHT", "positiveIncrement", "HOME", "selectMin", "END", "selectMax", "F8", "startResize", "F6", "toggleFocus", "ctrl TAB", "focusOutForward", "ctrl shift TAB", "focusOutBackward"}), "TabbedPane.tabsOverlapBorder", new XPValue(Boolean.TRUE, Boolean.FALSE), "TabbedPane.tabInsets", new XPValue(new InsetsUIResource(1, 4, 1, 4), new InsetsUIResource(0, 4, 1, 4)), "TabbedPane.tabAreaInsets", new XPValue(new InsetsUIResource(3, 2, 2, 2), new InsetsUIResource(3, 2, 0, 2)), "TabbedPane.font", ControlFont, "TabbedPane.background", ControlBackgroundColor, "TabbedPane.foreground", ControlTextColor, "TabbedPane.highlight", ControlHighlightColor, "TabbedPane.light", ControlLightColor, "TabbedPane.shadow", ControlShadowColor, "TabbedPane.darkShadow", ControlDarkShadowColor, "TabbedPane.focus", ControlTextColor, "TabbedPane.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "navigateRight", "KP_RIGHT", "navigateRight", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "ctrl DOWN", "requestFocusForVisibleComponent", "ctrl KP_DOWN", "requestFocusForVisibleComponent"}), "TabbedPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl TAB", "navigateNext", "ctrl shift TAB", "navigatePrevious", "ctrl PAGE_DOWN", "navigatePageDown", "ctrl PAGE_UP", "navigatePageUp", "ctrl UP", "requestFocus", "ctrl KP_UP", "requestFocus"}), "Table.font", ControlFont, "Table.foreground", ControlTextColor, "Table.background", WindowBackgroundColor, "Table.highlight", ControlHighlightColor, "Table.light", ControlLightColor, "Table.shadow", ControlShadowColor, "Table.darkShadow", ControlDarkShadowColor, "Table.selectionForeground", SelectionTextColor, "Table.selectionBackground", SelectionBackgroundColor, "Table.gridColor", gray, "Table.focusCellBackground", WindowBackgroundColor, "Table.focusCellForeground", ControlTextColor, "Table.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "control INSERT", "copy", "shift INSERT", "paste", "shift DELETE", "cut", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl shift RIGHT", "selectNextColumnExtendSelection", "ctrl shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl RIGHT", "selectNextColumnChangeLead", "ctrl KP_RIGHT", "selectNextColumnChangeLead", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "ctrl shift LEFT", "selectPreviousColumnExtendSelection", "ctrl shift KP_LEFT", "selectPreviousColumnExtendSelection", "ctrl LEFT", "selectPreviousColumnChangeLead", "ctrl KP_LEFT", "selectPreviousColumnChangeLead", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "ctrl shift DOWN", "selectNextRowExtendSelection", "ctrl shift KP_DOWN", "selectNextRowExtendSelection", "ctrl DOWN", "selectNextRowChangeLead", "ctrl KP_DOWN", "selectNextRowChangeLead", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "ctrl shift UP", "selectPreviousRowExtendSelection", "ctrl shift KP_UP", "selectPreviousRowExtendSelection", "ctrl UP", "selectPreviousRowChangeLead", "ctrl KP_UP", "selectPreviousRowChangeLead", "HOME", "selectFirstColumn", "shift HOME", "selectFirstColumnExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl HOME", "selectFirstRow", "END", "selectLastColumn", "shift END", "selectLastColumnExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "ctrl END", "selectLastRow", "PAGE_UP", "scrollUpChangeSelection", "shift PAGE_UP", "scrollUpExtendSelection", "ctrl shift PAGE_UP", "scrollLeftExtendSelection", "ctrl PAGE_UP", "scrollLeftChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl shift PAGE_DOWN", "scrollRightExtendSelection", "ctrl PAGE_DOWN", "scrollRightChangeSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "ENTER", "selectNextRowCell", "shift ENTER", "selectPreviousRowCell", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "ESCAPE", "cancel", "F2", "startEditing", "SPACE", "addToSelection", "ctrl SPACE", "toggleAndAnchor", "shift SPACE", "extendTo", "ctrl shift SPACE", "moveSelectionTo", "F8", "focusHeader"}), "Table.sortIconHighlight", ControlShadowColor, "Table.sortIconLight", white, "TableHeader.font", ControlFont, "TableHeader.foreground", ControlTextColor, "TableHeader.background", ControlBackgroundColor, "TableHeader.focusCellBackground", new XPValue(XPValue.NULL_VALUE, WindowBackgroundColor), "TextArea.font", FixedControlFont, "TextArea.background", WindowBackgroundColor, "TextArea.foreground", WindowTextColor, "TextArea.inactiveForeground", InactiveTextColor, "TextArea.inactiveBackground", WindowBackgroundColor, "TextArea.disabledBackground", DisabledTextBackground, "TextArea.selectionBackground", SelectionBackgroundColor, "TextArea.selectionForeground", SelectionTextColor, "TextArea.caretForeground", WindowTextColor, "TextField.font", ControlFont, "TextField.background", TextBackground, "TextField.foreground", WindowTextColor, "TextField.shadow", ControlShadowColor, "TextField.darkShadow", ControlDarkShadowColor, "TextField.light", ControlLightColor, "TextField.highlight", ControlHighlightColor, "TextField.inactiveForeground", InactiveTextColor, "TextField.inactiveBackground", ReadOnlyTextBackground, "TextField.disabledBackground", DisabledTextBackground, "TextField.selectionBackground", SelectionBackgroundColor, "TextField.selectionForeground", SelectionTextColor, "TextField.caretForeground", WindowTextColor, "TextPane.font", ControlFont, "TextPane.background", WindowBackgroundColor, "TextPane.foreground", WindowTextColor, "TextPane.selectionBackground", SelectionBackgroundColor, "TextPane.selectionForeground", SelectionTextColor, "TextPane.inactiveBackground", WindowBackgroundColor, "TextPane.disabledBackground", DisabledTextBackground, "TextPane.caretForeground", WindowTextColor, "TitledBorder.font", ControlFont, "TitledBorder.titleColor", new XPColorValue(TMSchema.Part.BP_GROUPBOX, null, TMSchema.Prop.TEXTCOLOR, WindowTextColor), "ToggleButton.font", ControlFont, "ToggleButton.background", ControlBackgroundColor, "ToggleButton.foreground", ControlTextColor, "ToggleButton.shadow", ControlShadowColor, "ToggleButton.darkShadow", ControlDarkShadowColor, "ToggleButton.light", ControlLightColor, "ToggleButton.highlight", ControlHighlightColor, "ToggleButton.focus", ControlTextColor, "ToggleButton.textShiftOffset", new Integer(1), "ToggleButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "ToolBar.font", MenuFont, "ToolBar.background", ControlBackgroundColor, "ToolBar.foreground", ControlTextColor, "ToolBar.shadow", ControlShadowColor, "ToolBar.darkShadow", ControlDarkShadowColor, "ToolBar.light", ControlLightColor, "ToolBar.highlight", ControlHighlightColor, "ToolBar.dockingBackground", ControlBackgroundColor, "ToolBar.dockingForeground", red, "ToolBar.floatingBackground", ControlBackgroundColor, "ToolBar.floatingForeground", darkGray, "ToolBar.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "RIGHT", "navigateRight", "KP_RIGHT", "navigateRight"}), "ToolBar.separatorSize", null, "ToolTip.font", ToolTipFont, "ToolTip.background", new DesktopProperty("win.tooltip.backgroundColor", table.get("info"), this.toolkit), "ToolTip.foreground", new DesktopProperty("win.tooltip.textColor", table.get("infoText"), this.toolkit), "ToolTipManager.enableToolTipMode", "activeApplication", "Tree.selectionBorderColor", black, "Tree.drawDashedFocusIndicator", Boolean.TRUE, "Tree.lineTypeDashed", Boolean.TRUE, "Tree.font", ControlFont, "Tree.background", WindowBackgroundColor, "Tree.foreground", WindowTextColor, "Tree.hash", gray, "Tree.leftChildIndent", new Integer(8), "Tree.rightChildIndent", new Integer(11), "Tree.textForeground", WindowTextColor, "Tree.textBackground", WindowBackgroundColor, "Tree.selectionForeground", SelectionTextColor, "Tree.selectionBackground", SelectionBackgroundColor, "Tree.expandedIcon", treeExpandedIcon, "Tree.collapsedIcon", treeCollapsedIcon, "Tree.openIcon", new ActiveWindowsIcon("win.icon.shellIconBPP", "shell32Icon 5", (Icon)table.get("Tree.openIcon")), "Tree.closedIcon", new ActiveWindowsIcon("win.icon.shellIconBPP", "shell32Icon 4", (Icon)table.get("Tree.closedIcon")), "Tree.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ADD", "expand", "SUBTRACT", "collapse", "ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "control INSERT", "copy", "shift INSERT", "paste", "shift DELETE", "cut", "UP", "selectPrevious", "KP_UP", "selectPrevious", "shift UP", "selectPreviousExtendSelection", "shift KP_UP", "selectPreviousExtendSelection", "ctrl shift UP", "selectPreviousExtendSelection", "ctrl shift KP_UP", "selectPreviousExtendSelection", "ctrl UP", "selectPreviousChangeLead", "ctrl KP_UP", "selectPreviousChangeLead", "DOWN", "selectNext", "KP_DOWN", "selectNext", "shift DOWN", "selectNextExtendSelection", "shift KP_DOWN", "selectNextExtendSelection", "ctrl shift DOWN", "selectNextExtendSelection", "ctrl shift KP_DOWN", "selectNextExtendSelection", "ctrl DOWN", "selectNextChangeLead", "ctrl KP_DOWN", "selectNextChangeLead", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "LEFT", "selectParent", "KP_LEFT", "selectParent", "PAGE_UP", "scrollUpChangeSelection", "shift PAGE_UP", "scrollUpExtendSelection", "ctrl shift PAGE_UP", "scrollUpExtendSelection", "ctrl PAGE_UP", "scrollUpChangeLead", "PAGE_DOWN", "scrollDownChangeSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl PAGE_DOWN", "scrollDownChangeLead", "HOME", "selectFirst", "shift HOME", "selectFirstExtendSelection", "ctrl shift HOME", "selectFirstExtendSelection", "ctrl HOME", "selectFirstChangeLead", "END", "selectLast", "shift END", "selectLastExtendSelection", "ctrl shift END", "selectLastExtendSelection", "ctrl END", "selectLastChangeLead", "F2", "startEditing", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "ctrl LEFT", "scrollLeft", "ctrl KP_LEFT", "scrollLeft", "ctrl RIGHT", "scrollRight", "ctrl KP_RIGHT", "scrollRight", "SPACE", "addToSelection", "ctrl SPACE", "toggleAndAnchor", "shift SPACE", "extendTo", "ctrl shift SPACE", "moveSelectionTo"}), "Tree.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancel"}), "Viewport.font", ControlFont, "Viewport.background", ControlBackgroundColor, "Viewport.foreground", WindowTextColor};
        table.putDefaults(defaults);
        table.putDefaults(this.getLazyValueDefaults());
        this.initVistaComponentDefaults(table);
    }

    static boolean isOnVista() {
        return OSInfo.getOSType() == OSInfo.OSType.WINDOWS && OSInfo.getWindowsVersion().compareTo(OSInfo.WINDOWS_VISTA) >= 0;
    }

    private void initVistaComponentDefaults(UIDefaults table) {
        Object oldValue;
        String key;
        int i;
        Object oldValue2;
        String key2;
        int i2;
        if (!WindowsLookAndFeel.isOnVista()) {
            return;
        }
        String[] menuClasses = new String[]{"MenuItem", "Menu", "CheckBoxMenuItem", "RadioButtonMenuItem"};
        Object[] menuDefaults = new Object[menuClasses.length * 2];
        int j = 0;
        for (i2 = 0; i2 < menuClasses.length; ++i2) {
            key2 = menuClasses[i2] + ".opaque";
            oldValue2 = table.get(key2);
            menuDefaults[j++] = key2;
            menuDefaults[j++] = new XPValue(Boolean.FALSE, oldValue2);
        }
        table.putDefaults(menuDefaults);
        j = 0;
        for (i2 = 0; i2 < menuClasses.length; ++i2) {
            key2 = menuClasses[i2] + ".acceleratorSelectionForeground";
            oldValue2 = table.get(key2);
            menuDefaults[j++] = key2;
            menuDefaults[j++] = new XPValue(table.getColor(menuClasses[i2] + ".acceleratorForeground"), oldValue2);
        }
        table.putDefaults(menuDefaults);
        WindowsIconFactory.VistaMenuItemCheckIconFactory menuItemCheckIconFactory = WindowsIconFactory.getMenuItemCheckIconFactory();
        int j2 = 0;
        for (i = 0; i < menuClasses.length; ++i) {
            key = menuClasses[i] + ".checkIconFactory";
            oldValue = table.get(key);
            menuDefaults[j2++] = key;
            menuDefaults[j2++] = new XPValue(menuItemCheckIconFactory, oldValue);
        }
        table.putDefaults(menuDefaults);
        j2 = 0;
        for (i = 0; i < menuClasses.length; ++i) {
            key = menuClasses[i] + ".checkIcon";
            oldValue = table.get(key);
            menuDefaults[j2++] = key;
            menuDefaults[j2++] = new XPValue(menuItemCheckIconFactory.getIcon(menuClasses[i]), oldValue);
        }
        table.putDefaults(menuDefaults);
        j2 = 0;
        for (i = 0; i < menuClasses.length; ++i) {
            key = menuClasses[i] + ".evenHeight";
            oldValue = table.get(key);
            menuDefaults[j2++] = key;
            menuDefaults[j2++] = new XPValue(Boolean.TRUE, oldValue);
        }
        table.putDefaults(menuDefaults);
        InsetsUIResource insets = new InsetsUIResource(0, 0, 0, 0);
        int j3 = 0;
        for (int i3 = 0; i3 < menuClasses.length; ++i3) {
            String key3 = menuClasses[i3] + ".margin";
            Object oldValue3 = table.get(key3);
            menuDefaults[j3++] = key3;
            menuDefaults[j3++] = new XPValue(insets, oldValue3);
        }
        table.putDefaults(menuDefaults);
        Integer checkIconOffsetInteger = 0;
        int j4 = 0;
        for (int i4 = 0; i4 < menuClasses.length; ++i4) {
            String key4 = menuClasses[i4] + ".checkIconOffset";
            Object oldValue4 = table.get(key4);
            menuDefaults[j4++] = key4;
            menuDefaults[j4++] = new XPValue(checkIconOffsetInteger, oldValue4);
        }
        table.putDefaults(menuDefaults);
        Integer afterCheckIconGap = WindowsPopupMenuUI.getSpanBeforeGutter() + WindowsPopupMenuUI.getGutterWidth() + WindowsPopupMenuUI.getSpanAfterGutter();
        int j5 = 0;
        for (int i5 = 0; i5 < menuClasses.length; ++i5) {
            String key5 = menuClasses[i5] + ".afterCheckIconGap";
            Object oldValue5 = table.get(key5);
            menuDefaults[j5++] = key5;
            menuDefaults[j5++] = new XPValue(afterCheckIconGap, oldValue5);
        }
        table.putDefaults(menuDefaults);
        UIDefaults.ActiveValue minimumTextOffset = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return WindowsIconFactory.VistaMenuItemCheckIconFactory.getIconWidth() + WindowsPopupMenuUI.getSpanBeforeGutter() + WindowsPopupMenuUI.getGutterWidth() + WindowsPopupMenuUI.getSpanAfterGutter();
            }
        };
        int j6 = 0;
        for (int i6 = 0; i6 < menuClasses.length; ++i6) {
            String key6 = menuClasses[i6] + ".minimumTextOffset";
            Object oldValue6 = table.get(key6);
            menuDefaults[j6++] = key6;
            menuDefaults[j6++] = new XPValue(minimumTextOffset, oldValue6);
        }
        table.putDefaults(menuDefaults);
        String POPUP_MENU_BORDER = "PopupMenu.border";
        XPBorderValue popupMenuBorder = new XPBorderValue(TMSchema.Part.MENU, new SwingLazyValue("javax.swing.plaf.basic.BasicBorders", "getInternalFrameBorder"), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        table.put(POPUP_MENU_BORDER, popupMenuBorder);
        table.put("Table.ascendingSortIcon", new XPValue(new SkinIcon(TMSchema.Part.HP_HEADERSORTARROW, TMSchema.State.SORTEDDOWN), new SwingLazyValue("sun.swing.plaf.windows.ClassicSortArrowIcon", null, new Object[]{Boolean.TRUE})));
        table.put("Table.descendingSortIcon", new XPValue(new SkinIcon(TMSchema.Part.HP_HEADERSORTARROW, TMSchema.State.SORTEDUP), new SwingLazyValue("sun.swing.plaf.windows.ClassicSortArrowIcon", null, new Object[]{Boolean.FALSE})));
    }

    private Object getDesktopFontValue(String fontName, Object backup, Toolkit kit) {
        if (this.useSystemFontSettings) {
            return new WindowsFontProperty(fontName, backup, kit);
        }
        return null;
    }

    private Object[] getLazyValueDefaults() {
        XPBorderValue buttonBorder = new XPBorderValue(TMSchema.Part.BP_PUSHBUTTON, (Object)new SwingLazyValue("javax.swing.plaf.basic.BasicBorders", "getButtonBorder"));
        XPBorderValue textFieldBorder = new XPBorderValue(TMSchema.Part.EP_EDIT, (Object)new SwingLazyValue("javax.swing.plaf.basic.BasicBorders", "getTextFieldBorder"));
        XPValue textFieldMargin = new XPValue(new InsetsUIResource(2, 2, 2, 2), new InsetsUIResource(1, 1, 1, 1));
        XPBorderValue spinnerBorder = new XPBorderValue(TMSchema.Part.EP_EDIT, textFieldBorder, new EmptyBorder(2, 2, 2, 2));
        XPValue spinnerArrowInsets = new XPValue(new InsetsUIResource(1, 1, 1, 1), null);
        XPBorderValue comboBoxBorder = new XPBorderValue(TMSchema.Part.CP_COMBOBOX, (Object)textFieldBorder);
        SwingLazyValue focusCellHighlightBorder = new SwingLazyValue("com.sun.java.swing.plaf.windows.WindowsBorders", "getFocusCellHighlightBorder");
        SwingLazyValue etchedBorder = new SwingLazyValue("javax.swing.plaf.BorderUIResource", "getEtchedBorderUIResource");
        SwingLazyValue internalFrameBorder = new SwingLazyValue("com.sun.java.swing.plaf.windows.WindowsBorders", "getInternalFrameBorder");
        SwingLazyValue loweredBevelBorder = new SwingLazyValue("javax.swing.plaf.BorderUIResource", "getLoweredBevelBorderUIResource");
        SwingLazyValue marginBorder = new SwingLazyValue("javax.swing.plaf.basic.BasicBorders$MarginBorder");
        SwingLazyValue menuBarBorder = new SwingLazyValue("javax.swing.plaf.basic.BasicBorders", "getMenuBarBorder");
        XPBorderValue popupMenuBorder = new XPBorderValue(TMSchema.Part.MENU, (Object)new SwingLazyValue("javax.swing.plaf.basic.BasicBorders", "getInternalFrameBorder"));
        SwingLazyValue progressBarBorder = new SwingLazyValue("com.sun.java.swing.plaf.windows.WindowsBorders", "getProgressBarBorder");
        SwingLazyValue radioButtonBorder = new SwingLazyValue("javax.swing.plaf.basic.BasicBorders", "getRadioButtonBorder");
        XPBorderValue scrollPaneBorder = new XPBorderValue(TMSchema.Part.LBP_LISTBOX, (Object)textFieldBorder);
        XPBorderValue tableScrollPaneBorder = new XPBorderValue(TMSchema.Part.LBP_LISTBOX, (Object)loweredBevelBorder);
        SwingLazyValue tableHeaderBorder = new SwingLazyValue("com.sun.java.swing.plaf.windows.WindowsBorders", "getTableHeaderBorder");
        SwingLazyValue toolBarBorder = new SwingLazyValue("com.sun.java.swing.plaf.windows.WindowsBorders", "getToolBarBorder");
        SwingLazyValue toolTipBorder = new SwingLazyValue("javax.swing.plaf.BorderUIResource", "getBlackLineBorderUIResource");
        SwingLazyValue checkBoxIcon = new SwingLazyValue("com.sun.java.swing.plaf.windows.WindowsIconFactory", "getCheckBoxIcon");
        SwingLazyValue radioButtonIcon = new SwingLazyValue("com.sun.java.swing.plaf.windows.WindowsIconFactory", "getRadioButtonIcon");
        SwingLazyValue radioButtonMenuItemIcon = new SwingLazyValue("com.sun.java.swing.plaf.windows.WindowsIconFactory", "getRadioButtonMenuItemIcon");
        SwingLazyValue menuItemCheckIcon = new SwingLazyValue("com.sun.java.swing.plaf.windows.WindowsIconFactory", "getMenuItemCheckIcon");
        SwingLazyValue menuItemArrowIcon = new SwingLazyValue("com.sun.java.swing.plaf.windows.WindowsIconFactory", "getMenuItemArrowIcon");
        SwingLazyValue menuArrowIcon = new SwingLazyValue("com.sun.java.swing.plaf.windows.WindowsIconFactory", "getMenuArrowIcon");
        Object[] lazyDefaults = new Object[]{"Button.border", buttonBorder, "CheckBox.border", radioButtonBorder, "ComboBox.border", comboBoxBorder, "DesktopIcon.border", internalFrameBorder, "FormattedTextField.border", textFieldBorder, "FormattedTextField.margin", textFieldMargin, "InternalFrame.border", internalFrameBorder, "List.focusCellHighlightBorder", focusCellHighlightBorder, "Table.focusCellHighlightBorder", focusCellHighlightBorder, "Menu.border", marginBorder, "MenuBar.border", menuBarBorder, "MenuItem.border", marginBorder, "PasswordField.border", textFieldBorder, "PasswordField.margin", textFieldMargin, "PopupMenu.border", popupMenuBorder, "ProgressBar.border", progressBarBorder, "RadioButton.border", radioButtonBorder, "ScrollPane.border", scrollPaneBorder, "Spinner.border", spinnerBorder, "Spinner.arrowButtonInsets", spinnerArrowInsets, "Spinner.arrowButtonSize", new Dimension(17, 9), "Table.scrollPaneBorder", tableScrollPaneBorder, "TableHeader.cellBorder", tableHeaderBorder, "TextArea.margin", textFieldMargin, "TextField.border", textFieldBorder, "TextField.margin", textFieldMargin, "TitledBorder.border", new XPBorderValue(TMSchema.Part.BP_GROUPBOX, (Object)etchedBorder), "ToggleButton.border", radioButtonBorder, "ToolBar.border", toolBarBorder, "ToolTip.border", toolTipBorder, "CheckBox.icon", checkBoxIcon, "Menu.arrowIcon", menuArrowIcon, "MenuItem.checkIcon", menuItemCheckIcon, "MenuItem.arrowIcon", menuItemArrowIcon, "RadioButton.icon", radioButtonIcon, "RadioButtonMenuItem.checkIcon", radioButtonMenuItemIcon, "InternalFrame.layoutTitlePaneAtOrigin", new XPValue(Boolean.TRUE, Boolean.FALSE), "Table.ascendingSortIcon", new XPValue(new SwingLazyValue("sun.swing.icon.SortArrowIcon", null, new Object[]{Boolean.TRUE, "Table.sortIconColor"}), new SwingLazyValue("sun.swing.plaf.windows.ClassicSortArrowIcon", null, new Object[]{Boolean.TRUE})), "Table.descendingSortIcon", new XPValue(new SwingLazyValue("sun.swing.icon.SortArrowIcon", null, new Object[]{Boolean.FALSE, "Table.sortIconColor"}), new SwingLazyValue("sun.swing.plaf.windows.ClassicSortArrowIcon", null, new Object[]{Boolean.FALSE}))};
        return lazyDefaults;
    }

    public void uninitialize() {
        super.uninitialize();
        this.toolkit = null;
        if (WindowsPopupMenuUI.mnemonicListener != null) {
            MenuSelectionManager.defaultManager().removeChangeListener(WindowsPopupMenuUI.mnemonicListener);
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(WindowsRootPaneUI.altProcessor);
        DesktopProperty.flushUnreferencedProperties();
    }

    public static void setMnemonicHidden(boolean hide) {
        isMnemonicHidden = UIManager.getBoolean("Button.showMnemonics") ? false : hide;
    }

    public static boolean isMnemonicHidden() {
        if (UIManager.getBoolean("Button.showMnemonics")) {
            isMnemonicHidden = false;
        }
        return isMnemonicHidden;
    }

    public static boolean isClassicWindows() {
        return isClassicWindows;
    }

    public void provideErrorFeedback(Component component) {
        super.provideErrorFeedback(component);
    }

    public LayoutStyle getLayoutStyle() {
        LayoutStyle style = this.style;
        if (style == null) {
            this.style = style = new WindowsLayoutStyle();
        }
        return style;
    }

    protected Action createAudioAction(Object key) {
        if (key != null) {
            String audioKey = (String)key;
            String audioValue = (String)UIManager.get(key);
            return new AudioAction(audioKey, audioValue);
        }
        return null;
    }

    static void repaintRootPane(Component c) {
        Component root = null;
        while (c != null) {
            if (c instanceof JRootPane) {
                root = (JRootPane)c;
            }
            c = c.getParent();
        }
        if (root != null) {
            root.repaint();
        } else {
            c.repaint();
        }
    }

    private int dluToPixels(int dlu, int direction) {
        if (this.baseUnitX == 0) {
            this.calculateBaseUnits();
        }
        if (direction == 3 || direction == 7) {
            return dlu * this.baseUnitX / 4;
        }
        assert (direction == 1 || direction == 5);
        return dlu * this.baseUnitY / 8;
    }

    private void calculateBaseUnits() {
        FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(UIManager.getFont("Button.font"));
        this.baseUnitX = metrics.stringWidth("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
        this.baseUnitX = (this.baseUnitX / 26 + 1) / 2;
        this.baseUnitY = metrics.getAscent() + metrics.getDescent() - 1;
    }

    public Icon getDisabledIcon(JComponent component, Icon icon) {
        if (icon != null && component != null && Boolean.TRUE.equals(component.getClientProperty(HI_RES_DISABLED_ICON_CLIENT_KEY)) && icon.getIconWidth() > 0 && icon.getIconHeight() > 0) {
            BufferedImage img = new BufferedImage(icon.getIconWidth(), icon.getIconWidth(), 2);
            icon.paintIcon(component, img.getGraphics(), 0, 0);
            RGBGrayFilter filter = new RGBGrayFilter();
            FilteredImageSource producer = new FilteredImageSource(img.getSource(), filter);
            Image resultImage = component.createImage(producer);
            return new ImageIconUIResource(resultImage);
        }
        return super.getDisabledIcon(component, icon);
    }

    private static class RGBGrayFilter
    extends RGBImageFilter {
        public RGBGrayFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int x, int y, int rgb) {
            float avg = ((float)(rgb >> 16 & 0xFF) / 255.0f + (float)(rgb >> 8 & 0xFF) / 255.0f + (float)(rgb & 0xFF) / 255.0f) / 3.0f;
            float alpha = (float)(rgb >> 24 & 0xFF) / 255.0f;
            avg = Math.min(1.0f, (1.0f - avg) / 2.857143f + avg);
            int rgbval = (int)(alpha * 255.0f) << 24 | (int)(avg * 255.0f) << 16 | (int)(avg * 255.0f) << 8 | (int)(avg * 255.0f);
            return rgbval;
        }
    }

    private class WindowsLayoutStyle
    extends DefaultLayoutStyle {
        private WindowsLayoutStyle() {
        }

        public int getPreferredGap(JComponent component1, JComponent component2, LayoutStyle.ComponentPlacement type, int position, Container parent) {
            super.getPreferredGap(component1, component2, type, position, parent);
            switch (type) {
                case INDENT: {
                    if (position == 3 || position == 7) {
                        int indent = this.getIndent(component1, position);
                        if (indent > 0) {
                            return indent;
                        }
                        return 10;
                    }
                }
                case RELATED: {
                    if (this.isLabelAndNonlabel(component1, component2, position)) {
                        return this.getButtonGap(component1, component2, position, WindowsLookAndFeel.this.dluToPixels(3, position));
                    }
                    return this.getButtonGap(component1, component2, position, WindowsLookAndFeel.this.dluToPixels(4, position));
                }
                case UNRELATED: {
                    return this.getButtonGap(component1, component2, position, WindowsLookAndFeel.this.dluToPixels(7, position));
                }
            }
            return 0;
        }

        public int getContainerGap(JComponent component, int position, Container parent) {
            super.getContainerGap(component, position, parent);
            return this.getButtonGap(component, position, WindowsLookAndFeel.this.dluToPixels(7, position));
        }
    }

    private class FontDesktopProperty
    extends TriggerDesktopProperty {
        FontDesktopProperty(String key) {
            super(key);
        }

        protected void updateUI() {
            SwingUtilities2.AATextInfo aaTextInfo = SwingUtilities2.AATextInfo.getAATextInfo(true);
            UIDefaults defaults = UIManager.getLookAndFeelDefaults();
            defaults.put(SwingUtilities2.AA_TEXT_PROPERTY_KEY, aaTextInfo);
            super.updateUI();
        }
    }

    private class TriggerDesktopProperty
    extends DesktopProperty {
        TriggerDesktopProperty(String key) {
            super(key, null, WindowsLookAndFeel.this.toolkit);
            this.getValueFromDesktop();
        }

        protected void updateUI() {
            super.updateUI();
            this.getValueFromDesktop();
        }
    }

    private class XPDLUValue
    extends XPValue {
        private int direction;

        XPDLUValue(int xpdlu, int classicdlu, int direction) {
            super(new Integer(xpdlu), new Integer(classicdlu));
            this.direction = direction;
        }

        public Object getXPValue(UIDefaults table) {
            int px = WindowsLookAndFeel.this.dluToPixels((Integer)this.xpValue, this.direction);
            return new Integer(px);
        }

        public Object getClassicValue(UIDefaults table) {
            int px = WindowsLookAndFeel.this.dluToPixels((Integer)this.classicValue, this.direction);
            return new Integer(px);
        }
    }

    private static class XPColorValue
    extends XPValue {
        XPColorValue(TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop, Object classicValue) {
            super(new XPColorValueKey(part, state, prop), classicValue);
        }

        public Object getXPValue(UIDefaults table) {
            XPColorValueKey key = (XPColorValueKey)this.xpValue;
            return XPStyle.getXP().getColor(key.skin, key.prop, null);
        }

        private static class XPColorValueKey {
            XPStyle.Skin skin;
            TMSchema.Prop prop;

            XPColorValueKey(TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop) {
                this.skin = new XPStyle.Skin(part, state);
                this.prop = prop;
            }
        }
    }

    private static class XPBorderValue
    extends XPValue {
        private final Border extraMargin;

        XPBorderValue(TMSchema.Part xpValue, Object classicValue) {
            this(xpValue, classicValue, null);
        }

        XPBorderValue(TMSchema.Part xpValue, Object classicValue, Border extraMargin) {
            super((Object)xpValue, classicValue);
            this.extraMargin = extraMargin;
        }

        public Object getXPValue(UIDefaults table) {
            Border xpBorder = XPStyle.getXP().getBorder(null, (TMSchema.Part)((Object)this.xpValue));
            if (this.extraMargin != null) {
                return new BorderUIResource.CompoundBorderUIResource(xpBorder, this.extraMargin);
            }
            return xpBorder;
        }
    }

    private static class XPValue
    implements UIDefaults.ActiveValue {
        protected Object classicValue;
        protected Object xpValue;
        private static final Object NULL_VALUE = new Object();

        XPValue(Object xpValue, Object classicValue) {
            this.xpValue = xpValue;
            this.classicValue = classicValue;
        }

        public Object createValue(UIDefaults table) {
            Object value = null;
            if (XPStyle.getXP() != null) {
                value = this.getXPValue(table);
            }
            if (value == null) {
                value = this.getClassicValue(table);
            } else if (value == NULL_VALUE) {
                value = null;
            }
            return value;
        }

        protected Object getXPValue(UIDefaults table) {
            return this.recursiveCreateValue(this.xpValue, table);
        }

        protected Object getClassicValue(UIDefaults table) {
            return this.recursiveCreateValue(this.classicValue, table);
        }

        private Object recursiveCreateValue(Object value, UIDefaults table) {
            if (value instanceof UIDefaults.LazyValue) {
                value = ((UIDefaults.LazyValue)value).createValue(table);
            }
            if (value instanceof UIDefaults.ActiveValue) {
                return ((UIDefaults.ActiveValue)value).createValue(table);
            }
            return value;
        }
    }

    private static class WindowsFontSizeProperty
    extends DesktopProperty {
        private String fontName;
        private int fontSize;
        private int fontStyle;

        WindowsFontSizeProperty(String key, Toolkit toolkit, String fontName, int fontStyle, int fontSize) {
            super(key, null, toolkit);
            this.fontName = fontName;
            this.fontSize = fontSize;
            this.fontStyle = fontStyle;
        }

        protected Object configureValue(Object value) {
            if (value == null) {
                value = new FontUIResource(this.fontName, this.fontStyle, this.fontSize);
            } else if (value instanceof Integer) {
                value = new FontUIResource(this.fontName, this.fontStyle, (Integer)value);
            }
            return value;
        }
    }

    private static class WindowsFontProperty
    extends DesktopProperty {
        WindowsFontProperty(String key, Object backup, Toolkit kit) {
            super(key, backup, kit);
        }

        public void invalidate(LookAndFeel laf) {
            if ("win.defaultGUI.font.height".equals(this.getKey())) {
                ((WindowsLookAndFeel)laf).style = null;
            }
            super.invalidate(laf);
        }

        protected Object configureValue(Object value) {
            if (value instanceof Font) {
                Font font = (Font)value;
                if ("MS Sans Serif".equals(font.getName())) {
                    FontUIResource msFont;
                    int dpi;
                    int size = font.getSize();
                    try {
                        dpi = Toolkit.getDefaultToolkit().getScreenResolution();
                    }
                    catch (HeadlessException ex) {
                        dpi = 96;
                    }
                    if (Math.round((float)size * 72.0f / (float)dpi) < 8) {
                        size = Math.round((float)(8 * dpi) / 72.0f);
                    }
                    if ((msFont = new FontUIResource("Microsoft Sans Serif", font.getStyle(), size)).getName() != null && msFont.getName().equals(msFont.getFamily())) {
                        font = msFont;
                    } else if (size != font.getSize()) {
                        font = new FontUIResource("MS Sans Serif", font.getStyle(), size);
                    }
                }
                if (FontManager.fontSupportsDefaultEncoding(font)) {
                    if (!(font instanceof UIResource)) {
                        font = new FontUIResource(font);
                    }
                } else {
                    font = FontManager.getCompositeFontUIResource(font);
                }
                return font;
            }
            return super.configureValue(value);
        }
    }

    private static class SkinIcon
    implements Icon,
    UIResource {
        private final TMSchema.Part part;
        private final TMSchema.State state;

        SkinIcon(TMSchema.Part part, TMSchema.State state) {
            this.part = part;
            this.state = state;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            XPStyle xp = XPStyle.getXP();
            assert (xp != null);
            if (xp != null) {
                XPStyle.Skin skin = xp.getSkin(null, this.part);
                skin.paintSkin(g, x, y, this.state);
            }
        }

        public int getIconWidth() {
            int width = 0;
            XPStyle xp = XPStyle.getXP();
            assert (xp != null);
            if (xp != null) {
                XPStyle.Skin skin = xp.getSkin(null, this.part);
                width = skin.getWidth();
            }
            return width;
        }

        public int getIconHeight() {
            int height = 0;
            XPStyle xp = XPStyle.getXP();
            if (xp != null) {
                XPStyle.Skin skin = xp.getSkin(null, this.part);
                height = skin.getHeight();
            }
            return height;
        }
    }

    private class ActiveWindowsIcon
    implements UIDefaults.ActiveValue {
        private Icon icon;
        private Icon fallback;
        private String nativeImageName;
        private DesktopProperty desktopProperty;

        ActiveWindowsIcon(String desktopPropertyName, String nativeImageName, Icon fallback) {
            this.nativeImageName = nativeImageName;
            this.fallback = fallback;
            if (OSInfo.getOSType() == OSInfo.OSType.WINDOWS && OSInfo.getWindowsVersion().compareTo(OSInfo.WINDOWS_XP) < 0) {
                this.desktopProperty = new TriggerDesktopProperty(desktopPropertyName){

                    protected void updateUI() {
                        ActiveWindowsIcon.this.icon = null;
                        super.updateUI();
                    }
                };
            }
        }

        public Object createValue(UIDefaults table) {
            Image image;
            if (this.icon == null && (image = (Image)ShellFolder.get(this.nativeImageName)) != null) {
                this.icon = new ImageIconUIResource(image);
            }
            if (this.icon == null && this.fallback != null) {
                this.icon = this.fallback;
            }
            return this.icon;
        }
    }

    private static class LazyWindowsIcon
    implements UIDefaults.LazyValue {
        private String nativeImage;
        private String resource;

        LazyWindowsIcon(String nativeImage, String resource) {
            this.nativeImage = nativeImage;
            this.resource = resource;
        }

        public Object createValue(UIDefaults table) {
            Image image;
            if (this.nativeImage != null && (image = (Image)ShellFolder.get(this.nativeImage)) != null) {
                return new ImageIcon(image);
            }
            return SwingUtilities2.makeIcon(this.getClass(), WindowsLookAndFeel.class, this.resource);
        }
    }

    private static class AudioAction
    extends AbstractAction {
        private Runnable audioRunnable;
        private String audioResource;

        public AudioAction(String name, String resource) {
            super(name);
            this.audioResource = resource;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.audioRunnable == null) {
                this.audioRunnable = (Runnable)Toolkit.getDefaultToolkit().getDesktopProperty(this.audioResource);
            }
            if (this.audioRunnable != null) {
                new Thread(this.audioRunnable).start();
            }
        }
    }
}

