/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsMenuItemUIAccessor;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;
import sun.swing.SwingUtilities2;

public class WindowsMenuItemUI
extends BasicMenuItemUI {
    final WindowsMenuItemUIAccessor accessor = new WindowsMenuItemUIAccessor(){

        public JMenuItem getMenuItem() {
            return WindowsMenuItemUI.this.menuItem;
        }

        public TMSchema.State getState(JMenuItem menuItem) {
            return WindowsMenuItemUI.getState(this, menuItem);
        }

        public TMSchema.Part getPart(JMenuItem menuItem) {
            return WindowsMenuItemUI.getPart(this, menuItem);
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new WindowsMenuItemUI();
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        if (WindowsMenuItemUI.isVistaPainting()) {
            WindowsMenuItemUI.paintText(this.accessor, g, menuItem, textRect, text);
            return;
        }
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        if (model.isEnabled() && (model.isArmed() || menuItem instanceof JMenu && model.isSelected())) {
            g.setColor(this.selectionForeground);
        }
        WindowsGraphicsUtils.paintText(g, menuItem, textRect, text, 0);
        g.setColor(oldColor);
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        if (WindowsMenuItemUI.isVistaPainting()) {
            WindowsMenuItemUI.paintBackground(this.accessor, g, menuItem, bgColor);
            return;
        }
        super.paintBackground(g, menuItem, bgColor);
    }

    static void paintBackground(WindowsMenuItemUIAccessor menuItemUI, Graphics g, JMenuItem menuItem, Color bgColor) {
        assert (WindowsMenuItemUI.isVistaPainting());
        if (WindowsMenuItemUI.isVistaPainting()) {
            int menuWidth = menuItem.getWidth();
            int menuHeight = menuItem.getHeight();
            if (menuItem.isOpaque()) {
                Color oldColor = g.getColor();
                g.setColor(menuItem.getBackground());
                g.fillRect(0, 0, menuWidth, menuHeight);
                g.setColor(oldColor);
            }
            XPStyle xp = XPStyle.getXP();
            TMSchema.Part part = menuItemUI.getPart(menuItem);
            XPStyle.Skin skin = xp.getSkin(menuItem, part);
            skin.paintSkin(g, 0, 0, menuWidth, menuHeight, menuItemUI.getState(menuItem));
        }
    }

    static void paintText(WindowsMenuItemUIAccessor menuItemUI, Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        assert (WindowsMenuItemUI.isVistaPainting());
        if (WindowsMenuItemUI.isVistaPainting()) {
            TMSchema.State state = menuItemUI.getState(menuItem);
            FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)menuItem, g);
            int mnemIndex = menuItem.getDisplayedMnemonicIndex();
            if (WindowsLookAndFeel.isMnemonicHidden()) {
                mnemIndex = -1;
            }
            WindowsGraphicsUtils.paintXPText(menuItem, menuItemUI.getPart(menuItem), state, g, textRect.x, textRect.y + fm.getAscent(), text, mnemIndex);
        }
    }

    static TMSchema.State getState(WindowsMenuItemUIAccessor menuItemUI, JMenuItem menuItem) {
        ButtonModel model = menuItem.getModel();
        TMSchema.State state = model.isArmed() ? (model.isEnabled() ? TMSchema.State.HOT : TMSchema.State.DISABLEDHOT) : (model.isEnabled() ? TMSchema.State.NORMAL : TMSchema.State.DISABLED);
        return state;
    }

    static TMSchema.Part getPart(WindowsMenuItemUIAccessor menuItemUI, JMenuItem menuItem) {
        return TMSchema.Part.MP_POPUPITEM;
    }

    static boolean isVistaPainting() {
        XPStyle xp = XPStyle.getXP();
        return xp != null && xp.isSkinDefined(null, TMSchema.Part.MP_POPUPITEM);
    }
}

