/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.Code;
import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.Package;
import com.sun.java.util.jar.pack.Utils;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;

class ClassReader
implements Constants {
    int verbose;
    Package pkg;
    Package.Class cls;
    long inPos;
    DataInputStream in;
    Map attrDefs;
    Map attrCommands;
    String unknownAttrCommand = "error";

    ClassReader(Package.Class cls, InputStream in) throws IOException {
        this.pkg = cls.getPackage();
        this.cls = cls;
        this.verbose = this.pkg.verbose;
        this.in = new DataInputStream(new FilterInputStream(in){

            public int read(byte[] b, int off, int len) throws IOException {
                int nr = super.read(b, off, len);
                if (nr >= 0) {
                    ClassReader.this.inPos += (long)nr;
                }
                return nr;
            }

            public int read() throws IOException {
                int ch = super.read();
                if (ch >= 0) {
                    ++ClassReader.this.inPos;
                }
                return ch;
            }

            public long skip(long n) throws IOException {
                long ns = super.skip(n);
                if (ns >= 0L) {
                    ClassReader.this.inPos += ns;
                }
                return ns;
            }
        });
    }

    public void setAttrDefs(Map attrDefs) {
        this.attrDefs = attrDefs;
    }

    public void setAttrCommands(Map attrCommands) {
        this.attrCommands = attrCommands;
    }

    private void skip(int n, String what) throws IOException {
        long skipped;
        long j;
        Utils.log.warning("skipping " + n + " bytes of " + what);
        for (skipped = 0L; skipped < (long)n; skipped += j) {
            j = this.in.skip((long)n - skipped);
            assert (j > 0L);
        }
        assert (skipped == (long)n);
    }

    private int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    private int readInt() throws IOException {
        return this.in.readInt();
    }

    private ConstantPool.Entry readRef() throws IOException {
        int i = this.in.readUnsignedShort();
        return i == 0 ? null : this.cls.cpMap[i];
    }

    private ConstantPool.Entry readRef(byte tag) throws IOException {
        ConstantPool.Entry e = this.readRef();
        assert (e != null);
        assert (e.tagMatches(tag));
        return e;
    }

    private ConstantPool.Entry readRefOrNull(byte tag) throws IOException {
        ConstantPool.Entry e = this.readRef();
        assert (e == null || e.tagMatches(tag));
        return e;
    }

    private ConstantPool.Utf8Entry readUtf8Ref() throws IOException {
        return (ConstantPool.Utf8Entry)this.readRef((byte)1);
    }

    private ConstantPool.ClassEntry readClassRef() throws IOException {
        return (ConstantPool.ClassEntry)this.readRef((byte)7);
    }

    private ConstantPool.ClassEntry readClassRefOrNull() throws IOException {
        return (ConstantPool.ClassEntry)this.readRefOrNull((byte)7);
    }

    private ConstantPool.SignatureEntry readSignatureRef() throws IOException {
        ConstantPool.Entry e = this.readRef((byte)1);
        return ConstantPool.getSignatureEntry(e.stringValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read() throws IOException {
        boolean ok = false;
        try {
            this.readMagicNumbers();
            this.readConstantPool();
            this.readHeader();
            this.readMembers(false);
            this.readMembers(true);
            this.readAttributes(0, this.cls);
            this.cls.finishReading();
            assert (0 >= this.in.read(new byte[1]));
            ok = true;
        }
        finally {
            if (!ok && this.verbose > 0) {
                Utils.log.warning("Erroneous data at input offset " + this.inPos + " of " + this.cls.file);
            }
        }
    }

    void readMagicNumbers() throws IOException {
        this.cls.magic = this.in.readInt();
        if (this.cls.magic != -889275714) {
            throw new Attribute.FormatException("Bad magic number in class file " + Integer.toHexString(this.cls.magic), 0, "magic-number", "pass");
        }
        this.cls.minver = (short)this.readUnsignedShort();
        this.cls.majver = (short)this.readUnsignedShort();
        String bad = this.checkVersion(this.cls.majver, this.cls.minver);
        if (bad != null) {
            throw new Attribute.FormatException("classfile version too " + bad + ": " + this.cls.majver + "." + this.cls.minver + " in " + this.cls.file, 0, "version", "pass");
        }
    }

    private String checkVersion(int majver, int minver) {
        if (majver < this.pkg.min_class_majver || majver == this.pkg.min_class_majver && minver < this.pkg.min_class_minver) {
            return "small";
        }
        if (majver > this.pkg.max_class_majver || majver == this.pkg.max_class_majver && minver > this.pkg.max_class_minver) {
            return "large";
        }
        return null;
    }

    void readConstantPool() throws IOException {
        int length = this.in.readUnsignedShort();
        int[] fixups = new int[length * 4];
        int fptr = 0;
        ConstantPool.Entry[] cpMap = new ConstantPool.Entry[length];
        cpMap[0] = null;
        block15: for (int i = 1; i < length; ++i) {
            byte tag = this.in.readByte();
            switch (tag) {
                case 1: {
                    cpMap[i] = ConstantPool.getUtf8Entry(this.in.readUTF());
                    continue block15;
                }
                case 3: {
                    Number val = new Integer(this.in.readInt());
                    cpMap[i] = ConstantPool.getLiteralEntry(val);
                    continue block15;
                }
                case 4: {
                    Number val = new Float(this.in.readFloat());
                    cpMap[i] = ConstantPool.getLiteralEntry(val);
                    continue block15;
                }
                case 5: {
                    Number val = new Long(this.in.readLong());
                    cpMap[i] = ConstantPool.getLiteralEntry(val);
                    cpMap[++i] = null;
                    continue block15;
                }
                case 6: {
                    Number val = new Double(this.in.readDouble());
                    cpMap[i] = ConstantPool.getLiteralEntry(val);
                    cpMap[++i] = null;
                    continue block15;
                }
                case 7: 
                case 8: {
                    fixups[fptr++] = i;
                    fixups[fptr++] = tag;
                    fixups[fptr++] = this.in.readUnsignedShort();
                    fixups[fptr++] = -1;
                    continue block15;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    fixups[fptr++] = i;
                    fixups[fptr++] = tag;
                    fixups[fptr++] = this.in.readUnsignedShort();
                    fixups[fptr++] = this.in.readUnsignedShort();
                    continue block15;
                }
                default: {
                    throw new IOException("Bad constant pool tag " + tag);
                }
            }
        }
        while (fptr > 0) {
            if (this.verbose > 3) {
                Utils.log.fine("CP fixups [" + fptr / 4 + "]");
            }
            int flimit = fptr;
            fptr = 0;
            int fi = 0;
            block17: while (fi < flimit) {
                int cpi = fixups[fi++];
                int tag = fixups[fi++];
                int ref = fixups[fi++];
                int ref2 = fixups[fi++];
                if (this.verbose > 3) {
                    Utils.log.fine("  cp[" + cpi + "] = " + ConstantPool.tagName(tag) + "{" + ref + "," + ref2 + "}");
                }
                if (cpMap[ref] == null || ref2 >= 0 && cpMap[ref2] == null) {
                    fixups[fptr++] = cpi;
                    fixups[fptr++] = tag;
                    fixups[fptr++] = ref;
                    fixups[fptr++] = ref2;
                    continue;
                }
                switch (tag) {
                    case 7: {
                        cpMap[cpi] = ConstantPool.getClassEntry(cpMap[ref].stringValue());
                        continue block17;
                    }
                    case 8: {
                        cpMap[cpi] = ConstantPool.getStringEntry(cpMap[ref].stringValue());
                        continue block17;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        ConstantPool.ClassEntry mclass = (ConstantPool.ClassEntry)cpMap[ref];
                        ConstantPool.DescriptorEntry mdescr = (ConstantPool.DescriptorEntry)cpMap[ref2];
                        cpMap[cpi] = ConstantPool.getMemberEntry((byte)tag, mclass, mdescr);
                        continue block17;
                    }
                    case 12: {
                        ConstantPool.Utf8Entry mname = (ConstantPool.Utf8Entry)cpMap[ref];
                        ConstantPool.Utf8Entry mtype = (ConstantPool.Utf8Entry)cpMap[ref2];
                        cpMap[cpi] = ConstantPool.getDescriptorEntry(mname, mtype);
                        continue block17;
                    }
                }
                assert (false);
            }
            assert (fptr < flimit);
        }
        this.cls.cpMap = cpMap;
    }

    void readHeader() throws IOException {
        this.cls.flags = this.readUnsignedShort();
        this.cls.thisClass = this.readClassRef();
        this.cls.superClass = this.readClassRefOrNull();
        int ni = this.readUnsignedShort();
        this.cls.interfaces = new ConstantPool.ClassEntry[ni];
        for (int i = 0; i < ni; ++i) {
            this.cls.interfaces[i] = this.readClassRef();
        }
    }

    void readMembers(boolean doMethods) throws IOException {
        int nm = this.readUnsignedShort();
        for (int i = 0; i < nm; ++i) {
            this.readMember(doMethods);
        }
    }

    void readMember(boolean doMethod) throws IOException {
        Package.Class.Member m;
        int mflags = this.readUnsignedShort();
        ConstantPool.Utf8Entry mname = this.readUtf8Ref();
        ConstantPool.SignatureEntry mtype = this.readSignatureRef();
        ConstantPool.DescriptorEntry descr = ConstantPool.getDescriptorEntry(mname, mtype);
        if (!doMethod) {
            Package.Class clazz = this.cls;
            clazz.getClass();
            m = new Package.Class.Field(clazz, mflags, descr);
        } else {
            Package.Class clazz = this.cls;
            clazz.getClass();
            m = new Package.Class.Method(clazz, mflags, descr);
        }
        this.readAttributes(!doMethod ? 1 : 2, m);
    }

    void readAttributes(int ctype, Attribute.Holder h) throws IOException {
        int na = this.readUnsignedShort();
        if (na == 0) {
            return;
        }
        if (this.verbose > 3) {
            Utils.log.fine("readAttributes " + h + " [" + na + "]");
        }
        for (int i = 0; i < na; ++i) {
            boolean isStackMap;
            String name = this.readUtf8Ref().stringValue();
            int length = this.readInt();
            if (this.attrCommands != null) {
                Object lkey = Attribute.keyForLookup(ctype, name);
                String cmd = (String)this.attrCommands.get(lkey);
                if (cmd == "pass") {
                    String message = "passing attribute bitwise in " + h;
                    throw new Attribute.FormatException(message, ctype, name, cmd);
                }
                if (cmd == "error") {
                    String message = "attribute not allowed in " + h;
                    throw new Attribute.FormatException(message, ctype, name, cmd);
                }
                if (cmd == "strip") {
                    this.skip(length, name + " attribute in " + h);
                    continue;
                }
            }
            Attribute a = Attribute.lookup(Package.attrDefs, ctype, name);
            if (this.verbose > 4 && a != null) {
                Utils.log.fine("pkg_attribute_lookup " + name + " = " + a);
            }
            if (a == null) {
                a = Attribute.lookup(this.attrDefs, ctype, name);
                if (this.verbose > 4 && a != null) {
                    Utils.log.fine("this " + name + " = " + a);
                }
            }
            if (a == null) {
                a = Attribute.lookup(null, ctype, name);
                if (this.verbose > 4 && a != null) {
                    Utils.log.fine("null_attribute_lookup " + name + " = " + a);
                }
            }
            if (a == null && length == 0) {
                a = Attribute.find(ctype, name, "");
            }
            boolean bl = isStackMap = ctype == 3 && (name.equals("StackMap") || name.equals("StackMapX"));
            if (isStackMap) {
                Code code = (Code)h;
                int TOO_BIG = 65536;
                if (code.max_stack >= 65536 || code.max_locals >= 65536 || code.getLength() >= 65536 || name.endsWith("X")) {
                    a = null;
                }
            }
            if (a == null) {
                if (isStackMap) {
                    String message = "unsupported StackMap variant in " + h;
                    throw new Attribute.FormatException(message, ctype, name, "pass");
                }
                if (this.unknownAttrCommand == "strip") {
                    this.skip(length, "unknown " + name + " attribute in " + h);
                    continue;
                }
                String message = "unknown in " + h;
                throw new Attribute.FormatException(message, ctype, name, this.unknownAttrCommand);
            }
            if (a.layout() == Package.attrCodeEmpty || a.layout() == Package.attrInnerClassesEmpty) {
                long pos0 = this.inPos;
                if (a.name() == "Code") {
                    Package.Class.Method m = (Package.Class.Method)h;
                    m.code = new Code(m);
                    this.readCode(m.code);
                } else {
                    assert (h == this.cls);
                    this.readInnerClasses(this.cls);
                }
                assert ((long)length == this.inPos - pos0);
            } else if (length > 0) {
                byte[] bytes = new byte[length];
                this.in.readFully(bytes);
                a = a.addContent(bytes);
            }
            h.addAttribute(a);
            if (this.verbose <= 2) continue;
            Utils.log.fine("read " + a);
        }
    }

    void readCode(Code code) throws IOException {
        code.max_stack = this.readUnsignedShort();
        code.max_locals = this.readUnsignedShort();
        code.bytes = new byte[this.readInt()];
        this.in.readFully(code.bytes);
        int nh = this.readUnsignedShort();
        code.setHandlerCount(nh);
        for (int i = 0; i < nh; ++i) {
            code.handler_start[i] = this.readUnsignedShort();
            code.handler_end[i] = this.readUnsignedShort();
            code.handler_catch[i] = this.readUnsignedShort();
            code.handler_class[i] = this.readClassRefOrNull();
        }
        this.readAttributes(3, code);
    }

    void readInnerClasses(Package.Class cls) throws IOException {
        int nc = this.readUnsignedShort();
        ArrayList<Package.InnerClass> ics = new ArrayList<Package.InnerClass>(nc);
        for (int i = 0; i < nc; ++i) {
            Package.InnerClass ic = new Package.InnerClass(this.readClassRef(), this.readClassRefOrNull(), (ConstantPool.Utf8Entry)this.readRefOrNull((byte)1), this.readUnsignedShort());
            ics.add(ic);
        }
        cls.innerClasses = ics;
    }
}

