/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.AdaptiveCoding;
import com.sun.java.util.jar.pack.BandStructure;
import com.sun.java.util.jar.pack.Coding;
import com.sun.java.util.jar.pack.CodingMethod;
import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.Histogram;
import com.sun.java.util.jar.pack.PropMap;
import com.sun.java.util.jar.pack.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;

class PopulationCoding
implements Constants,
CodingMethod {
    Histogram vHist;
    int[] fValues;
    int fVlen;
    long[] symtab;
    CodingMethod favoredCoding;
    CodingMethod tokenCoding;
    CodingMethod unfavoredCoding;
    int L = -1;
    static final int[] LValuesCoded = new int[]{-1, 4, 8, 16, 32, 64, 128, 192, 224, 240, 248, 252};

    PopulationCoding() {
    }

    public void setFavoredValues(int[] fValues, int fVlen) {
        assert (fValues[0] == 0);
        assert (this.fValues == null);
        this.fValues = fValues;
        this.fVlen = fVlen;
        if (this.L >= 0) {
            this.setL(this.L);
        }
    }

    public void setFavoredValues(int[] fValues) {
        int fVlen = fValues.length - 1;
        this.setFavoredValues(fValues, fVlen);
    }

    public void setHistogram(Histogram vHist) {
        this.vHist = vHist;
    }

    public void setL(int L) {
        this.L = L;
        if (L >= 0 && this.fValues != null && this.tokenCoding == null) {
            this.tokenCoding = PopulationCoding.fitTokenCoding(this.fVlen, L);
            assert (this.tokenCoding != null);
        }
    }

    public static Coding fitTokenCoding(int fVlen, int L) {
        if (fVlen < 256) {
            return BandStructure.BYTE1;
        }
        Coding longest = BandStructure.UNSIGNED5.setL(L);
        if (!longest.canRepresentUnsigned(fVlen)) {
            return null;
        }
        Coding tc = longest;
        Coding shorter = longest;
        while ((shorter = shorter.setB(shorter.B() - 1)).umax() >= fVlen) {
            tc = shorter;
        }
        return tc;
    }

    public void setFavoredCoding(CodingMethod favoredCoding) {
        this.favoredCoding = favoredCoding;
    }

    public void setTokenCoding(CodingMethod tokenCoding) {
        Coding tc;
        this.tokenCoding = tokenCoding;
        this.L = -1;
        if (tokenCoding instanceof Coding && this.fValues != null && (tc = (Coding)tokenCoding) == PopulationCoding.fitTokenCoding(this.fVlen, tc.L())) {
            this.L = tc.L();
        }
    }

    public void setUnfavoredCoding(CodingMethod unfavoredCoding) {
        this.unfavoredCoding = unfavoredCoding;
    }

    public int favoredValueMaxLength() {
        if (this.L == 0) {
            return Integer.MAX_VALUE;
        }
        return BandStructure.UNSIGNED5.setL(this.L).umax();
    }

    public void resortFavoredValues() {
        Coding tc = (Coding)this.tokenCoding;
        this.fValues = BandStructure.realloc(this.fValues, 1 + this.fVlen);
        int fillp = 1;
        for (int n = 1; n <= tc.B(); ++n) {
            int nmax = tc.byteMax(n);
            if (nmax > this.fVlen) {
                nmax = this.fVlen;
            }
            if (nmax < tc.byteMin(n)) break;
            int high = nmax + 1;
            int low = fillp;
            if (high == low) continue;
            assert (high > low) : high + "!>" + low;
            assert (tc.getLength(low) == n) : n + " != len(" + low + ") == " + tc.getLength(low);
            assert (tc.getLength(high - 1) == n) : n + " != len(" + (high - 1) + ") == " + tc.getLength(high - 1);
            int midTarget = low + (high - low) / 2;
            int mid = low;
            int prevCount = -1;
            int prevLimit = low;
            for (int i = low; i < high; ++i) {
                int val = this.fValues[i];
                int count = this.vHist.getFrequency(val);
                if (prevCount == count) continue;
                if (n == 1) {
                    Arrays.sort(this.fValues, prevLimit, i);
                } else if (Math.abs(mid - midTarget) > Math.abs(i - midTarget)) {
                    mid = i;
                }
                prevCount = count;
                prevLimit = i;
            }
            if (n == 1) {
                Arrays.sort(this.fValues, prevLimit, high);
            } else {
                Arrays.sort(this.fValues, low, mid);
                Arrays.sort(this.fValues, mid, high);
            }
            assert (tc.getLength(low) == tc.getLength(mid));
            assert (tc.getLength(low) == tc.getLength(high - 1));
            fillp = nmax + 1;
        }
        assert (fillp == this.fValues.length);
        this.symtab = null;
    }

    public int getToken(int value) {
        int pos;
        if (this.symtab == null) {
            this.symtab = this.makeSymtab();
        }
        if ((pos = Arrays.binarySearch(this.symtab, (long)value << 32)) < 0) {
            pos = -pos - 1;
        }
        if (pos < this.symtab.length && value == (int)(this.symtab[pos] >>> 32)) {
            return (int)this.symtab[pos];
        }
        return 0;
    }

    public int[][] encodeValues(int[] values, int start, int end) {
        int[] tokens = new int[end - start];
        int nuv = 0;
        for (int i = 0; i < tokens.length; ++i) {
            int val = values[start + i];
            int tok = this.getToken(val);
            if (tok != 0) {
                tokens[i] = tok;
                continue;
            }
            ++nuv;
        }
        int[] unfavoredValues = new int[nuv];
        nuv = 0;
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i] != 0) continue;
            int val = values[start + i];
            unfavoredValues[nuv++] = val;
        }
        assert (nuv == unfavoredValues.length);
        return new int[][]{tokens, unfavoredValues};
    }

    private long[] makeSymtab() {
        long[] symtab = new long[this.fVlen];
        for (int token = 1; token <= this.fVlen; ++token) {
            symtab[token - 1] = (long)this.fValues[token] << 32 | (long)token;
        }
        Arrays.sort(symtab);
        return symtab;
    }

    private Coding getTailCoding(CodingMethod c) {
        while (c instanceof AdaptiveCoding) {
            c = ((AdaptiveCoding)c).tailCoding;
        }
        return (Coding)c;
    }

    public void writeArrayTo(OutputStream out, int[] a, int start, int end) throws IOException {
        int[][] vals = this.encodeValues(a, start, end);
        this.writeSequencesTo(out, vals[0], vals[1]);
    }

    void writeSequencesTo(OutputStream out, int[] tokens, int[] uValues) throws IOException {
        this.favoredCoding.writeArrayTo(out, this.fValues, 1, 1 + this.fVlen);
        this.getTailCoding(this.favoredCoding).writeTo(out, this.computeSentinelValue());
        this.tokenCoding.writeArrayTo(out, tokens, 0, tokens.length);
        if (uValues.length > 0) {
            this.unfavoredCoding.writeArrayTo(out, uValues, 0, uValues.length);
        }
    }

    int computeSentinelValue() {
        int min;
        Coding fc = this.getTailCoding(this.favoredCoding);
        if (fc.isDelta()) {
            return 0;
        }
        int last = min = this.fValues[1];
        for (int i = 2; i <= this.fVlen; ++i) {
            last = this.fValues[i];
            min = PopulationCoding.moreCentral(min, last);
        }
        if (fc.getLength(min) <= fc.getLength(last)) {
            return min;
        }
        return last;
    }

    public void readArrayFrom(InputStream in, int[] a, int start, int end) throws IOException {
        this.setFavoredValues(this.readFavoredValuesFrom(in, end - start));
        this.tokenCoding.readArrayFrom(in, a, start, end);
        int headp = 0;
        int tailp = -1;
        int uVlen = 0;
        for (int i = start; i < end; ++i) {
            int tok = a[i];
            if (tok == 0) {
                if (tailp < 0) {
                    headp = i;
                } else {
                    a[tailp] = i;
                }
                tailp = i;
                ++uVlen;
                continue;
            }
            a[i] = this.fValues[tok];
        }
        int[] uValues = new int[uVlen];
        if (uVlen > 0) {
            this.unfavoredCoding.readArrayFrom(in, uValues, 0, uVlen);
        }
        for (int i = 0; i < uVlen; ++i) {
            int nextp = a[headp];
            a[headp] = uValues[i];
            headp = nextp;
        }
    }

    int[] readFavoredValuesFrom(InputStream in, int maxForDebug) throws IOException {
        int val;
        int[] fValues = new int[1000];
        HashSet<Integer> uniqueValuesForDebug = null;
        assert ((uniqueValuesForDebug = new HashSet<Integer>()) != null);
        int fillp = 1;
        maxForDebug += fillp;
        int min = Integer.MIN_VALUE;
        int last = 0;
        CodingMethod fcm = this.favoredCoding;
        while (fcm instanceof AdaptiveCoding) {
            AdaptiveCoding ac = (AdaptiveCoding)fcm;
            int len = ac.headLength;
            while (fillp + len > fValues.length) {
                fValues = BandStructure.realloc(fValues);
            }
            int newFillp = fillp + len;
            ac.headCoding.readArrayFrom(in, fValues, fillp, newFillp);
            while (fillp < newFillp) {
                val = fValues[fillp++];
                assert (uniqueValuesForDebug.add(new Integer(val)));
                assert (fillp <= maxForDebug);
                last = val;
                min = PopulationCoding.moreCentral(min, val);
            }
            fcm = ac.tailCoding;
        }
        Coding fc = (Coding)fcm;
        if (fc.isDelta()) {
            long state = 0L;
            while (true) {
                val = fc.isSubrange() ? fc.reduceToUnsignedRange(state) : (int)(state += (long)fc.readFrom(in));
                state = val;
                if (fillp <= 1 || val != last && val != min) {
                    if (fillp == fValues.length) {
                        fValues = BandStructure.realloc(fValues);
                    }
                    fValues[fillp++] = val;
                    assert (uniqueValuesForDebug.add(new Integer(val)));
                    assert (fillp <= maxForDebug);
                    last = val;
                    min = PopulationCoding.moreCentral(min, val);
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                int val2 = fc.readFrom(in);
                if (fillp > 1 && (val2 == last || val2 == min)) break;
                if (fillp == fValues.length) {
                    fValues = BandStructure.realloc(fValues);
                }
                fValues[fillp++] = val2;
                assert (uniqueValuesForDebug.add(new Integer(val2)));
                assert (fillp <= maxForDebug);
                last = val2;
                min = PopulationCoding.moreCentral(min, val2);
            }
        }
        return BandStructure.realloc(fValues, fillp);
    }

    private static int moreCentral(int x, int y) {
        int xy;
        int kx = x >> 31 ^ x << 1;
        int ky = y >> 31 ^ y << 1;
        int n = xy = (kx -= Integer.MIN_VALUE) < (ky -= Integer.MIN_VALUE) ? x : y;
        assert (xy == PopulationCoding.moreCentralSlow(x, y));
        return xy;
    }

    private static int moreCentralSlow(int x, int y) {
        int ax = x;
        if (ax < 0) {
            ax = -ax;
        }
        if (ax < 0) {
            return y;
        }
        int ay = y;
        if (ay < 0) {
            ay = -ay;
        }
        if (ay < 0) {
            return x;
        }
        if (ax < ay) {
            return x;
        }
        if (ax > ay) {
            return y;
        }
        return x < y ? x : y;
    }

    public byte[] getMetaCoding(Coding dflt) {
        int TDefL;
        int K = this.fVlen;
        int LCoded = 0;
        if (this.tokenCoding instanceof Coding) {
            Coding tc = (Coding)this.tokenCoding;
            if (tc.B() == 1) {
                LCoded = 1;
            } else if (this.L >= 0) {
                assert (this.L == tc.L());
                for (int i = 1; i < LValuesCoded.length; ++i) {
                    if (LValuesCoded[i] != this.L) continue;
                    LCoded = i;
                    break;
                }
            }
        }
        CodingMethod tokenDflt = null;
        if (LCoded != 0 && this.tokenCoding == PopulationCoding.fitTokenCoding(this.fVlen, this.L)) {
            tokenDflt = this.tokenCoding;
        }
        int FDef = this.favoredCoding == dflt ? 1 : 0;
        int UDef = this.unfavoredCoding == dflt || this.unfavoredCoding == null ? 1 : 0;
        boolean TDef = this.tokenCoding == tokenDflt;
        int n = TDefL = TDef ? LCoded : 0;
        assert (TDef == TDefL > 0);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(10);
        bytes.write(141 + FDef + 2 * UDef + 4 * TDefL);
        try {
            if (FDef == 0) {
                bytes.write(this.favoredCoding.getMetaCoding(dflt));
            }
            if (!TDef) {
                bytes.write(this.tokenCoding.getMetaCoding(dflt));
            }
            if (UDef == 0) {
                bytes.write(this.unfavoredCoding.getMetaCoding(dflt));
            }
        }
        catch (IOException ee) {
            throw new RuntimeException(ee);
        }
        return bytes.toByteArray();
    }

    public static int parseMetaCoding(byte[] bytes, int pos, Coding dflt, CodingMethod[] res) {
        int op;
        if ((op = bytes[pos++] & 0xFF) < 141 || op >= 189) {
            return pos - 1;
        }
        int FDef = (op -= 141) % 2;
        int UDef = op / 2 % 2;
        int TDefL = op / 4;
        boolean TDef = TDefL > 0;
        int L = LValuesCoded[TDefL];
        CodingMethod[] FCode = new CodingMethod[]{dflt};
        CodingMethod[] TCode = new CodingMethod[]{null};
        CodingMethod[] UCode = new CodingMethod[]{dflt};
        if (FDef == 0) {
            pos = BandStructure.parseMetaCoding(bytes, pos, dflt, FCode);
        }
        if (!TDef) {
            pos = BandStructure.parseMetaCoding(bytes, pos, dflt, TCode);
        }
        if (UDef == 0) {
            pos = BandStructure.parseMetaCoding(bytes, pos, dflt, UCode);
        }
        PopulationCoding pop = new PopulationCoding();
        pop.L = L;
        pop.favoredCoding = FCode[0];
        pop.tokenCoding = TCode[0];
        pop.unfavoredCoding = UCode[0];
        res[0] = pop;
        return pos;
    }

    private String keyString(CodingMethod m) {
        if (m instanceof Coding) {
            return ((Coding)m).keyString();
        }
        if (m == null) {
            return "none";
        }
        return m.toString();
    }

    public String toString() {
        PropMap p200 = Utils.currentPropMap();
        boolean verbose = p200 != null && p200.getBoolean("com.sun.java.util.jar.pack.verbose.pop");
        StringBuffer res = new StringBuffer(100);
        res.append("pop(").append("fVlen=").append(this.fVlen);
        if (verbose && this.fValues != null) {
            res.append(" fV=[");
            for (int i = 1; i <= this.fVlen; ++i) {
                res.append(i == 1 ? "" : ",").append(this.fValues[i]);
            }
            res.append(";").append(this.computeSentinelValue());
            res.append("]");
        }
        res.append(" fc=").append(this.keyString(this.favoredCoding));
        res.append(" tc=").append(this.keyString(this.tokenCoding));
        res.append(" uc=").append(this.keyString(this.unfavoredCoding));
        res.append(")");
        return res.toString();
    }
}

