/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.PackerImpl;
import com.sun.java.util.jar.pack.Utils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

class PropMap
extends TreeMap {
    ArrayList _listeners = new ArrayList(1);
    private static Map defaultProps;

    void addListener(PropertyChangeListener listener) {
        this._listeners.add(listener);
    }

    void removeListener(PropertyChangeListener listener) {
        this._listeners.remove(listener);
    }

    void addListeners(ArrayList listeners) {
        this._listeners.addAll(listeners);
    }

    void removeListeners(ArrayList listeners) {
        this._listeners.removeAll(listeners);
    }

    public Object put(Object key, Object value) {
        Object oldValue = super.put(key, value);
        if (value != oldValue && this._listeners.size() > 0) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, (String)key, oldValue, value);
            for (PropertyChangeListener listener : this._listeners) {
                listener.propertyChange(event);
            }
        }
        return oldValue;
    }

    PropMap() {
        this.putAll(defaultProps);
    }

    SortedMap prefixMap(String prefix) {
        int len = prefix.length();
        if (len == 0) {
            return this;
        }
        char nextch = (char)(prefix.charAt(len - 1) + '\u0001');
        String limit = prefix.substring(0, len - 1) + nextch;
        return this.subMap(prefix, limit);
    }

    String getProperty(String s) {
        return (String)this.get(s);
    }

    String getProperty(String s, String defaultVal) {
        String val = this.getProperty(s);
        if (val == null) {
            return defaultVal;
        }
        return val;
    }

    String setProperty(String s, String val) {
        return (String)this.put(s, val);
    }

    List getProperties(String prefix) {
        Collection values = this.prefixMap(prefix).values();
        ArrayList res = new ArrayList(values.size());
        res.addAll(values);
        while (res.remove(null)) {
        }
        return res;
    }

    private boolean toBoolean(String val) {
        return Boolean.valueOf(val);
    }

    boolean getBoolean(String s) {
        return this.toBoolean(this.getProperty(s));
    }

    boolean setBoolean(String s, boolean val) {
        return this.toBoolean(this.setProperty(s, String.valueOf(val)));
    }

    int toInteger(String val) {
        if (val == null) {
            return 0;
        }
        if ("true".equals(val)) {
            return 1;
        }
        if ("false".equals(val)) {
            return 0;
        }
        return Integer.parseInt(val);
    }

    int getInteger(String s) {
        return this.toInteger(this.getProperty(s));
    }

    int setInteger(String s, int val) {
        return this.toInteger(this.setProperty(s, String.valueOf(val)));
    }

    long toLong(String val) {
        try {
            return val == null ? 0L : Long.parseLong(val);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid value");
        }
    }

    long getLong(String s) {
        return this.toLong(this.getProperty(s));
    }

    long setLong(String s, long val) {
        return this.toLong(this.setProperty(s, String.valueOf(val)));
    }

    int getTime(String s) {
        String sval = this.getProperty(s, "0");
        if ("now".equals(sval)) {
            return (int)((System.currentTimeMillis() + 500L) / 1000L);
        }
        long lval = this.toLong(sval);
        long recentSecondCount = 1000000000L;
        if (lval < 10000000000L && !"0".equals(sval)) {
            Utils.log.warning("Supplied modtime appears to be seconds rather than milliseconds: " + sval);
        }
        return (int)((lval + 500L) / 1000L);
    }

    void list(PrintStream out) {
        PrintWriter outw = new PrintWriter(out);
        this.list(outw);
        outw.flush();
    }

    void list(PrintWriter out) {
        out.println("#PACK200[");
        Set defaults = defaultProps.entrySet();
        for (Map.Entry e : this.entrySet()) {
            if (defaults.contains(e)) continue;
            out.println("  " + e.getKey() + " = " + e.getValue());
        }
        out.println("#]");
    }

    static {
        Properties props = new Properties();
        props.put("com.sun.java.util.jar.pack.disable.native", String.valueOf(Boolean.getBoolean("com.sun.java.util.jar.pack.disable.native")));
        props.put("com.sun.java.util.jar.pack.verbose", String.valueOf(Integer.getInteger("com.sun.java.util.jar.pack.verbose", 0)));
        props.put("com.sun.java.util.jar.pack.default.timezone", String.valueOf(Boolean.getBoolean("com.sun.java.util.jar.pack.default.timezone")));
        props.put("pack.segment.limit", "1000000");
        props.put("pack.keep.file.order", "true");
        props.put("pack.modification.time", "keep");
        props.put("pack.deflate.hint", "keep");
        props.put("pack.unknown.attribute", "pass");
        props.put("pack.effort", "5");
        try {
            String propFile = "intrinsic.properties";
            InputStream propStr = PackerImpl.class.getResourceAsStream(propFile);
            props.load(new BufferedInputStream(propStr));
            propStr.close();
            for (Map.Entry entry : props.entrySet()) {
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                if (!key.startsWith("attribute.")) continue;
                entry.setValue(Attribute.normalizeLayoutString(val));
            }
        }
        catch (IOException ee) {
            throw new RuntimeException(ee);
        }
        defaultProps = new HashMap<Object, Object>(props);
    }
}

