/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.EventDispatcher;
import java.util.Vector;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;

abstract class AbstractLine
implements Line {
    protected Line.Info info;
    protected Control[] controls;
    protected AbstractMixer mixer;
    private boolean open = false;
    private Vector listeners = new Vector();
    private static final EventDispatcher eventDispatcher = new EventDispatcher();

    protected AbstractLine(Line.Info info, AbstractMixer mixer, Control[] controls) {
        if (controls == null) {
            controls = new Control[]{};
        }
        this.info = info;
        this.mixer = mixer;
        this.controls = controls;
    }

    public Line.Info getLineInfo() {
        return this.info;
    }

    public boolean isOpen() {
        return this.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLineListener(LineListener listener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (!this.listeners.contains(listener)) {
                this.listeners.addElement(listener);
            }
        }
    }

    public void removeLineListener(LineListener listener) {
        this.listeners.removeElement(listener);
    }

    public Control[] getControls() {
        Control[] returnedArray = new Control[this.controls.length];
        for (int i = 0; i < this.controls.length; ++i) {
            returnedArray[i] = this.controls[i];
        }
        return returnedArray;
    }

    public boolean isControlSupported(Control.Type controlType) {
        if (controlType == null) {
            return false;
        }
        for (int i = 0; i < this.controls.length; ++i) {
            if (controlType != this.controls[i].getType()) continue;
            return true;
        }
        return false;
    }

    public Control getControl(Control.Type controlType) {
        if (controlType != null) {
            for (int i = 0; i < this.controls.length; ++i) {
                if (controlType != this.controls[i].getType()) continue;
                return this.controls[i];
            }
        }
        throw new IllegalArgumentException("Unsupported control type: " + controlType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOpen(boolean open) {
        boolean sendEvents = false;
        long position = this.getLongFramePosition();
        AbstractLine abstractLine = this;
        synchronized (abstractLine) {
            if (this.open != open) {
                this.open = open;
                sendEvents = true;
            }
        }
        if (sendEvents) {
            if (open) {
                this.sendEvents(new LineEvent(this, LineEvent.Type.OPEN, position));
            } else {
                this.sendEvents(new LineEvent(this, LineEvent.Type.CLOSE, position));
            }
        }
    }

    protected void sendEvents(LineEvent event) {
        eventDispatcher.sendAudioEvents(event, this.listeners);
    }

    public final int getFramePosition() {
        return (int)this.getLongFramePosition();
    }

    public long getLongFramePosition() {
        return -1L;
    }

    protected AbstractMixer getMixer() {
        return this.mixer;
    }

    protected EventDispatcher getEventDispatcher() {
        return eventDispatcher;
    }

    public abstract void open() throws LineUnavailableException;

    public abstract void close();

    static {
        eventDispatcher.start();
    }
}

