/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.www.protocol.https;

import com.sun.net.ssl.HostnameVerifier;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.kerberos.KerberosPrincipal;
import sun.security.util.DerValue;
import sun.security.util.HostnameChecker;
import sun.security.x509.X500Name;

class VerifierWrapper
implements javax.net.ssl.HostnameVerifier {
    private HostnameVerifier verifier;

    VerifierWrapper(HostnameVerifier verifier) {
        this.verifier = verifier;
    }

    public boolean verify(String hostname, SSLSession session) {
        try {
            String serverName;
            Principal principal = this.getPeerPrincipal(session);
            if (principal instanceof KerberosPrincipal) {
                serverName = HostnameChecker.getServerName((KerberosPrincipal)principal);
            } else {
                Certificate[] serverChain = session.getPeerCertificates();
                if (serverChain == null || serverChain.length == 0) {
                    return false;
                }
                if (!(serverChain[0] instanceof X509Certificate)) {
                    return false;
                }
                X509Certificate serverCert = (X509Certificate)serverChain[0];
                serverName = VerifierWrapper.getServername(serverCert);
            }
            if (serverName == null) {
                return false;
            }
            return this.verifier.verify(hostname, serverName);
        }
        catch (SSLPeerUnverifiedException e) {
            return false;
        }
    }

    private Principal getPeerPrincipal(SSLSession session) throws SSLPeerUnverifiedException {
        Principal principal;
        try {
            principal = session.getPeerPrincipal();
        }
        catch (AbstractMethodError e) {
            principal = null;
        }
        return principal;
    }

    private static String getServername(X509Certificate peerCert) {
        try {
            X500Name subject;
            DerValue derValue;
            Collection<List<?>> subjAltNames = peerCert.getSubjectAlternativeNames();
            if (subjAltNames != null) {
                for (List<?> next : subjAltNames) {
                    if ((Integer)next.get(0) != 2) continue;
                    String dnsName = (String)next.get(1);
                    return dnsName;
                }
            }
            if ((derValue = (subject = HostnameChecker.getSubjectX500Name(peerCert)).findMostSpecificAttribute(X500Name.commonName_oid)) != null) {
                try {
                    String name = derValue.getAsString();
                    return name;
                }
                catch (IOException e) {}
            }
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return null;
    }
}

