/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.content.x509;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509DataContent;
import com.sun.org.apache.xml.internal.security.utils.RFC2253Parser;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLX509SubjectName
extends SignatureElementProxy
implements XMLX509DataContent {
    static Logger log = Logger.getLogger(XMLX509SubjectName.class.getName());

    public XMLX509SubjectName(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
    }

    public XMLX509SubjectName(Document doc, String X509SubjectNameString) {
        super(doc);
        this.addText(X509SubjectNameString);
    }

    public XMLX509SubjectName(Document doc, X509Certificate x509certificate) {
        this(doc, RFC2253Parser.normalize(x509certificate.getSubjectDN().getName()));
    }

    public String getSubjectName() {
        return RFC2253Parser.normalize(this.getTextFromTextChild());
    }

    public boolean equals(Object obj) {
        String thisSubject;
        if (!obj.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        XMLX509SubjectName other = (XMLX509SubjectName)obj;
        String otherSubject = other.getSubjectName();
        return otherSubject.equals(thisSubject = this.getSubjectName());
    }

    public String getBaseLocalName() {
        return "X509SubjectName";
    }
}

