/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.DSAKeyValue;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class DSAKeyValueResolver
extends KeyResolverSpi {
    private Element _dsaKeyElement = null;

    public boolean engineCanResolve(Element element, String BaseURI, StorageResolver storage) {
        if (element == null) {
            return false;
        }
        boolean isKeyValue = XMLUtils.elementIsInSignatureSpace(element, "KeyValue");
        boolean isDSAKeyValue = XMLUtils.elementIsInSignatureSpace(element, "DSAKeyValue");
        if (isKeyValue) {
            this._dsaKeyElement = XMLUtils.selectDsNode(element.getFirstChild(), "DSAKeyValue", 0);
            if (this._dsaKeyElement != null) {
                return true;
            }
        } else if (isDSAKeyValue) {
            this._dsaKeyElement = element;
            return true;
        }
        return false;
    }

    public PublicKey engineResolvePublicKey(Element element, String BaseURI, StorageResolver storage) {
        boolean weCanResolve;
        if (!(this._dsaKeyElement != null || (weCanResolve = this.engineCanResolve(element, BaseURI, storage)) && this._dsaKeyElement != null)) {
            return null;
        }
        try {
            DSAKeyValue dsaKeyValue = new DSAKeyValue(this._dsaKeyElement, BaseURI);
            PublicKey pk = dsaKeyValue.getPublicKey();
            return pk;
        }
        catch (XMLSecurityException ex) {
            return null;
        }
    }

    public X509Certificate engineResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }

    public SecretKey engineResolveSecretKey(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }
}

