/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.storage.implementations;

import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509SKI;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolverException;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolverSpi;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CertsInFilesystemDirectoryResolver
extends StorageResolverSpi {
    static Logger log = Logger.getLogger(CertsInFilesystemDirectoryResolver.class.getName());
    String _merlinsCertificatesDir = null;
    private List _certs = new ArrayList();
    Iterator _iterator = null;

    public CertsInFilesystemDirectoryResolver(String directoryName) throws StorageResolverException {
        this._merlinsCertificatesDir = directoryName;
        this.readCertsFromHarddrive();
        this._iterator = new FilesystemIterator(this._certs);
    }

    private void readCertsFromHarddrive() throws StorageResolverException {
        File certDir = new File(this._merlinsCertificatesDir);
        ArrayList<String> al = new ArrayList<String>();
        String[] names = certDir.list();
        for (int i = 0; i < names.length; ++i) {
            String currentFileName = names[i];
            if (!currentFileName.endsWith(".crt")) continue;
            al.add(names[i]);
        }
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException ex) {
            throw new StorageResolverException("empty", ex);
        }
        if (cf == null) {
            throw new StorageResolverException("empty");
        }
        for (int i = 0; i < al.size(); ++i) {
            String dn;
            boolean added;
            block15: {
                String filename = certDir.getAbsolutePath() + File.separator + (String)al.get(i);
                File file = new File(filename);
                added = false;
                dn = null;
                try {
                    FileInputStream fis = new FileInputStream(file);
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(fis);
                    fis.close();
                    cert.checkValidity();
                    this._certs.add(cert);
                    dn = cert.getSubjectDN().getName();
                    added = true;
                }
                catch (FileNotFoundException ex) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Could not add certificate from file " + filename, ex);
                    }
                }
                catch (IOException ex) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Could not add certificate from file " + filename, ex);
                    }
                }
                catch (CertificateNotYetValidException ex) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Could not add certificate from file " + filename, ex);
                    }
                }
                catch (CertificateExpiredException ex) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Could not add certificate from file " + filename, ex);
                    }
                }
                catch (CertificateException ex) {
                    if (!log.isLoggable(Level.FINE)) break block15;
                    log.log(Level.FINE, "Could not add certificate from file " + filename, ex);
                }
            }
            if (!added || !log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "Added certificate: " + dn);
        }
    }

    public Iterator getIterator() {
        return this._iterator;
    }

    public static void main(String[] unused) throws Exception {
        CertsInFilesystemDirectoryResolver krs = new CertsInFilesystemDirectoryResolver("data/ie/baltimore/merlin-examples/merlin-xmldsig-eighteen/certs");
        Iterator i = krs.getIterator();
        while (i.hasNext()) {
            X509Certificate cert = (X509Certificate)i.next();
            byte[] ski = XMLX509SKI.getSKIBytesFromCert(cert);
            System.out.println();
            System.out.println("Base64(SKI())=                 \"" + Base64.encode(ski) + "\"");
            System.out.println("cert.getSerialNumber()=        \"" + cert.getSerialNumber().toString() + "\"");
            System.out.println("cert.getSubjectDN().getName()= \"" + cert.getSubjectDN().getName() + "\"");
            System.out.println("cert.getIssuerDN().getName()=  \"" + cert.getIssuerDN().getName() + "\"");
        }
    }

    class FilesystemIterator
    implements Iterator {
        List _certs = null;
        int _i;

        public FilesystemIterator(List certs) {
            this._certs = certs;
            this._i = 0;
        }

        public boolean hasNext() {
            return this._i < this._certs.size();
        }

        public Object next() {
            return this._certs.get(this._i++);
        }

        public void remove() {
            throw new UnsupportedOperationException("Can't remove keys from KeyStore");
        }
    }
}

