/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import com.sun.org.apache.xml.internal.security.utils.UnsyncByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaUtils {
    static Logger log = Logger.getLogger(JavaUtils.class.getName());

    private JavaUtils() {
    }

    public static byte[] getBytesFromFile(String fileName) throws FileNotFoundException, IOException {
        int len;
        byte[] refBytes = null;
        FileInputStream fisRef = new FileInputStream(fileName);
        UnsyncByteArrayOutputStream baos = new UnsyncByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = fisRef.read(buf)) > 0) {
            baos.write(buf, 0, len);
        }
        refBytes = baos.toByteArray();
        return refBytes;
    }

    public static void writeBytesToFilename(String filename, byte[] bytes) {
        try {
            if (filename != null && bytes != null) {
                File f = new File(filename);
                FileOutputStream fos = new FileOutputStream(f);
                fos.write(bytes);
                fos.close();
            } else if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "writeBytesToFilename got null byte[] pointed");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] getBytesFromStream(InputStream inputStream) throws IOException {
        int len;
        byte[] refBytes = null;
        UnsyncByteArrayOutputStream baos = new UnsyncByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = inputStream.read(buf)) > 0) {
            baos.write(buf, 0, len);
        }
        refBytes = baos.toByteArray();
        return refBytes;
    }
}

