/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.CheckboxPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Checkbox
extends Component
implements ItemSelectable,
Accessible {
    String label;
    boolean state;
    CheckboxGroup group;
    transient ItemListener itemListener;
    private static final String base = "checkbox";
    private static int nameCounter;
    private static final long serialVersionUID = 7270714317450821763L;
    private int checkboxSerializedDataVersion = 1;

    void setStateInternal(boolean state) {
        this.state = state;
        CheckboxPeer peer = (CheckboxPeer)this.peer;
        if (peer != null) {
            peer.setState(state);
        }
    }

    public Checkbox() throws HeadlessException {
        this("", false, null);
    }

    public Checkbox(String label) throws HeadlessException {
        this(label, false, null);
    }

    public Checkbox(String label, boolean state) throws HeadlessException {
        this(label, state, null);
    }

    public Checkbox(String label, boolean state, CheckboxGroup group) throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.label = label;
        this.state = state;
        this.group = group;
        if (state && group != null) {
            group.setSelectedCheckbox(this);
        }
    }

    public Checkbox(String label, CheckboxGroup group, boolean state) throws HeadlessException {
        this(label, state, group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<Checkbox> clazz = Checkbox.class;
        synchronized (Checkbox.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createCheckbox(this);
            }
            super.addNotify();
        }
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabel(String label) {
        boolean testvalid = false;
        Checkbox checkbox = this;
        synchronized (checkbox) {
            if (!(label == this.label || this.label != null && this.label.equals(label))) {
                this.label = label;
                CheckboxPeer peer = (CheckboxPeer)this.peer;
                if (peer != null) {
                    peer.setLabel(label);
                }
                testvalid = true;
            }
        }
        if (testvalid) {
            this.invalidateIfValid();
        }
    }

    public boolean getState() {
        return this.state;
    }

    public void setState(boolean state) {
        CheckboxGroup group = this.group;
        if (group != null) {
            if (state) {
                group.setSelectedCheckbox(this);
            } else if (group.getSelectedCheckbox() == this) {
                state = true;
            }
        }
        this.setStateInternal(state);
    }

    @Override
    public Object[] getSelectedObjects() {
        if (this.state) {
            Object[] items = new Object[]{this.label};
            return items;
        }
        return null;
    }

    public CheckboxGroup getCheckboxGroup() {
        return this.group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckboxGroup(CheckboxGroup g) {
        boolean oldState;
        CheckboxGroup oldGroup;
        if (this.group == g) {
            return;
        }
        Checkbox checkbox = this;
        synchronized (checkbox) {
            oldGroup = this.group;
            oldState = this.getState();
            this.group = g;
            CheckboxPeer peer = (CheckboxPeer)this.peer;
            if (peer != null) {
                peer.setCheckboxGroup(g);
            }
            if (this.group != null && this.getState()) {
                if (this.group.getSelectedCheckbox() != null) {
                    this.setState(false);
                } else {
                    this.group.setSelectedCheckbox(this);
                }
            }
        }
        if (oldGroup != null && oldState) {
            oldGroup.setSelectedCheckbox(null);
        }
    }

    @Override
    public synchronized void addItemListener(ItemListener l) {
        if (l == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
        this.newEventsOnly = true;
    }

    @Override
    public synchronized void removeItemListener(ItemListener l) {
        if (l == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    public synchronized ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(ItemListener.class);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        ItemListener l = null;
        if (listenerType != ItemListener.class) {
            return super.getListeners(listenerType);
        }
        l = this.itemListener;
        return AWTEventMulticaster.getListeners((EventListener)l, listenerType);
    }

    @Override
    boolean eventEnabled(AWTEvent e) {
        if (e.id == 701) {
            return (this.eventMask & 0x200L) != 0L || this.itemListener != null;
        }
        return super.eventEnabled(e);
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processItemEvent(ItemEvent e) {
        ItemListener listener = this.itemListener;
        if (listener != null) {
            listener.itemStateChanged(e);
        }
    }

    @Override
    protected String paramString() {
        String str = super.paramString();
        String label = this.label;
        if (label != null) {
            str = str + ",label=" + label;
        }
        return str + ",state=" + this.state;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster.save(s, "itemL", this.itemListener);
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException, HeadlessException {
        Object keyOrNull;
        GraphicsEnvironment.checkHeadless();
        s.defaultReadObject();
        while (null != (keyOrNull = s.readObject())) {
            String key = ((String)keyOrNull).intern();
            if ("itemL" == key) {
                this.addItemListener((ItemListener)s.readObject());
                continue;
            }
            s.readObject();
        }
    }

    private static native void initIDs();

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTCheckbox();
        }
        return this.accessibleContext;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Checkbox.initIDs();
        }
        nameCounter = 0;
    }

    protected class AccessibleAWTCheckbox
    extends Component.AccessibleAWTComponent
    implements ItemListener,
    AccessibleAction,
    AccessibleValue {
        private static final long serialVersionUID = 7881579233144754107L;

        public AccessibleAWTCheckbox() {
            super(Checkbox.this);
            Checkbox.this.addItemListener(this);
        }

        public void itemStateChanged(ItemEvent e) {
            Checkbox cb = (Checkbox)e.getSource();
            if (Checkbox.this.accessibleContext != null) {
                if (cb.getState()) {
                    Checkbox.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.CHECKED);
                } else {
                    Checkbox.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.CHECKED, null);
                }
            }
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 0;
        }

        public String getAccessibleActionDescription(int i) {
            return null;
        }

        public boolean doAccessibleAction(int i) {
            return false;
        }

        public Number getCurrentAccessibleValue() {
            return null;
        }

        public boolean setCurrentAccessibleValue(Number n) {
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return null;
        }

        public Number getMaximumAccessibleValue() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.CHECK_BOX;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (Checkbox.this.getState()) {
                states.add(AccessibleState.CHECKED);
            }
            return states;
        }
    }
}

