/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.PaintContext;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import sun.awt.image.IntegerComponentRaster;

class ColorPaintContext
implements PaintContext {
    int color;
    WritableRaster savedTile;

    protected ColorPaintContext(int color, ColorModel cm) {
        this.color = color;
    }

    public void dispose() {
    }

    int getRGB() {
        return this.color;
    }

    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    public synchronized Raster getRaster(int x, int y, int w, int h) {
        WritableRaster t = this.savedTile;
        if (t == null || w > t.getWidth() || h > t.getHeight()) {
            t = this.getColorModel().createCompatibleWritableRaster(w, h);
            IntegerComponentRaster icr = (IntegerComponentRaster)t;
            Arrays.fill(icr.getDataStorage(), this.color);
            icr.markDirty();
            if (w <= 64 && h <= 64) {
                this.savedTile = t;
            }
        }
        return t;
    }
}

