/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Conditional;
import java.awt.Container;
import java.awt.EventFilter;
import java.awt.EventQueue;
import java.awt.ModalEventFilter;
import java.awt.Window;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.AWTAutoShutdown;
import sun.awt.ModalExclude;
import sun.awt.SunToolkit;
import sun.awt.dnd.SunDragSourceContextPeer;
import sun.security.action.GetPropertyAction;

class EventDispatchThread
extends Thread {
    private static final Logger eventLog = Logger.getLogger("java.awt.event.EventDispatchThread");
    private EventQueue theQueue;
    private boolean doDispatch = true;
    private static final int ANY_EVENT = -1;
    private Vector<EventFilter> eventFilters = new Vector();
    private int modalFiltersCount = 0;
    private static final String handlerPropName = "sun.awt.exception.handler";
    private static String handlerClassName = null;
    private static String NO_HANDLER = new String();

    EventDispatchThread(ThreadGroup group, String name, EventQueue queue) {
        super(group, name);
        this.theQueue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopDispatchingImpl(boolean wait) {
        StopDispatchEvent stopEvent = new StopDispatchEvent();
        if (Thread.currentThread() != this) {
            this.theQueue.postEventPrivate(stopEvent);
            if (wait) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            stopEvent.dispatch();
        }
        EventQueue eventQueue = this.theQueue;
        synchronized (eventQueue) {
            if (this.theQueue.getDispatchThread() == this) {
                this.theQueue.detachDispatchThread();
            }
        }
    }

    public void stopDispatching() {
        this.stopDispatchingImpl(true);
    }

    public void stopDispatchingLater() {
        this.stopDispatchingImpl(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.pumpEvents(new Conditional(){

                public boolean evaluate() {
                    return true;
                }
            });
        }
        finally {
            EventQueue eventQueue = this.theQueue;
            synchronized (eventQueue) {
                if (this.theQueue.getDispatchThread() == this) {
                    this.theQueue.detachDispatchThread();
                }
                if (this.theQueue.peekEvent() != null || !SunToolkit.isPostEventQueueEmpty()) {
                    this.theQueue.initDispatchThread();
                }
                AWTAutoShutdown.getInstance().notifyThreadFree(this);
            }
        }
    }

    void pumpEvents(Conditional cond) {
        this.pumpEvents(-1, cond);
    }

    void pumpEventsForHierarchy(Conditional cond, Component modalComponent) {
        this.pumpEventsForHierarchy(-1, cond, modalComponent);
    }

    void pumpEvents(int id, Conditional cond) {
        this.pumpEventsForHierarchy(id, cond, null);
    }

    void pumpEventsForHierarchy(int id, Conditional cond, Component modalComponent) {
        this.pumpEventsForFilter(id, cond, new HierarchyEventFilter(modalComponent));
    }

    void pumpEventsForFilter(Conditional cond, EventFilter filter) {
        this.pumpEventsForFilter(-1, cond, filter);
    }

    void pumpEventsForFilter(int id, Conditional cond, EventFilter filter) {
        this.addEventFilter(filter);
        while (this.doDispatch && cond.evaluate()) {
            if (!this.isInterrupted() && this.pumpOneEventForFilters(id)) continue;
            this.doDispatch = false;
        }
        this.removeEventFilter(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEventFilter(EventFilter filter) {
        Vector<EventFilter> vector = this.eventFilters;
        synchronized (vector) {
            if (!this.eventFilters.contains(filter)) {
                if (filter instanceof ModalEventFilter) {
                    ModalEventFilter cf;
                    EventFilter f;
                    ModalEventFilter newFilter = (ModalEventFilter)filter;
                    int k = 0;
                    for (k = 0; !(k >= this.eventFilters.size() || (f = this.eventFilters.get(k)) instanceof ModalEventFilter && (cf = (ModalEventFilter)f).compareTo(newFilter) > 0); ++k) {
                    }
                    this.eventFilters.add(k, filter);
                    ++this.modalFiltersCount;
                } else {
                    this.eventFilters.add(filter);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEventFilter(EventFilter filter) {
        Vector<EventFilter> vector = this.eventFilters;
        synchronized (vector) {
            if (this.eventFilters.contains(filter)) {
                if (filter instanceof ModalEventFilter) {
                    --this.modalFiltersCount;
                }
                this.eventFilters.remove(filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean pumpOneEventForFilters(int id) {
        try {
            AWTEvent event;
            boolean eventOK;
            do {
                event = id == -1 ? this.theQueue.getNextEvent() : this.theQueue.getNextEvent(id);
                eventOK = true;
                Vector<EventFilter> vector = this.eventFilters;
                synchronized (vector) {
                    for (int i = this.eventFilters.size() - 1; i >= 0; --i) {
                        EventFilter f = this.eventFilters.get(i);
                        EventFilter.FilterAction accept = f.acceptEvent(event);
                        if (accept == EventFilter.FilterAction.REJECT) {
                            eventOK = false;
                            break;
                        }
                        if (accept == EventFilter.FilterAction.ACCEPT_IMMEDIATELY) break;
                    }
                }
                boolean bl = eventOK = eventOK && SunDragSourceContextPeer.checkEvent(event);
                if (eventOK) continue;
                event.consume();
            } while (!eventOK);
            if (eventLog.isLoggable(Level.FINEST)) {
                eventLog.log(Level.FINEST, "Dispatching: " + event);
            }
            this.theQueue.dispatchEvent(event);
            return true;
        }
        catch (ThreadDeath death) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (Throwable e) {
            this.processException(e, this.modalFiltersCount > 0);
            return true;
        }
    }

    private void processException(Throwable e, boolean isModal) {
        if (eventLog.isLoggable(Level.FINE)) {
            eventLog.log(Level.FINE, "Processing exception: " + e + ", isModal = " + isModal);
        }
        if (!this.handleException(e)) {
            if (isModal) {
                System.err.println("Exception occurred during event dispatching:");
                e.printStackTrace();
            } else {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
            }
        }
    }

    private boolean handleException(Throwable thrown) {
        try {
            Object h;
            Method m;
            if (handlerClassName == NO_HANDLER) {
                return false;
            }
            if (handlerClassName == null && (handlerClassName = AccessController.doPrivileged(new GetPropertyAction(handlerPropName))) == null) {
                handlerClassName = NO_HANDLER;
                return false;
            }
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> c = Class.forName(handlerClassName, true, cl);
                m = c.getMethod("handle", Throwable.class);
                h = c.newInstance();
            }
            catch (Throwable x) {
                handlerClassName = NO_HANDLER;
                return false;
            }
            m.invoke(h, thrown);
        }
        catch (Throwable x) {
            return false;
        }
        return true;
    }

    boolean isDispatching(EventQueue eq) {
        return this.theQueue.equals(eq);
    }

    EventQueue getEventQueue() {
        return this.theQueue;
    }

    private static class HierarchyEventFilter
    implements EventFilter {
        private Component modalComponent;

        public HierarchyEventFilter(Component modalComponent) {
            this.modalComponent = modalComponent;
        }

        public EventFilter.FilterAction acceptEvent(AWTEvent event) {
            if (this.modalComponent != null) {
                boolean windowClosingEvent;
                int eventID = event.getID();
                boolean mouseEvent = eventID >= 500 && eventID <= 507;
                boolean actionEvent = eventID >= 1001 && eventID <= 1001;
                boolean bl = windowClosingEvent = eventID == 201;
                if (Component.isInstanceOf(this.modalComponent, "javax.swing.JInternalFrame")) {
                    return windowClosingEvent ? EventFilter.FilterAction.REJECT : EventFilter.FilterAction.ACCEPT;
                }
                if (mouseEvent || actionEvent || windowClosingEvent) {
                    Object o = event.getSource();
                    if (o instanceof ModalExclude) {
                        return EventFilter.FilterAction.ACCEPT;
                    }
                    if (o instanceof Component) {
                        Component c;
                        boolean modalExcluded = false;
                        if (this.modalComponent instanceof Container) {
                            for (c = (Component)o; c != this.modalComponent && c != null; c = c.getParent()) {
                                if (!(c instanceof Window) || !SunToolkit.isModalExcluded((Window)c)) continue;
                                modalExcluded = true;
                                break;
                            }
                        }
                        if (!modalExcluded && c != this.modalComponent) {
                            return EventFilter.FilterAction.REJECT;
                        }
                    }
                }
            }
            return EventFilter.FilterAction.ACCEPT;
        }
    }

    class StopDispatchEvent
    extends AWTEvent
    implements ActiveEvent {
        static final long serialVersionUID = -3692158172100730735L;

        public StopDispatchEvent() {
            super(EventDispatchThread.this, 0);
        }

        public void dispatch() {
            EventDispatchThread.this.doDispatch = false;
        }
    }
}

